/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.karaf.commands.dm.targets;

import java.io.PrintStream;
import java.util.logging.Logger;
import net.roboconf.core.utils.ManifestUtils;
import net.roboconf.karaf.commands.dm.targets.SupportedTarget;
import net.roboconf.karaf.commands.dm.targets.TargetCompleter;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.Session;

@Command(scope="roboconf", name="target", description="Installs a target when necessary")
@Service
public class InstallTargetCommand
implements Action {
    @Argument(index=0, name="target", description="The target's name.", required=true, multiValued=false)
    @Completion(value=TargetCompleter.class)
    String targetName = null;
    @Reference
    private Session session;
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    String roboconfVersion;
    PrintStream out = System.out;

    public InstallTargetCommand() {
        String bundleVersion = ManifestUtils.findBundleVersion();
        this.roboconfVersion = ManifestUtils.findMavenVersion((String)bundleVersion);
    }

    public Object execute() throws Exception {
        SupportedTarget st = SupportedTarget.which(this.targetName);
        if (st == null) {
            this.out.println("Unknown target: " + this.targetName + ". Make sure it is correct or install it manually.");
        } else if (this.roboconfVersion == null) {
            this.out.println("Error: the Roboconf version could not be determined.");
        } else {
            for (String cmd : st.findCommands(this.roboconfVersion)) {
                this.logger.fine("Executing " + cmd + "...");
                this.out.println("Executing " + cmd + "...");
                this.session.execute((CharSequence)cmd);
            }
        }
        return null;
    }
}

