/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.internal;

import java.net.URL;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.EventListener;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletException;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.service.SharedWebContainerContext;
import org.ops4j.pax.web.service.internal.HttpServiceStarted;
import org.ops4j.pax.web.service.internal.HttpServiceStopped;
import org.ops4j.pax.web.service.internal.StoppableHttpService;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.NamespaceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServiceProxy
implements StoppableHttpService {
    private static final Logger LOG = LoggerFactory.getLogger(HttpServiceProxy.class);
    private StoppableHttpService delegate;

    public HttpServiceProxy(StoppableHttpService delegate) {
        NullArgumentException.validateNotNull(delegate, "Delegate");
        LOG.debug("HttpServiceProxy created for HttpService {}", (Object)delegate);
        this.delegate = delegate;
    }

    public void registerServlet(String alias, Servlet servlet, Dictionary initParams, HttpContext httpContext) throws ServletException, NamespaceException {
        LOG.debug("Registering servlet: [" + alias + "] -> " + servlet);
        this.delegate.registerServlet(alias, servlet, initParams, httpContext);
    }

    public void registerResources(String alias, String name, HttpContext httpContext) throws NamespaceException {
        LOG.debug("Registering resource: [" + alias + "] -> " + name);
        this.delegate.registerResources(alias, name, httpContext);
    }

    public void unregister(String alias) {
        LOG.debug("Unregistering [" + alias + "]");
        this.delegate.unregister(alias);
    }

    public HttpContext createDefaultHttpContext() {
        LOG.debug("Creating a default context");
        return this.delegate.createDefaultHttpContext();
    }

    public HttpContext createDefaultHttpContext(String contextID) {
        LOG.debug("Creating a default context with id {}", (Object)contextID);
        return this.delegate.createDefaultHttpContext(contextID);
    }

    @Override
    public synchronized void stop() {
        LOG.debug("Stopping http service: [" + this + " -> " + this.delegate + "]");
        StoppableHttpService stopping = this.delegate;
        this.delegate = stopping instanceof HttpServiceStarted ? new HttpServiceStopped((HttpServiceStarted)stopping) : new HttpServiceStopped();
        stopping.stop();
    }

    public void registerServlet(Servlet servlet, String[] urlPatterns, Dictionary<String, ?> initParams, HttpContext httpContext) throws ServletException {
        LOG.debug("Registering servlet [" + servlet + "]");
        this.delegate.registerServlet(servlet, urlPatterns, initParams, httpContext);
    }

    public void registerServlet(Servlet servlet, String servletName, String[] urlPatterns, Dictionary<String, ?> initParams, HttpContext httpContext) throws ServletException {
        LOG.debug("Registering servlet [" + servlet + "] with name [" + servletName + "]");
        this.delegate.registerServlet(servlet, servletName, urlPatterns, initParams, httpContext);
    }

    public void unregisterServlet(Servlet servlet) {
        LOG.debug("Unregistering servlet [" + servlet + "]");
        this.delegate.unregisterServlet(servlet);
    }

    public void registerServlet(Class<? extends Servlet> servletClass, String[] urlPatterns, Dictionary<String, ?> initParams, HttpContext httpContext) throws ServletException {
        LOG.debug("Registering servlet class [{}]", servletClass);
        this.delegate.registerServlet(servletClass, urlPatterns, initParams, httpContext);
    }

    public void unregisterServlets(Class<? extends Servlet> servletClass) {
        LOG.debug("Unregistering servlet class [{}]", servletClass);
        this.delegate.unregisterServlets(servletClass);
    }

    public void registerEventListener(EventListener listener, HttpContext httpContext) {
        LOG.debug("Registering event listener [" + listener + "]");
        this.delegate.registerEventListener(listener, httpContext);
    }

    public void unregisterEventListener(EventListener listener) {
        LOG.debug("Unregistering event listener [" + listener + "]");
        this.delegate.unregisterEventListener(listener);
    }

    public void registerFilter(Filter filter, String[] urlPatterns, String[] aliases, Dictionary<String, ?> initParams, HttpContext httpContext) {
        LOG.debug("Registering filter [" + filter + "]");
        this.delegate.registerFilter(filter, urlPatterns, aliases, initParams, httpContext);
    }

    public void registerFilter(Class<? extends Filter> filterClass, String[] urlPatterns, String[] servletNames, Dictionary<String, String> initParams, HttpContext httpContext) {
        LOG.debug("Registering filter with class [" + filterClass + "]");
        this.delegate.registerFilter(filterClass, urlPatterns, servletNames, initParams, httpContext);
    }

    public void unregisterFilter(Filter filter) {
        LOG.debug("Unregistering filter [" + filter + "]");
        this.delegate.unregisterFilter(filter);
    }

    public void unregisterFilter(Class<? extends Filter> filterClass) {
        LOG.debug("Unregistering filter [" + filterClass + "]");
        this.delegate.unregisterFilter(filterClass);
    }

    public void unregisterFilter(String filterName) {
        LOG.debug("Unregistering filter [" + filterName + "]");
        this.delegate.unregisterFilter(filterName);
    }

    public void setContextParam(Dictionary<String, ?> params, HttpContext httpContext) {
        LOG.debug("Setting context paramters [" + params + "] for http context [" + httpContext + "]");
        this.delegate.setContextParam(params, httpContext);
    }

    public void setSessionTimeout(Integer minutes, HttpContext httpContext) {
        LOG.debug("Setting session timeout to " + minutes + " minutes for http context [" + httpContext + "]");
        this.delegate.setSessionTimeout(minutes, httpContext);
    }

    public void registerJsps(String[] urlPatterns, HttpContext httpContext) {
        LOG.debug("Registering jsps");
        this.delegate.registerJsps(urlPatterns, httpContext);
    }

    public void registerJsps(String[] urlPatterns, Dictionary<String, ?> initParams, HttpContext httpContext) {
        LOG.debug("Registering jsps");
        this.delegate.registerJsps(urlPatterns, initParams, httpContext);
    }

    public void unregisterJsps(HttpContext httpContext) {
        LOG.debug("Unregistering jsps");
        this.delegate.unregisterJsps(httpContext);
    }

    public void unregisterJsps(String[] urlPatterns, HttpContext httpContext) {
        LOG.debug("Unregistering jsps");
        this.delegate.unregisterJsps(urlPatterns, httpContext);
    }

    public void registerErrorPage(String error, String location, HttpContext httpContext) {
        LOG.debug("Registering error page [" + error + "]");
        this.delegate.registerErrorPage(error, location, httpContext);
    }

    public void unregisterErrorPage(String error, HttpContext httpContext) {
        LOG.debug("Unregistering error page [" + error + "]");
        this.delegate.unregisterErrorPage(error, httpContext);
    }

    public void registerWelcomeFiles(String[] welcomeFiles, boolean redirect, HttpContext httpContext) {
        LOG.debug("Registering welcome files [" + Arrays.toString(welcomeFiles) + "]");
        this.delegate.registerWelcomeFiles(welcomeFiles, redirect, httpContext);
    }

    public void unregisterWelcomeFiles(String[] welcomeFiles, HttpContext httpContext) {
        LOG.debug("Unregistering welcome files");
        this.delegate.unregisterWelcomeFiles(welcomeFiles, httpContext);
    }

    public void registerLoginConfig(String authMethod, String realmName, String formLoginPage, String formErrorPage, HttpContext httpContext) {
        LOG.debug("Registering LoginConfig for realm [ " + realmName + " ]");
        this.delegate.registerLoginConfig(authMethod, realmName, formLoginPage, formErrorPage, httpContext);
    }

    public void unregisterLoginConfig(HttpContext httpContext) {
        LOG.debug("Unregistering LoginConfig");
        this.delegate.unregisterLoginConfig(httpContext);
    }

    public void registerConstraintMapping(String constraintName, String url, String mapping, String dataConstraint, boolean authentication, List<String> roles, HttpContext httpContext) {
        LOG.debug("Registering constraint mapping for [ " + constraintName + " ] ");
        this.delegate.registerConstraintMapping(constraintName, url, mapping, dataConstraint, authentication, roles, httpContext);
    }

    public void unregisterConstraintMapping(HttpContext httpContext) {
        LOG.debug("Unregister constraint mapping");
        this.delegate.unregisterConstraintMapping(httpContext);
    }

    public SharedWebContainerContext getDefaultSharedHttpContext() {
        return this.delegate.getDefaultSharedHttpContext();
    }

    public void registerServletContainerInitializer(ServletContainerInitializer servletContainerInitializer, Class<?>[] classes, HttpContext httpContext) {
        this.delegate.registerServletContainerInitializer(servletContainerInitializer, classes, httpContext);
    }

    public void unregisterServletContainerInitializer(HttpContext httpContext) {
        this.delegate.unregisterServletContainerInitializer(httpContext);
    }

    public void registerJettyWebXml(URL jettyWebXmlURL, HttpContext httpContext) {
        this.delegate.registerJettyWebXml(jettyWebXmlURL, httpContext);
    }

    public void registerJspServlet(String[] urlPatterns, HttpContext httpContext, String jspFile) {
        this.delegate.registerJspServlet(urlPatterns, httpContext, jspFile);
    }

    public void registerJspServlet(String[] urlPatterns, Dictionary<String, ?> initParams, HttpContext httpContext, String jspFile) {
        this.delegate.registerJspServlet(urlPatterns, initParams, httpContext, jspFile);
    }

    public void setConnectorsAndVirtualHosts(List<String> connectors, List<String> virtualHosts, HttpContext httpContext) {
        this.delegate.setConnectorsAndVirtualHosts(connectors, virtualHosts, httpContext);
    }

    public void begin(HttpContext httpContext) {
        this.delegate.begin(httpContext);
    }

    public void end(HttpContext httpContext) {
        this.delegate.end(httpContext);
    }

    public void registerServlet(Servlet servlet, String[] urlPatterns, Dictionary<String, ?> initParams, Integer loadOnStartup, Boolean asyncSupported, HttpContext httpContext) throws ServletException {
        this.delegate.registerServlet(servlet, urlPatterns, initParams, loadOnStartup, asyncSupported, httpContext);
    }

    public void registerServlet(Servlet servlet, String servletName, String[] urlPatterns, Dictionary<String, ?> initParams, Integer loadOnStartup, Boolean asyncSupported, HttpContext httpContext) throws ServletException {
        this.delegate.registerServlet(servlet, servletName, urlPatterns, initParams, loadOnStartup, asyncSupported, httpContext);
    }

    public void registerServlet(Class<? extends Servlet> servletClass, String[] urlPatterns, Dictionary<String, ?> initParams, Integer loadOnStartup, Boolean asyncSupported, HttpContext httpContext) throws ServletException {
        this.delegate.registerServlet(servletClass, urlPatterns, initParams, loadOnStartup, asyncSupported, httpContext);
    }

    public void registerServlet(String alias, Servlet servlet, Dictionary initParams, Integer loadOnStartup, Boolean asyncSupported, HttpContext httpContext) throws ServletException, NamespaceException {
        this.delegate.registerServlet(alias, servlet, initParams, loadOnStartup, asyncSupported, httpContext);
    }

    public void registerServlet(Servlet servlet, String servletName, String[] urlPatterns, Dictionary<String, ?> initParams, Integer loadOnStartup, Boolean asyncSupported, MultipartConfigElement multiPartConfig, HttpContext httpContext) throws ServletException {
        this.delegate.registerServlet(servlet, servletName, urlPatterns, initParams, loadOnStartup, asyncSupported, multiPartConfig, httpContext);
    }

    public SharedWebContainerContext createDefaultSharedHttpContext() {
        return this.delegate.createDefaultSharedHttpContext();
    }

    public void registerServlet(Class<? extends Servlet> servletClass, String[] urlPatterns, Dictionary<String, ?> initParams, Integer loadOnStartup, Boolean asyncSupported, MultipartConfigElement multiPartConfig, HttpContext httpContext) throws ServletException {
        this.delegate.registerServlet(servletClass, urlPatterns, initParams, loadOnStartup, asyncSupported, multiPartConfig, httpContext);
    }
}

