/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.util.ArrayList;
import java.util.HashSet;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexCondition;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class IndexCursor
implements Cursor {
    private Session session;
    private final TableFilter tableFilter;
    private Index index;
    private Table table;
    private IndexColumn[] indexColumns;
    private boolean alwaysFalse;
    private SearchRow start;
    private SearchRow end;
    private Cursor cursor;
    private Column inColumn;
    private int inListIndex;
    private Value[] inList;
    private ResultInterface inResult;
    private HashSet<Value> inResultTested;

    public IndexCursor(TableFilter tableFilter) {
        this.tableFilter = tableFilter;
    }

    public void setIndex(Index index) {
        this.index = index;
        this.table = index.getTable();
        Column[] columnArray = this.table.getColumns();
        this.indexColumns = new IndexColumn[columnArray.length];
        IndexColumn[] indexColumnArray = index.getIndexColumns();
        if (indexColumnArray != null) {
            int n = columnArray.length;
            for (int i = 0; i < n; ++i) {
                int n2 = index.getColumnIndex(columnArray[i]);
                if (n2 < 0) continue;
                this.indexColumns[i] = indexColumnArray[n2];
            }
        }
    }

    public void find(Session session, ArrayList<IndexCondition> arrayList) {
        this.session = session;
        this.alwaysFalse = false;
        this.end = null;
        this.start = null;
        this.inList = null;
        this.inColumn = null;
        this.inResult = null;
        this.inResultTested = null;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            IndexColumn indexColumn;
            IndexCondition indexCondition = arrayList.get(i);
            if (indexCondition.isAlwaysFalse()) {
                this.alwaysFalse = true;
                break;
            }
            Column column = indexCondition.getColumn();
            if (indexCondition.getCompareType() == 9) {
                if (this.start != null || this.end != null || !this.canUseIndexForIn(column)) continue;
                this.inColumn = column;
                this.inList = indexCondition.getCurrentValueList(session);
                this.inListIndex = 0;
                continue;
            }
            if (indexCondition.getCompareType() == 10) {
                if (this.start != null || this.end != null || !this.canUseIndexForIn(column)) continue;
                this.inColumn = column;
                this.inResult = indexCondition.getCurrentResult();
                continue;
            }
            Value value = indexCondition.getCurrentValue(session);
            boolean bl = indexCondition.isStart();
            boolean bl2 = indexCondition.isEnd();
            int n2 = column.getColumnId();
            if (n2 >= 0 && (indexColumn = this.indexColumns[n2]) != null && (indexColumn.sortType & 1) != 0) {
                boolean bl3 = bl;
                bl = bl2;
                bl2 = bl3;
            }
            if (bl) {
                this.start = this.getSearchRow(this.start, n2, value, true);
            }
            if (bl2) {
                this.end = this.getSearchRow(this.end, n2, value, false);
            }
            if (bl || bl2) {
                this.inColumn = null;
                this.inList = null;
                this.inResult = null;
            }
            if (this.session.getDatabase().getSettings().optimizeIsNull || !bl || !bl2 || value != ValueNull.INSTANCE) continue;
            this.alwaysFalse = true;
        }
        if (this.inColumn != null) {
            return;
        }
        if (!this.alwaysFalse) {
            this.cursor = this.index.find(this.tableFilter, this.start, this.end);
        }
    }

    private boolean canUseIndexForIn(Column column) {
        if (this.inColumn != null) {
            return false;
        }
        IndexColumn[] indexColumnArray = this.index.getIndexColumns();
        if (indexColumnArray == null) {
            return true;
        }
        IndexColumn indexColumn = indexColumnArray[0];
        return indexColumn == null || indexColumn.column == column;
    }

    private SearchRow getSearchRow(SearchRow searchRow, int n, Value value, boolean bl) {
        if (searchRow == null) {
            searchRow = this.table.getTemplateRow();
        } else {
            value = this.getMax(searchRow.getValue(n), value, bl);
        }
        if (n < 0) {
            searchRow.setKey(value.getLong());
        } else {
            searchRow.setValue(n, value);
        }
        return searchRow;
    }

    private Value getMax(Value value, Value value2, boolean bl) {
        int n;
        if (value == null) {
            return value2;
        }
        if (value2 == null) {
            return value;
        }
        if (this.session.getDatabase().getSettings().optimizeIsNull) {
            if (value == ValueNull.INSTANCE) {
                return value2;
            }
            if (value2 == ValueNull.INSTANCE) {
                return value;
            }
        }
        if ((n = value.compareTo(value2, this.table.getDatabase().getCompareMode())) == 0) {
            return value;
        }
        if ((value == ValueNull.INSTANCE || value2 == ValueNull.INSTANCE) && this.session.getDatabase().getSettings().optimizeIsNull) {
            return null;
        }
        if (!bl) {
            n = -n;
        }
        return n > 0 ? value : value2;
    }

    public boolean isAlwaysFalse() {
        return this.alwaysFalse;
    }

    @Override
    public Row get() {
        if (this.cursor == null) {
            return null;
        }
        return this.cursor.get();
    }

    @Override
    public SearchRow getSearchRow() {
        return this.cursor.getSearchRow();
    }

    @Override
    public boolean next() {
        while (true) {
            if (this.cursor == null) {
                this.nextCursor();
                if (this.cursor == null) {
                    return false;
                }
            }
            if (this.cursor.next()) {
                return true;
            }
            this.cursor = null;
        }
    }

    private void nextCursor() {
        block3: {
            block4: {
                if (this.inList == null) break block4;
                while (this.inListIndex < this.inList.length) {
                    Value value;
                    if ((value = this.inList[this.inListIndex++]) == ValueNull.INSTANCE) continue;
                    this.find(value);
                    break block3;
                }
                break block3;
            }
            if (this.inResult == null) break block3;
            while (this.inResult.next()) {
                Value value = this.inResult.currentRow()[0];
                if (value == ValueNull.INSTANCE) continue;
                value = this.inColumn.convert(value);
                if (this.inResultTested == null) {
                    this.inResultTested = new HashSet();
                }
                if (!this.inResultTested.add(value)) continue;
                this.find(value);
                break;
            }
        }
    }

    private void find(Value value) {
        value = this.inColumn.convert(value);
        int n = this.inColumn.getColumnId();
        if (this.start == null) {
            this.start = this.table.getTemplateRow();
        }
        this.start.setValue(n, value);
        this.cursor = this.index.find(this.tableFilter, this.start, this.start);
    }

    @Override
    public boolean previous() {
        throw DbException.throwInternalError();
    }
}

