/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.messaging.api;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import net.roboconf.messaging.api.business.IClient;
import net.roboconf.messaging.api.jmx.RoboconfMessageQueue;
import net.roboconf.messaging.api.messages.Message;

public abstract class AbstractMessageProcessor<T extends IClient>
extends Thread {
    private final RoboconfMessageQueue messageQueue = new RoboconfMessageQueue();
    private final AtomicBoolean running = new AtomicBoolean(false);
    protected T messagingClient;

    public AbstractMessageProcessor(String threadName) {
        super(threadName);
    }

    public final void storeMessage(Message message) {
        this.messageQueue.add(message);
    }

    public RoboconfMessageQueue getMessageQueue() {
        return this.messageQueue;
    }

    public void setMessagingClient(T messagingClient) {
        this.messagingClient = messagingClient;
    }

    @Override
    public final void run() {
        this.running.set(true);
        while (this.running.get()) {
            try {
                Message message = (Message)this.messageQueue.take();
                if (!this.running.get()) continue;
                this.processMessage(message);
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        Logger.getLogger(this.getClass().getName()).fine("Roboconf's message processing thread is stopping.");
        this.running.set(false);
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public void stopProcessor() {
        this.running.set(false);
    }

    protected abstract void processMessage(Message var1);
}

