/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.messaging.api.extensions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.roboconf.core.model.beans.Component;
import net.roboconf.core.model.beans.ImportedVariable;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.ComponentHelpers;
import net.roboconf.core.model.helpers.VariableHelpers;
import net.roboconf.core.utils.Utils;

public class MessagingContext
implements Serializable {
    private static final long serialVersionUID = 5529159467155629784L;
    private final RecipientKind kind;
    private final String domain;
    private final String componentOrFacetName;
    private final String applicationName;
    private final ThoseThat thoseThat;

    public MessagingContext(RecipientKind kind, String domain, String applicationName) {
        this(kind, domain, null, null, applicationName);
    }

    public MessagingContext(RecipientKind kind, String domain, String topicName, String applicationName) {
        this(kind, domain, topicName, null, applicationName);
    }

    public MessagingContext(RecipientKind kind, String domain, String componentOrFacetName, ThoseThat thoseThat, String applicationName) {
        this.kind = kind;
        this.domain = domain;
        if (kind == RecipientKind.DM) {
            this.componentOrFacetName = null;
            this.applicationName = applicationName;
            this.thoseThat = null;
        } else if (kind == RecipientKind.INTER_APP) {
            this.componentOrFacetName = componentOrFacetName;
            this.thoseThat = thoseThat;
            this.applicationName = null;
        } else {
            this.thoseThat = thoseThat;
            this.componentOrFacetName = componentOrFacetName;
            this.applicationName = applicationName;
        }
    }

    public RecipientKind getKind() {
        return this.kind;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getComponentOrFacetName() {
        return this.componentOrFacetName;
    }

    public ThoseThat getAgentDirection() {
        return this.thoseThat;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getTopicName() {
        StringBuilder sb = new StringBuilder();
        if (this.kind == RecipientKind.DM) {
            if (this.applicationName != null) {
                sb.append(this.applicationName);
            }
        } else {
            if (this.thoseThat != null) {
                sb.append((Object)this.thoseThat);
            }
            if (this.componentOrFacetName != null) {
                sb.append(this.componentOrFacetName);
            }
        }
        return sb.toString();
    }

    public int hashCode() {
        String topicName = this.getTopicName();
        int backup = this.kind.hashCode();
        return Utils.isEmptyOrWhitespaces((String)topicName) ? backup : topicName.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof MessagingContext && this.kind == ((MessagingContext)obj).kind && this.thoseThat == ((MessagingContext)obj).thoseThat && Objects.equals(this.componentOrFacetName, ((MessagingContext)obj).componentOrFacetName) && Objects.equals(this.applicationName, ((MessagingContext)obj).applicationName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getTopicName());
        if (this.applicationName != null && this.kind != RecipientKind.DM) {
            sb.append(" @ ");
            sb.append(this.applicationName);
        }
        sb.append(" (");
        sb.append((Object)this.kind);
        sb.append(")");
        return sb.toString().trim();
    }

    public static Collection<MessagingContext> forImportedVariables(String domain, String applicationName, Instance instance, ThoseThat thoseThat) {
        HashMap<String, MessagingContext> result = new HashMap<String, MessagingContext>();
        for (ImportedVariable var : ComponentHelpers.findAllImportedVariables((Component)instance.getComponent()).values()) {
            String componentOrApplicationTemplateName = (String)VariableHelpers.parseVariableName((String)var.getName()).getKey();
            if (result.containsKey(componentOrApplicationTemplateName)) continue;
            RecipientKind kind = var.isExternal() ? RecipientKind.INTER_APP : RecipientKind.AGENTS;
            MessagingContext ctx = new MessagingContext(kind, domain, componentOrApplicationTemplateName, thoseThat, applicationName);
            result.put(componentOrApplicationTemplateName, ctx);
        }
        return result.values();
    }

    public static List<MessagingContext> forExportedVariables(String domain, String applicationName, Instance instance, Map<String, String> externalExports, ThoseThat thoseThat) {
        MessagingContext ctx;
        String prefix;
        ArrayList<MessagingContext> result = new ArrayList<MessagingContext>();
        HashSet<String> externalExportPrefixes = new HashSet<String>();
        for (String string : externalExports.keySet()) {
            prefix = (String)VariableHelpers.parseVariableName((String)string).getKey();
            externalExportPrefixes.add(prefix);
        }
        boolean publishExternal = false;
        for (String facetOrComponentName : VariableHelpers.findPrefixesForExportedVariables((Instance)instance)) {
            ctx = new MessagingContext(RecipientKind.AGENTS, domain, facetOrComponentName, thoseThat, applicationName);
            result.add(ctx);
            if (!externalExportPrefixes.contains(facetOrComponentName)) continue;
            publishExternal = true;
        }
        if (publishExternal) {
            String string = externalExports.values().iterator().next();
            prefix = (String)VariableHelpers.parseVariableName((String)string).getKey();
            ctx = new MessagingContext(RecipientKind.INTER_APP, domain, prefix, thoseThat, applicationName);
            result.add(ctx);
        }
        return result;
    }

    public static enum ThoseThat {
        EXPORT("those.that.export."),
        IMPORT("those.that.import.");

        private String string;

        private ThoseThat(String string2) {
            this.string = string2;
        }

        public String toString() {
            return this.string;
        }
    }

    public static enum RecipientKind {
        INTER_APP,
        DM,
        AGENTS;

    }
}

