/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.messaging.api.reconfigurables;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import net.roboconf.core.model.beans.Application;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.InstanceHelpers;
import net.roboconf.messaging.api.AbstractMessageProcessor;
import net.roboconf.messaging.api.business.IDmClient;
import net.roboconf.messaging.api.business.ListenerCommand;
import net.roboconf.messaging.api.extensions.IMessagingClient;
import net.roboconf.messaging.api.extensions.MessagingContext;
import net.roboconf.messaging.api.jmx.RoboconfMessageQueue;
import net.roboconf.messaging.api.messages.Message;
import net.roboconf.messaging.api.messages.from_agent_to_agent.MsgCmdRemoveImport;
import net.roboconf.messaging.api.reconfigurables.ReconfigurableClient;
import net.roboconf.messaging.api.utils.MessagingUtils;

public class ReconfigurableClientDm
extends ReconfigurableClient<IDmClient>
implements IDmClient {
    @Override
    protected void openConnection(IMessagingClient newMessagingClient) throws IOException {
        newMessagingClient.setOwnerProperties(MessagingContext.RecipientKind.DM, this.domain, null, null);
        newMessagingClient.openConnection();
    }

    @Override
    protected void configureMessageProcessor(AbstractMessageProcessor<IDmClient> messageProcessor) {
        messageProcessor.setMessagingClient(this);
    }

    @Override
    public MessagingContext.RecipientKind getOwnerKind() {
        return MessagingContext.RecipientKind.DM;
    }

    @Override
    public void setMessageQueue(RoboconfMessageQueue messageQueue) {
        this.getMessagingClient().setMessageQueue(messageQueue);
    }

    @Override
    public boolean isConnected() {
        return this.getMessagingClient().isConnected();
    }

    @Override
    public void openConnection() throws IOException {
        this.getMessagingClient().openConnection();
    }

    @Override
    public void deleteMessagingServerArtifacts(Application application) throws IOException {
        this.getMessagingClient().deleteMessagingServerArtifacts(application);
    }

    @Override
    public void closeConnection() throws IOException {
        IMessagingClient toClose = this.resetInternalClient();
        if (toClose != null) {
            toClose.closeConnection();
        }
    }

    @Override
    public void sendMessageToAgent(Application application, Instance instance, Message message) throws IOException {
        String topicName = MessagingUtils.buildTopicNameForAgent(instance);
        MessagingContext ctx = new MessagingContext(MessagingContext.RecipientKind.AGENTS, this.domain, topicName, application.getName());
        this.getMessagingClient().publish(ctx, message);
    }

    @Override
    public void listenToAgentMessages(Application application, ListenerCommand command) throws IOException {
        this.listenToAgentMessages(this.getMessagingClient(), application, command);
    }

    @Override
    public void sendMessageToTheDm(Message msg) throws IOException {
        MessagingContext ctx = new MessagingContext(MessagingContext.RecipientKind.DM, this.domain, null);
        this.getMessagingClient().publish(ctx, msg);
    }

    @Override
    public void listenToTheDm(ListenerCommand command) throws IOException {
        MessagingContext ctx = new MessagingContext(MessagingContext.RecipientKind.DM, this.domain, null);
        if (command == ListenerCommand.STOP) {
            this.getMessagingClient().unsubscribe(ctx);
        } else {
            this.getMessagingClient().subscribe(ctx);
        }
    }

    @Override
    public void propagateAgentTermination(Application application, Instance rootInstance) throws IOException {
        List instances = InstanceHelpers.buildHierarchicalList((Instance)rootInstance);
        Collections.reverse(instances);
        this.logger.fine("The DM is un-publishing exports related to agent of " + rootInstance + " (termination propagation).");
        for (Instance instance : instances) {
            for (MessagingContext ctx : MessagingContext.forExportedVariables(this.domain, application.getName(), instance, application.getExternalExports(), MessagingContext.ThoseThat.IMPORT)) {
                MsgCmdRemoveImport message = new MsgCmdRemoveImport(application.getName(), ctx.getComponentOrFacetName(), InstanceHelpers.computeInstancePath((Instance)instance));
                this.getMessagingClient().publish(ctx, message);
            }
        }
    }

    protected void listenToAgentMessages(IMessagingClient messagingClient, Application application, ListenerCommand command) throws IOException {
        MessagingContext ctx = new MessagingContext(MessagingContext.RecipientKind.DM, this.domain, application.getName());
        if (command == ListenerCommand.STOP) {
            messagingClient.unsubscribe(ctx);
        } else {
            messagingClient.subscribe(ctx);
        }
    }
}

