/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.scheduler.internal;

import java.util.Set;
import java.util.logging.Logger;
import net.roboconf.core.model.beans.Application;
import net.roboconf.core.model.beans.ApplicationTemplate;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.runtime.EventType;
import net.roboconf.core.utils.Utils;
import net.roboconf.dm.management.events.IDmListener;
import net.roboconf.dm.scheduler.internal.RoboconfScheduler;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;

public class ManagerListener
implements IDmListener {
    static final String ID = "Roboconf Scheduler";
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final RoboconfScheduler scheduler;

    public ManagerListener(RoboconfScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public String getId() {
        return ID;
    }

    public void enableNotifications() {
    }

    public void disableNotifications() {
    }

    public void applicationTemplate(ApplicationTemplate tpl, EventType eventType) {
    }

    public void instance(Instance instance, Application application, EventType eventType) {
    }

    public void raw(String message, Object ... data) {
    }

    public void application(Application application, EventType eventType) {
        if (eventType == EventType.DELETED) {
            this.logger.fine("Application " + application + " was deleted. Associated jobs are about to be deleted.");
            try {
                Set<TriggerKey> tks = this.scheduler.scheduler.getTriggerKeys(GroupMatcher.triggerGroupEquals(application.getName()));
                for (TriggerKey tk : tks) {
                    try {
                        this.scheduler.deleteJob(tk.getName());
                    }
                    catch (Exception e) {
                        this.logger.warning("An error occurred while unscheduling job " + tk.getName() + ". " + e.getMessage());
                        Utils.logException((Logger)this.logger, (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                this.logger.warning("An error occurred while listing jobs for application " + application + ". " + e.getMessage());
                Utils.logException((Logger)this.logger, (Throwable)e);
            }
        }
    }
}

