/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.target.api;

import java.io.Closeable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.utils.Utils;
import net.roboconf.target.api.TargetException;
import net.roboconf.target.api.TargetHandler;
import net.roboconf.target.api.TargetHandlerParameters;

public abstract class AbstractThreadedTargetHandler
implements TargetHandler {
    protected static final int DEFAULT_DELAY = 1000;
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    protected long delay = 1000L;
    private ScheduledThreadPoolExecutor timer;
    private final Map<String, MachineConfigurator> machineIdToConfigurators = new ConcurrentHashMap<String, MachineConfigurator>();
    private final CancelledMachines cancelledMachineIds = new CancelledMachines();

    public void start() {
        this.timer = new ScheduledThreadPoolExecutor(1);
        this.timer.scheduleWithFixedDelay(new CheckingRunnable(this.machineIdToConfigurators, this.cancelledMachineIds), 0L, this.delay, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        this.timer.shutdownNow();
        this.timer = null;
    }

    @Override
    public final void configureMachine(TargetHandlerParameters parameters, String machineId) throws TargetException {
        this.submitMachineConfiguratorUseWithCaution(machineId, this.machineConfigurator(parameters, machineId));
    }

    public abstract MachineConfigurator machineConfigurator(TargetHandlerParameters var1, String var2) throws TargetException;

    protected void cancelMachineConfigurator(String machineId) {
        this.logger.fine("Cancelling machine '" + machineId + "'.");
        this.cancelledMachineIds.addMachineId(machineId);
    }

    protected void submitMachineConfiguratorUseWithCaution(String machineId, MachineConfigurator configurator) {
        if (configurator != null) {
            this.logger.fine("Configuring machine '" + machineId + "' (" + configurator.getClass().getSimpleName() + ").");
            this.machineIdToConfigurators.put(machineId, configurator);
        }
    }

    public Map<String, MachineConfigurator> getMachineIdToConfigurators() {
        return Collections.unmodifiableMap(this.machineIdToConfigurators);
    }

    public Set<String> getCancelledMachineIds() {
        return this.cancelledMachineIds.getCancelledIds();
    }

    static class CancelledMachines {
        private final Set<String> cancelledIds = new HashSet<String>();

        CancelledMachines() {
        }

        public synchronized void addMachineId(String machineId) {
            if (machineId != null) {
                this.cancelledIds.add(machineId);
            }
        }

        public synchronized Set<String> removeSnapshot() {
            HashSet<String> result = new HashSet<String>(this.cancelledIds);
            this.cancelledIds.clear();
            return result;
        }

        public synchronized Set<String> getCancelledIds() {
            return Collections.unmodifiableSet(this.cancelledIds);
        }
    }

    static class CheckingRunnable
    implements Runnable {
        private final CancelledMachines cancelledMachineIds;
        private final Map<String, MachineConfigurator> machineIdToConfigurators;
        private final Logger logger = Logger.getLogger(this.getClass().getName());

        public CheckingRunnable(Map<String, MachineConfigurator> machineIdToConfigurators, CancelledMachines cancelledMachineIds) {
            this.machineIdToConfigurators = machineIdToConfigurators;
            this.cancelledMachineIds = cancelledMachineIds;
        }

        @Override
        public void run() {
            this.logger.finest("Periodic check is running.");
            for (String machineId : this.cancelledMachineIds.removeSnapshot()) {
                MachineConfigurator handler = this.machineIdToConfigurators.remove(machineId);
                if (handler == null) continue;
                this.closeConfigurator(machineId, handler);
            }
            HashSet<String> keysToRemove = new HashSet<String>();
            for (Map.Entry<String, MachineConfigurator> entry : this.machineIdToConfigurators.entrySet()) {
                MachineConfigurator handler = entry.getValue();
                try {
                    if (!handler.configure()) continue;
                    keysToRemove.add(entry.getKey());
                    this.closeConfigurator(entry.getKey(), handler);
                    Instance scopedInstance = handler.getScopedInstance();
                    scopedInstance.data.put("ready.for.local.script.configuration", "true");
                }
                catch (Throwable t) {
                    this.logger.severe("An error occurred while configuring machine '" + entry.getKey() + "'. " + t.getMessage());
                    Utils.logException((Logger)this.logger, (Throwable)t);
                    keysToRemove.add(entry.getKey());
                    this.closeConfigurator(entry.getKey(), handler);
                    Instance scopedInstance = handler.getScopedInstance();
                    if (scopedInstance.getStatus() == Instance.InstanceStatus.NOT_DEPLOYED) continue;
                    scopedInstance.setStatus(Instance.InstanceStatus.PROBLEM);
                    scopedInstance.data.put("last.problem", "Configuration failed. " + t.getMessage());
                }
            }
            this.machineIdToConfigurators.keySet().removeAll(keysToRemove);
        }

        private void closeConfigurator(String machineId, MachineConfigurator handler) {
            try {
                this.logger.fine("Closing the configurator for machine " + machineId);
                handler.close();
            }
            catch (Exception e) {
                this.logger.warning("An error occurred while closing the configurator for machine '" + machineId + "'. " + e.getMessage());
                Utils.logException((Logger)this.logger, (Throwable)e);
            }
        }
    }

    public static interface MachineConfigurator
    extends Closeable {
        public boolean configure() throws TargetException;

        public Instance getScopedInstance();
    }
}

