/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.webconsole.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.AbstractWebConsolePlugin;
import org.apache.karaf.webconsole.http.ServletDetails;
import org.apache.karaf.webconsole.http.ServletEventHandler;
import org.apache.karaf.webconsole.http.WebDetail;
import org.apache.karaf.webconsole.http.WebEventHandler;
import org.json.JSONException;
import org.json.JSONWriter;
import org.ops4j.pax.web.service.spi.ServletEvent;
import org.ops4j.pax.web.service.spi.WebEvent;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpPlugin
extends AbstractWebConsolePlugin {
    private final Logger log = LoggerFactory.getLogger(HttpPlugin.class);
    public static final String NAME = "http";
    public static final String LABEL = "Http";
    private ClassLoader classLoader;
    private String featuresJs = "/http/res/ui/http-contexts.js";
    private ServletEventHandler servletEventHandler;
    private WebEventHandler webEventHandler;
    private BundleContext bundleContext;

    protected boolean isHtmlRequest(HttpServletRequest request) {
        return true;
    }

    public void start() {
        super.activate(this.bundleContext);
        this.classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        this.log.info("Http plugin activated");
    }

    public void stop() {
        this.log.info("Http plugin deactivated");
        super.deactivate();
    }

    public String getLabel() {
        return NAME;
    }

    public String getTitle() {
        return LABEL;
    }

    protected void renderContent(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter pw = response.getWriter();
        String appRoot = (String)request.getAttribute("felix.webconsole.appRoot");
        String featuresScriptTag = "<script src='" + appRoot + this.featuresJs + "' language='JavaScript'></script>";
        pw.println(featuresScriptTag);
        pw.println("<script type='text/javascript'>");
        pw.println("// <![CDATA[");
        pw.println("var imgRoot = '" + appRoot + "/res/imgs';");
        pw.println("// ]]>");
        pw.println("</script>");
        pw.println("<div id='plugin_content'/>");
        pw.println("<script type='text/javascript'>");
        pw.println("// <![CDATA[");
        pw.print("renderFeatures( ");
        this.writeJSON(pw);
        pw.println(" )");
        pw.println("// ]]>");
        pw.println("</script>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URL getResource(String path) {
        if ((path = path.substring(NAME.length() + 1)) == null || path.isEmpty()) {
            return null;
        }
        URL url = this.classLoader.getResource(path);
        if (url != null) {
            InputStream ins = null;
            try {
                ins = url.openStream();
                if (ins == null) {
                    this.log.error("failed to open " + url);
                    url = null;
                }
            }
            catch (IOException e) {
                this.log.error(e.getMessage(), (Throwable)e);
                url = null;
            }
            finally {
                if (ins != null) {
                    try {
                        ins.close();
                    }
                    catch (IOException e) {
                        this.log.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        return url;
    }

    private void writeJSON(PrintWriter pw) throws IOException {
        List<ServletDetails> servlets = this.getServletDetails();
        List<WebDetail> web = this.getWebDetails();
        String statusLine = this.getStatusLine(servlets, web);
        JSONWriter jw = new JSONWriter((Writer)pw);
        try {
            jw.object();
            jw.key("status");
            jw.value((Object)statusLine);
            jw.key("contexts");
            jw.array();
            for (ServletDetails servlet : servlets) {
                jw.object();
                jw.key("id");
                jw.value(servlet.getId());
                jw.key("servlet");
                jw.value((Object)servlet.getServlet());
                jw.key("servletName");
                jw.value((Object)servlet.getServletName());
                jw.key("state");
                jw.value((Object)servlet.getState());
                jw.key("alias");
                jw.value((Object)servlet.getAlias());
                jw.key("urls");
                jw.array();
                for (String url : servlet.getUrls()) {
                    jw.value((Object)url);
                }
                jw.endArray();
                jw.endObject();
            }
            jw.endArray();
            jw.key("web");
            jw.array();
            for (WebDetail webDetail : web) {
                jw.object();
                jw.key("id");
                jw.value(webDetail.getBundleId());
                jw.key("bundlestate");
                jw.value((Object)webDetail.getState());
                jw.key("contextpath");
                jw.value((Object)webDetail.getContextPath());
                jw.key("state");
                jw.value((Object)webDetail.getWebState());
                jw.endObject();
            }
            jw.endArray();
            jw.endObject();
        }
        catch (JSONException je) {
            throw new IOException(je.toString());
        }
    }

    protected List<ServletDetails> getServletDetails() {
        Collection<ServletEvent> events = this.servletEventHandler.getServletEvents();
        ArrayList<ServletDetails> result = new ArrayList<ServletDetails>(events.size());
        for (ServletEvent event : events) {
            String[] stringArray;
            String alias;
            String servletName;
            Servlet servlet = event.getServlet();
            String servletClassName = " ";
            if (servlet != null) {
                servletClassName = servlet.getClass().getName();
                servletClassName = servletClassName.substring(servletClassName.lastIndexOf(".") + 1, servletClassName.length());
            }
            String string = servletName = event.getServletName() != null ? event.getServletName() : " ";
            if (servletName.contains(".")) {
                servletName = servletName.substring(servletName.lastIndexOf(".") + 1, servletName.length());
            }
            String string2 = alias = event.getAlias() != null ? event.getAlias() : " ";
            if (event.getUrlParameter() != null) {
                stringArray = event.getUrlParameter();
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "";
            }
            String[] urls = stringArray;
            ServletDetails details = new ServletDetails();
            details.setId(event.getBundle().getBundleId());
            details.setAlias(alias);
            details.setServlet(servletClassName);
            details.setServletName(servletName);
            details.setState(this.getStateString(event.getType()));
            details.setUrls(urls);
            result.add(details);
        }
        return result;
    }

    protected List<WebDetail> getWebDetails() {
        Map<Long, WebEvent> bundleEvents = this.webEventHandler.getBundleEvents();
        ArrayList<WebDetail> result = new ArrayList<WebDetail>();
        for (WebEvent event : bundleEvents.values()) {
            WebDetail webDetail = new WebDetail();
            webDetail.setBundleId(event.getBundle().getBundleId());
            webDetail.setContextPath(event.getContextPath().trim().concat("/"));
            int state = event.getBundle().getState();
            String stateStr = state == 32 ? "Active" : (state == 2 ? "Installed" : (state == 4 ? "Resolved" : (state == 8 ? "Starting" : (state == 16 ? "Stopping" : "Unknown"))));
            webDetail.setState(stateStr);
            webDetail.setWebState(this.getStateString(event.getType()));
            result.add(webDetail);
        }
        return result;
    }

    public String getStatusLine(List<ServletDetails> servlets, List<WebDetail> web) {
        HashMap<String, Integer> states = new HashMap<String, Integer>();
        for (ServletDetails servlet : servlets) {
            Integer count = (Integer)states.get(servlet.getState());
            if (count == null) {
                states.put(servlet.getState(), 1);
                continue;
            }
            states.put(servlet.getState(), 1 + count);
        }
        StringBuilder stateSummary = new StringBuilder();
        boolean first = true;
        for (Map.Entry state : states.entrySet()) {
            if (!first) {
                stateSummary.append(", ");
            }
            first = false;
            stateSummary.append(state.getValue()).append(" ").append((String)state.getKey());
        }
        return "Http contexts: " + stateSummary.toString();
    }

    public String getStateString(int type) {
        switch (type) {
            case 1: {
                return "Deploying";
            }
            case 2: {
                return "Deployed";
            }
            case 3: {
                return "Undeploying";
            }
            case 4: {
                return "Undeployed";
            }
            case 5: {
                return "Failed";
            }
            case 6: {
                return "Waiting";
            }
        }
        return "Failed";
    }

    public void setServletEventHandler(ServletEventHandler eventHandler) {
        this.servletEventHandler = eventHandler;
    }

    public void setWebEventHandler(WebEventHandler eventHandler) {
        this.webEventHandler = eventHandler;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }
}

