/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.messaging.http.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import net.roboconf.core.utils.Utils;
import net.roboconf.messaging.api.extensions.AbstractRoutingClient;
import net.roboconf.messaging.api.extensions.IMessagingClient;
import net.roboconf.messaging.api.extensions.MessagingContext;
import net.roboconf.messaging.api.factory.IMessagingClientFactory;
import net.roboconf.messaging.api.reconfigurables.ReconfigurableClient;
import net.roboconf.messaging.http.internal.clients.HttpAgentClient;
import net.roboconf.messaging.http.internal.clients.HttpDmClient;
import net.roboconf.messaging.http.internal.sockets.DmWebSocketServlet;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.eclipse.jetty.websocket.api.Session;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.http.HttpService;

public class HttpClientFactory
implements IMessagingClientFactory,
Pojo {
    InstanceManager __IM;
    private boolean __FagentClients;
    final Set<HttpAgentClient> agentClients;
    private boolean __Flogger;
    private final Logger logger;
    private boolean __FroutingContext;
    private final HttpRoutingContext routingContext;
    private boolean __FdmClient;
    private final HttpDmClient dmClient;
    private boolean __FbundleContext;
    BundleContext bundleContext;
    private boolean __FhttpService;
    HttpService httpService;
    private boolean __FhttpServerIp;
    String httpServerIp;
    private boolean __FhttpPort;
    int httpPort;
    boolean __MsetHttpServerIp$java_lang_String;
    boolean __MsetHttpPort$int;
    boolean __MgetDmClient;
    boolean __Mstart;
    boolean __Mstop;
    boolean __MstopAll;
    boolean __McreateClient$net_roboconf_messaging_api_reconfigurables_ReconfigurableClient;
    boolean __MgetType;
    boolean __MsetConfiguration$java_util_Map;
    boolean __Mreconfigure;
    boolean __MresetClients$boolean;

    Set __getagentClients() {
        if (!this.__FagentClients) {
            return this.agentClients;
        }
        return (Set)this.__IM.onGet((Object)this, "agentClients");
    }

    void __setagentClients(Set set) {
        if (!this.__FagentClients) {
            this.agentClients = set;
            return;
        }
        this.__IM.onSet((Object)this, "agentClients", (Object)set);
    }

    Logger __getlogger() {
        if (!this.__Flogger) {
            return this.logger;
        }
        return (Logger)this.__IM.onGet((Object)this, "logger");
    }

    void __setlogger(Logger logger) {
        if (!this.__Flogger) {
            this.logger = logger;
            return;
        }
        this.__IM.onSet((Object)this, "logger", (Object)logger);
    }

    HttpRoutingContext __getroutingContext() {
        if (!this.__FroutingContext) {
            return this.routingContext;
        }
        return (HttpRoutingContext)((Object)this.__IM.onGet((Object)this, "routingContext"));
    }

    void __setroutingContext(HttpRoutingContext httpRoutingContext) {
        if (!this.__FroutingContext) {
            this.routingContext = httpRoutingContext;
            return;
        }
        this.__IM.onSet((Object)this, "routingContext", (Object)httpRoutingContext);
    }

    HttpDmClient __getdmClient() {
        if (!this.__FdmClient) {
            return this.dmClient;
        }
        return (HttpDmClient)((Object)this.__IM.onGet((Object)this, "dmClient"));
    }

    void __setdmClient(HttpDmClient httpDmClient) {
        if (!this.__FdmClient) {
            this.dmClient = httpDmClient;
            return;
        }
        this.__IM.onSet((Object)this, "dmClient", (Object)httpDmClient);
    }

    BundleContext __getbundleContext() {
        if (!this.__FbundleContext) {
            return this.bundleContext;
        }
        return (BundleContext)this.__IM.onGet((Object)this, "bundleContext");
    }

    void __setbundleContext(BundleContext bundleContext) {
        if (!this.__FbundleContext) {
            this.bundleContext = bundleContext;
            return;
        }
        this.__IM.onSet((Object)this, "bundleContext", (Object)bundleContext);
    }

    HttpService __gethttpService() {
        if (!this.__FhttpService) {
            return this.httpService;
        }
        return (HttpService)this.__IM.onGet((Object)this, "httpService");
    }

    void __sethttpService(HttpService httpService) {
        if (!this.__FhttpService) {
            this.httpService = httpService;
            return;
        }
        this.__IM.onSet((Object)this, "httpService", (Object)httpService);
    }

    String __gethttpServerIp() {
        if (!this.__FhttpServerIp) {
            return this.httpServerIp;
        }
        return (String)this.__IM.onGet((Object)this, "httpServerIp");
    }

    void __sethttpServerIp(String string) {
        if (!this.__FhttpServerIp) {
            this.httpServerIp = string;
            return;
        }
        this.__IM.onSet((Object)this, "httpServerIp", (Object)string);
    }

    int __gethttpPort() {
        if (!this.__FhttpPort) {
            return this.httpPort;
        }
        Object object = this.__IM.onGet((Object)this, "httpPort");
        Integer n = (Integer)object;
        return n;
    }

    void __sethttpPort(int n) {
        if (!this.__FhttpPort) {
            this.httpPort = n;
            return;
        }
        Integer n2 = new Integer(n);
        this.__IM.onSet((Object)this, "httpPort", (Object)n2);
    }

    public HttpClientFactory() {
        this((InstanceManager)null);
    }

    private HttpClientFactory(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setagentClients(Collections.newSetFromMap(new WeakHashMap()));
        this.__setlogger(Logger.getLogger(this.getClass().getName()));
        this.__setroutingContext(new HttpRoutingContext());
        this.__setdmClient(new HttpDmClient(this.__getroutingContext()));
    }

    public HttpClientFactory(BundleContext bundleContext) {
        this(null, bundleContext);
    }

    private HttpClientFactory(InstanceManager _manager, BundleContext bundleContext) {
        this._setInstanceManager(_manager);
        this.__setagentClients(Collections.newSetFromMap(new WeakHashMap()));
        this.__setlogger(Logger.getLogger(this.getClass().getName()));
        this.__setroutingContext(new HttpRoutingContext());
        this.__setdmClient(new HttpDmClient(this.__getroutingContext()));
        this.__setbundleContext(bundleContext);
    }

    public synchronized void setHttpServerIp(String serverIp) {
        if (!this.__MsetHttpServerIp$java_lang_String) {
            this.__M_setHttpServerIp(serverIp);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setHttpServerIp$java_lang_String", new Object[]{serverIp});
            this.__M_setHttpServerIp(serverIp);
            this.__IM.onExit((Object)this, "setHttpServerIp$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setHttpServerIp$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_setHttpServerIp(String serverIp) {
        this.__sethttpServerIp(serverIp);
        this.__getdmClient().setHttpServerIp(serverIp);
        this.__getlogger().finer("Server IP set to " + this.__gethttpServerIp());
    }

    public synchronized void setHttpPort(int port) {
        if (!this.__MsetHttpPort$int) {
            this.__M_setHttpPort(port);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setHttpPort$int", new Object[]{new Integer(port)});
            this.__M_setHttpPort(port);
            this.__IM.onExit((Object)this, "setHttpPort$int", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setHttpPort$int", throwable);
            throw throwable;
        }
    }

    private void __M_setHttpPort(int port) {
        this.__sethttpPort(port);
        this.__getdmClient().setHttpPort(port);
        this.__getlogger().finer("Server port set to " + this.__gethttpPort());
    }

    public HttpDmClient getDmClient() {
        HttpDmClient httpDmClient;
        if (!this.__MgetDmClient) {
            return this.__M_getDmClient();
        }
        try {
            this.__IM.onEntry((Object)this, "getDmClient", new Object[0]);
            httpDmClient = this.__M_getDmClient();
            this.__IM.onExit((Object)this, "getDmClient", (Object)httpDmClient);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDmClient", throwable);
            throw throwable;
        }
        return httpDmClient;
    }

    private HttpDmClient __M_getDmClient() {
        return this.__getdmClient();
    }

    public void start() throws Exception {
        if (!this.__Mstart) {
            this.__M_start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__M_start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    private void __M_start() throws Exception {
        boolean found = false;
        for (Bundle b : this.__getbundleContext().getBundles()) {
            if (!"net.roboconf.dm".equals(b.getSymbolicName())) continue;
            found = true;
            break;
        }
        if (found) {
            this.__getlogger().fine("iPojo registers a servlet for HTTP messaging.");
            Hashtable<String, String> initParams = new Hashtable<String, String>();
            initParams.put("servlet-name", "Roboconf DM (HTTP messaging)");
            DmWebSocketServlet messagingServlet = new DmWebSocketServlet(this);
            this.__gethttpService().registerServlet("/roboconf-messaging-http", (Servlet)messagingServlet, initParams, null);
        } else {
            this.__getlogger().warning("Roboconf's DM bundle was not found. No servlet will be registered.");
        }
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__M_stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__M_stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    private void __M_stop() {
        this.__getlogger().fine("iPojo unregisters a servlet for HTTP messaging.");
        this.resetClients(true);
    }

    void stopAll() {
        if (!this.__MstopAll) {
            this.__M_stopAll();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stopAll", new Object[0]);
            this.__M_stopAll();
            this.__IM.onExit((Object)this, "stopAll", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stopAll", throwable);
            throw throwable;
        }
    }

    private void __M_stopAll() {
        try {
            this.__getdmClient().closeConnection();
            this.stop();
        }
        catch (Throwable t) {
            this.__getlogger().warning("An error occurred while closing the connection of the DM client.");
            Utils.logException((Logger)this.__getlogger(), (Throwable)new RuntimeException(t));
        }
    }

    public IMessagingClient createClient(ReconfigurableClient<?> parent) {
        IMessagingClient iMessagingClient;
        if (!this.__McreateClient$net_roboconf_messaging_api_reconfigurables_ReconfigurableClient) {
            return this.__M_createClient(parent);
        }
        try {
            this.__IM.onEntry((Object)this, "createClient$net_roboconf_messaging_api_reconfigurables_ReconfigurableClient", new Object[]{parent});
            iMessagingClient = this.__M_createClient(parent);
            this.__IM.onExit((Object)this, "createClient$net_roboconf_messaging_api_reconfigurables_ReconfigurableClient", (Object)iMessagingClient);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createClient$net_roboconf_messaging_api_reconfigurables_ReconfigurableClient", throwable);
            throw throwable;
        }
        return iMessagingClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IMessagingClient __M_createClient(ReconfigurableClient<?> parent) {
        Object client;
        this.__getlogger().fine("Creating a new HTTP client with owner = " + parent.getOwnerKind());
        if (parent.getOwnerKind() == MessagingContext.RecipientKind.DM) {
            client = this.__getdmClient();
        } else {
            HttpClientFactory httpClientFactory = this;
            synchronized (httpClientFactory) {
                client = new HttpAgentClient(parent, this.__gethttpServerIp(), this.__gethttpPort());
            }
            this.__getagentClients().add((HttpAgentClient)client);
        }
        return client;
    }

    public String getType() {
        String string;
        if (!this.__MgetType) {
            return this.__M_getType();
        }
        try {
            this.__IM.onEntry((Object)this, "getType", new Object[0]);
            string = this.__M_getType();
            this.__IM.onExit((Object)this, "getType", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getType", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getType() {
        return "http";
    }

    public boolean setConfiguration(Map<String, String> configuration) {
        boolean bl;
        if (!this.__MsetConfiguration$java_util_Map) {
            return this.__M_setConfiguration(configuration);
        }
        try {
            this.__IM.onEntry((Object)this, "setConfiguration$java_util_Map", new Object[]{configuration});
            bl = this.__M_setConfiguration(configuration);
            this.__IM.onExit((Object)this, "setConfiguration$java_util_Map", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setConfiguration$java_util_Map", throwable);
            throw throwable;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean __M_setConfiguration(Map<String, String> configuration) {
        boolean valid = "http".equals(configuration.get("net.roboconf.messaging.type"));
        if (valid) {
            boolean hasChanged = false;
            String ip = Utils.getValue(configuration, (String)"net.roboconf.messaging.http.server.ip", (String)"127.0.0.1");
            String portAS = configuration.get("net.roboconf.messaging.http.server.port");
            int port = portAS == null ? 8181 : Integer.parseInt(portAS);
            HttpClientFactory httpClientFactory = this;
            synchronized (httpClientFactory) {
                if (!Objects.equals(this.__gethttpServerIp(), ip)) {
                    this.__sethttpServerIp(ip);
                    hasChanged = true;
                }
                if (this.__gethttpPort() != port) {
                    this.__sethttpPort(port);
                    hasChanged = true;
                }
            }
            if (hasChanged) {
                this.reconfigure();
            }
        }
        return valid;
    }

    public void reconfigure() {
        if (!this.__Mreconfigure) {
            this.__M_reconfigure();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "reconfigure", new Object[0]);
            this.__M_reconfigure();
            this.__IM.onExit((Object)this, "reconfigure", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "reconfigure", throwable);
            throw throwable;
        }
    }

    private void __M_reconfigure() {
        this.__getlogger().fine("HTTP clients are about to be reconfigured.");
        this.resetClients(false);
    }

    private void resetClients(boolean shutdown) {
        if (!this.__MresetClients$boolean) {
            this.__M_resetClients(shutdown);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "resetClients$boolean", new Object[]{new Boolean(shutdown)});
            this.__M_resetClients(shutdown);
            this.__IM.onExit((Object)this, "resetClients$boolean", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "resetClients$boolean", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __M_resetClients(boolean shutdown) {
        ArrayList clients;
        HttpClientFactory httpClientFactory = this;
        synchronized (httpClientFactory) {
            clients = new ArrayList(this.__getagentClients());
            this.__getagentClients().clear();
        }
        for (HttpAgentClient client : clients) {
            try {
                ReconfigurableClient<?> reconfigurable = client.getReconfigurableClient();
                if (shutdown) {
                    reconfigurable.closeConnection();
                    continue;
                }
                reconfigurable.switchMessagingType("http");
            }
            catch (Throwable t) {
                this.__getlogger().warning("A client has thrown an exception on reconfiguration: " + client);
                Utils.logException((Logger)this.__getlogger(), (Throwable)new RuntimeException(t));
            }
        }
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("agentClients")) {
                this.__FagentClients = true;
            }
            if (set.contains("bundleContext")) {
                this.__FbundleContext = true;
            }
            if (set.contains("dmClient")) {
                this.__FdmClient = true;
            }
            if (set.contains("httpPort")) {
                this.__FhttpPort = true;
            }
            if (set.contains("httpServerIp")) {
                this.__FhttpServerIp = true;
            }
            if (set.contains("httpService")) {
                this.__FhttpService = true;
            }
            if (set.contains("logger")) {
                this.__Flogger = true;
            }
            if (set.contains("routingContext")) {
                this.__FroutingContext = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("setHttpServerIp$java_lang_String")) {
                this.__MsetHttpServerIp$java_lang_String = true;
            }
            if (set.contains("setHttpPort$int")) {
                this.__MsetHttpPort$int = true;
            }
            if (set.contains("getDmClient")) {
                this.__MgetDmClient = true;
            }
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("stopAll")) {
                this.__MstopAll = true;
            }
            if (set.contains("createClient$net_roboconf_messaging_api_reconfigurables_ReconfigurableClient")) {
                this.__McreateClient$net_roboconf_messaging_api_reconfigurables_ReconfigurableClient = true;
            }
            if (set.contains("getType")) {
                this.__MgetType = true;
            }
            if (set.contains("setConfiguration$java_util_Map")) {
                this.__MsetConfiguration$java_util_Map = true;
            }
            if (set.contains("reconfigure")) {
                this.__Mreconfigure = true;
            }
            if (set.contains("resetClients$boolean")) {
                this.__MresetClients$boolean = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }

    public static class HttpRoutingContext
    extends AbstractRoutingClient.RoutingContext {
        public final Map<String, Session> ctxToSession = new ConcurrentHashMap<String, Session>();
    }
}

