/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.messaging.http.internal.clients;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.roboconf.messaging.api.extensions.AbstractRoutingClient;
import net.roboconf.messaging.api.extensions.MessagingContext;
import net.roboconf.messaging.api.jmx.RoboconfMessageQueue;
import net.roboconf.messaging.api.messages.Message;
import net.roboconf.messaging.http.internal.HttpClientFactory;
import net.roboconf.messaging.http.internal.HttpUtils;
import net.roboconf.messaging.http.internal.messages.HttpMessage;
import net.roboconf.messaging.http.internal.messages.SubscriptionMessage;
import org.eclipse.jetty.websocket.api.Session;

public class HttpDmClient
extends AbstractRoutingClient<Session> {
    private static final String DM_OWNER_ID = AbstractRoutingClient.buildOwnerId((MessagingContext.RecipientKind)MessagingContext.RecipientKind.DM, null, null);
    private final Map<String, Session> ctxToSession;
    private RoboconfMessageQueue messageQueue;
    private final AtomicInteger openConnections = new AtomicInteger(0);
    private String httpServerIp;
    private int httpPort;

    public HttpDmClient(HttpClientFactory.HttpRoutingContext routingContext) {
        super((AbstractRoutingClient.RoutingContext)routingContext, MessagingContext.RecipientKind.DM);
        this.connectionIsRequired = false;
        this.ctxToSession = routingContext.ctxToSession;
    }

    public void openConnection() throws IOException {
        this.openConnections.incrementAndGet();
        super.openConnection();
    }

    public void closeConnection() throws IOException {
        if (this.openConnections.decrementAndGet() == 0) {
            super.closeConnection();
        }
    }

    public void setMessageQueue(RoboconfMessageQueue messageQueue) {
        this.messageQueue = messageQueue;
    }

    protected Map<String, Session> getStaticContextToObject() {
        return this.ctxToSession;
    }

    public String getMessagingType() {
        return "http";
    }

    public Map<String, String> getConfiguration() {
        return HttpUtils.httpMessagingConfiguration(this.httpServerIp, this.httpPort);
    }

    protected void process(Session session, Message message) throws IOException {
        if (session.isOpen()) {
            HttpUtils.sendAsynchronously(message, session.getRemote());
        } else {
            this.logger.finer("Session is not available anymore. No message can be published.");
        }
    }

    public void publish(MessagingContext ctx, Message msg) throws IOException {
        this.logger.fine("The DM's HTTP client is about to publish a message (" + msg + ") to " + ctx);
        if (ctx.getKind() == MessagingContext.RecipientKind.DM && this.connected.get()) {
            Set subs = (Set)this.routingContext.subscriptions.get(DM_OWNER_ID);
            if (subs != null && subs.contains(ctx)) {
                this.messageQueue.add((Object)msg);
            }
        } else {
            super.publish(ctx, msg);
        }
    }

    public void processReceivedMessage(Message message, Session session) throws IOException {
        this.logger.fine("The DM's HTTP client is about to process a message (" + message + ") received through a web socket.");
        if (message instanceof HttpMessage) {
            HttpMessage httpMsg = (HttpMessage)message;
            this.registerSession(httpMsg.getOwnerId(), session);
            this.publish(httpMsg.getCtx(), httpMsg.getMessage());
        } else if (message instanceof SubscriptionMessage) {
            SubscriptionMessage sub = (SubscriptionMessage)message;
            this.registerSession(sub.getOwnerId(), session);
            if (sub.isSubscribe()) {
                this.subscribe(sub.getOwnerId(), sub.getCtx());
            } else {
                this.unsubscribe(sub.getOwnerId(), sub.getCtx());
            }
        }
    }

    public void errorWhileReceivingMessage() {
        this.messageQueue.errorWhileReceivingMessage();
    }

    public void setHttpServerIp(String httpServerIp) {
        this.httpServerIp = httpServerIp;
        this.logger.info("The DM's IP address was changed to " + httpServerIp);
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
        this.logger.info("The DM's port was changed to " + httpPort);
    }

    private void registerSession(String ownerId, Session session) {
        if (session != null) {
            this.ctxToSession.put(ownerId, session);
        }
    }
}

