/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.roboconf.core.commands.AbstractCommandInstruction;
import net.roboconf.core.commands.Context;
import net.roboconf.core.errors.ErrorCode;
import net.roboconf.core.errors.ErrorDetails;
import net.roboconf.core.model.ParsingError;
import net.roboconf.core.model.beans.Instance;

public class ChangeStateCommandInstruction
extends AbstractCommandInstruction {
    static final String PREFIX = "change";
    private Instance.InstanceStatus targetStatus;
    private String targetStatusAsString;
    private String instancePath;

    ChangeStateCommandInstruction(Context context, String instruction, int line) {
        super(context, instruction, line);
        Pattern p = Pattern.compile("change\\s+status\\s+of\\s+(/.*)\\s+to\\b(.*)", 2);
        Matcher m = p.matcher(instruction);
        if (m.matches()) {
            this.syntaxicallyCorrect = true;
            this.targetStatusAsString = m.group(2).trim().toUpperCase().replace(' ', '_').replace("_AND_", "_");
            this.targetStatus = Instance.InstanceStatus.exactStatus(this.targetStatusAsString);
            this.instancePath = m.group(1).trim();
        }
    }

    @Override
    public List<ParsingError> doValidate() {
        ArrayList<ParsingError> result = new ArrayList<ParsingError>();
        if (this.targetStatus == null) {
            result.add(this.error(ErrorCode.CMD_INVALID_INSTANCE_STATUS, ErrorDetails.value(this.targetStatusAsString)));
        } else if (!this.targetStatus.isStable()) {
            result.add(this.error(ErrorCode.CMD_INSTABLE_INSTANCE_STATUS));
        }
        if (!this.context.instanceExists(this.instancePath)) {
            result.add(this.error(ErrorCode.CMD_NO_MATCHING_INSTANCE));
        }
        return result;
    }

    public Instance.InstanceStatus getTargetStatus() {
        return this.targetStatus;
    }

    public String getInstancePath() {
        return this.instancePath;
    }
}

