/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.commands;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import net.roboconf.core.model.beans.AbstractApplication;
import net.roboconf.core.model.beans.Component;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.ComponentHelpers;
import net.roboconf.core.model.helpers.InstanceHelpers;
import net.roboconf.core.utils.Utils;

public class Context {
    public final Map<String, String> instancePathToComponentName = new HashMap<String, String>();
    public final Map<String, String> variables = new HashMap<String, String>();
    public final Set<String> disabledVariables = new HashSet<String>();
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final AbstractApplication app;
    private final File commandFile;

    public Context(AbstractApplication app, File commandFile) {
        this.app = app;
        this.commandFile = commandFile;
        for (Instance instance : InstanceHelpers.getAllInstances(app)) {
            this.instancePathToComponentName.put(InstanceHelpers.computeInstancePath(instance), instance.getComponent().getName());
        }
    }

    protected File getCommandFile() {
        return this.commandFile;
    }

    protected String getName() {
        return this.commandFile != null ? this.commandFile.getName() : null;
    }

    protected AbstractApplication getApp() {
        return this.app;
    }

    public boolean instanceExists(String instancePath) {
        Instance instance = this.resolveInstance(instancePath);
        return instance != null;
    }

    public Instance resolveInstance(String instancePath) {
        Instance instance = null;
        String componentName = this.instancePathToComponentName.get(instancePath);
        if (componentName != null) {
            String instanceName = InstanceHelpers.findInstanceName(instancePath);
            Component component = "@fake-component@".equals(componentName) ? new Component("@fake-component@") : ComponentHelpers.findComponent(this.app, componentName);
            if (!Utils.isEmptyOrWhitespaces(instanceName) && component != null) {
                instance = new Instance(instanceName).component(component);
            } else {
                this.logger.warning("Instance's component of " + instancePath + " could not be resolved.");
            }
        }
        return instance;
    }
}

