/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.dsl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import net.roboconf.core.dsl.parsing.FileDefinition;
import net.roboconf.core.internal.dsl.parsing.FileDefinitionParser;
import net.roboconf.core.internal.dsl.parsing.FileDefinitionSerializer;
import net.roboconf.core.utils.Utils;

public final class ParsingModelIo {
    private ParsingModelIo() {
    }

    public static FileDefinition readConfigurationFile(File relationsFile, boolean ignoreComments) {
        FileDefinitionParser parser = new FileDefinitionParser(relationsFile, ignoreComments);
        return parser.read();
    }

    public static String writeConfigurationFile(FileDefinition relationsFile, boolean writeComments, String lineSeparator) {
        return new FileDefinitionSerializer(lineSeparator).write(relationsFile, writeComments);
    }

    public static void saveRelationsFile(FileDefinition relationsFile, boolean writeComments, String lineSeparator) throws IOException {
        if (relationsFile.getEditedFile() == null) {
            throw new IOException("Save operation could not be performed. The model was not loaded from a local file.");
        }
        ParsingModelIo.saveRelationsFileInto(relationsFile.getEditedFile(), relationsFile, writeComments, lineSeparator);
    }

    public static void saveRelationsFileInto(File targetFile, FileDefinition relationsFile, boolean writeComments, String lineSeparator) throws IOException {
        String s = ParsingModelIo.writeConfigurationFile(relationsFile, writeComments, lineSeparator);
        Utils.copyStream(new ByteArrayInputStream(s.getBytes(StandardCharsets.UTF_8)), targetFile);
    }
}

