/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.dsl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.roboconf.core.dsl.parsing.AbstractBlock;
import net.roboconf.core.dsl.parsing.AbstractBlockHolder;
import net.roboconf.core.dsl.parsing.BlockBlank;
import net.roboconf.core.dsl.parsing.BlockComment;
import net.roboconf.core.dsl.parsing.BlockComponent;
import net.roboconf.core.dsl.parsing.BlockFacet;
import net.roboconf.core.dsl.parsing.BlockImport;
import net.roboconf.core.dsl.parsing.BlockInstanceOf;
import net.roboconf.core.dsl.parsing.BlockProperty;
import net.roboconf.core.dsl.parsing.FileDefinition;
import net.roboconf.core.errors.ErrorCode;
import net.roboconf.core.errors.ErrorDetails;
import net.roboconf.core.internal.dsl.parsing.ExportedVariablesParser;
import net.roboconf.core.model.ParsingError;
import net.roboconf.core.model.beans.ExportedVariable;
import net.roboconf.core.utils.ModelUtils;
import net.roboconf.core.utils.Utils;

public final class ParsingModelValidator {
    private ParsingModelValidator() {
    }

    public static Collection<ParsingError> validate(FileDefinition definitionFile) {
        ArrayList<ParsingError> result = new ArrayList<ParsingError>();
        result.addAll(definitionFile.getParsingErrors());
        for (AbstractBlock block : definitionFile.getBlocks()) {
            result.addAll(ParsingModelValidator.validate(block));
        }
        return result;
    }

    public static Collection<ParsingError> validate(AbstractBlock block) {
        Collection<ParsingError> result;
        switch (block.getInstructionType()) {
            case 3: {
                result = ParsingModelValidator.validate((BlockComponent)block);
                break;
            }
            case 2: {
                result = ParsingModelValidator.validate((BlockFacet)block);
                break;
            }
            case 1: {
                result = ParsingModelValidator.validate((BlockImport)block);
                break;
            }
            case 4: {
                result = ParsingModelValidator.validate((BlockComment)block);
                break;
            }
            case 0: {
                result = ParsingModelValidator.validate((BlockProperty)block);
                break;
            }
            case 5: {
                result = ParsingModelValidator.validate((BlockBlank)block);
                break;
            }
            case 6: {
                result = ParsingModelValidator.validate((BlockInstanceOf)block);
                break;
            }
            default: {
                result = new ArrayList<ParsingError>(1);
                ParsingError error = ParsingModelValidator.parsingError(ErrorCode.PM_INVALID_BLOCK_TYPE, block);
                error.setDetails(ErrorDetails.instruction(String.valueOf(block.getInstructionType())));
                result.add(error);
            }
        }
        return result;
    }

    public static Collection<ParsingError> validate(BlockImport block) {
        String uri = block.getUri();
        ArrayList<ParsingError> result = new ArrayList<ParsingError>();
        if (Utils.isEmptyOrWhitespaces(uri)) {
            result.add(ParsingModelValidator.parsingError(ErrorCode.PM_EMPTY_IMPORT_LOCATION, block));
        }
        return result;
    }

    public static Collection<ParsingError> validate(BlockComponent block) {
        return ParsingModelValidator.validatePropertiesHolder(block, true);
    }

    public static Collection<ParsingError> validate(BlockInstanceOf block) {
        Collection<ParsingError> result = ParsingModelValidator.validatePropertiesHolder(block, false);
        BlockProperty prop = block.findPropertyBlockByName("name");
        if (prop == null) {
            result.add(ParsingModelValidator.parsingError(ErrorCode.PM_MISSING_INSTANCE_NAME, block));
        } else if (!prop.getValue().matches("[a-zA-Z_](\\w|-| |\\.)*")) {
            result.add(ParsingModelValidator.parsingError(ErrorCode.PM_INVALID_INSTANCE_NAME, block));
        }
        for (AbstractBlock region : block.getInnerBlocks()) {
            if (region.getInstructionType() == 5 || region.getInstructionType() == 4 || region.getInstructionType() == 0 || region.getInstructionType() == 6) continue;
            ParsingError error = ParsingModelValidator.parsingError(ErrorCode.PM_INVALID_INSTANCE_ELEMENT, region);
            error.setDetails(ErrorDetails.unexpected(region.getClass().getSimpleName()));
            result.add(error);
        }
        return result;
    }

    public static Collection<ParsingError> validate(BlockFacet block) {
        return ParsingModelValidator.validatePropertiesHolder(block, true);
    }

    public static Collection<ParsingError> validate(BlockProperty block) {
        ArrayList<ParsingError> result = new ArrayList<ParsingError>();
        String value = block.getValue();
        String name = block.getName();
        int line = block.getLine();
        if (Utils.isEmptyOrWhitespaces(value)) {
            result.add(new ParsingError(ErrorCode.PM_EMPTY_PROPERTY_VALUE, block.getFile(), line));
        } else if ("children".equals(name)) {
            for (String s : Utils.splitNicely(value, ",")) {
                if (s.matches("[a-zA-Z_](\\w|-|\\.)*")) continue;
                ParsingError error = new ParsingError(ErrorCode.PM_INVALID_CHILD_NAME, block.getFile(), line);
                error.setDetails(ErrorDetails.name(s));
                result.add(error);
            }
        } else if ("facets".equals(name) || "extends".equals(name)) {
            for (String s : Utils.splitNicely(value, ",")) {
                if (Utils.isEmptyOrWhitespaces(s)) {
                    result.add(new ParsingError(ErrorCode.PM_EMPTY_REFERENCED_NAME, block.getFile(), line));
                    continue;
                }
                if (s.matches("[a-zA-Z_](\\w|-|\\.)*")) continue;
                ParsingError error = new ParsingError(ErrorCode.PM_INVALID_NAME, block.getFile(), line);
                error.setDetails(ErrorDetails.name(s));
                result.add(error);
            }
        } else if ("imports".equals(name)) {
            for (String s : Utils.splitNicely(value, ",")) {
                if (s.toLowerCase().endsWith("(optional)")) {
                    s = s.substring(0, s.length() - "(optional)".length());
                }
                if (s.toLowerCase().startsWith("external")) {
                    s = s.substring("external".length());
                }
                String patternForImports = "[a-zA-Z_](\\w|-|\\.)*";
                patternForImports = patternForImports + "(\\.\\*)?";
                if (Utils.isEmptyOrWhitespaces(s = s.trim())) {
                    result.add(new ParsingError(ErrorCode.PM_EMPTY_VARIABLE_NAME, block.getFile(), line));
                    continue;
                }
                if (!s.matches(patternForImports)) {
                    result.add(new ParsingError(ErrorCode.PM_INVALID_IMPORTED_VAR_NAME, block.getFile(), line, ErrorDetails.variable(s)));
                    continue;
                }
                if (s.contains(".") && s.indexOf(46) != s.length() - 1) continue;
                result.add(new ParsingError(ErrorCode.PM_INCOMPLETE_IMPORTED_VAR_NAME, block.getFile(), line, ErrorDetails.variable(s)));
            }
        } else if ("exports".equals(name)) {
            ExportedVariablesParser exportsParser = new ExportedVariablesParser();
            exportsParser.parse(value, block.getFile(), line);
            result.addAll(exportsParser.errors);
            for (ExportedVariable var : ModelUtils.findExportedVariables(value, block.getFile(), line).values()) {
                String exportKey = var.getName();
                if (Utils.isEmptyOrWhitespaces(exportKey)) {
                    result.add(new ParsingError(ErrorCode.PM_EMPTY_VARIABLE_NAME, block.getFile(), line));
                    continue;
                }
                if (exportKey.matches("[a-zA-Z_](\\w|-|\\.)*")) continue;
                result.add(new ParsingError(ErrorCode.PM_INVALID_EXPORTED_VAR_NAME, block.getFile(), line, ErrorDetails.variable(exportKey)));
                if (!exportKey.toLowerCase().startsWith("external ")) continue;
                result.add(new ParsingError(ErrorCode.PM_EXTERNAL_IS_KEYWORD_FOR_IMPORTS, block.getFile(), line, ErrorDetails.variable(exportKey)));
            }
        } else if ("installer".equals(name)) {
            if (!value.matches("[a-zA-Z_](\\w|-| |\\.)*")) {
                result.add(new ParsingError(ErrorCode.PM_INVALID_INSTALLER_NAME, block.getFile(), line, ErrorDetails.name(value)));
            }
        } else if (!("name".equals(name) || "channels".equals(name) || "instance-data".equals(name) || "instance-state".equals(name))) {
            if ("count".equals(name)) {
                int count = -1;
                try {
                    count = Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (count < 1) {
                    result.add(new ParsingError(ErrorCode.PM_INVALID_INSTANCE_COUNT, block.getFile(), line));
                } else if (count == 1) {
                    result.add(new ParsingError(ErrorCode.PM_USELESS_INSTANCE_COUNT, block.getFile(), line));
                }
            } else {
                ParsingError error = new ParsingError(ErrorCode.PM_UNKNOWN_PROPERTY_NAME, block.getFile(), line);
                error.setDetails(ErrorDetails.name(name));
                result.add(error);
            }
        }
        return result;
    }

    public static Collection<ParsingError> validate(BlockComment block) {
        ArrayList<ParsingError> result = new ArrayList<ParsingError>();
        int cpt = 0;
        for (String s : block.getContent().split("\n")) {
            if (!s.trim().startsWith("#")) {
                result.add(new ParsingError(ErrorCode.PM_MALFORMED_COMMENT, block.getFile(), block.getLine() + cpt));
            }
            ++cpt;
        }
        return result;
    }

    public static Collection<ParsingError> validate(BlockBlank block) {
        ArrayList<ParsingError> result = new ArrayList<ParsingError>();
        if (!Utils.isEmptyOrWhitespaces(block.getContent())) {
            result.add(ParsingModelValidator.parsingError(ErrorCode.PM_MALFORMED_BLANK, block));
        }
        return result;
    }

    private static Collection<ParsingError> validatePropertiesHolder(AbstractBlockHolder holder, boolean strict) {
        ArrayList<ParsingError> result = new ArrayList<ParsingError>();
        String name = holder.getName();
        if (Utils.isEmptyOrWhitespaces(name)) {
            result.add(ParsingModelValidator.parsingError(holder.getInstructionType() == 2 ? ErrorCode.PM_EMPTY_FACET_NAME : ErrorCode.PM_EMPTY_COMPONENT_NAME, holder));
        } else if (!name.matches("[a-zA-Z_](\\w|-|\\.)*")) {
            result.add(ParsingModelValidator.parsingError(ErrorCode.PM_INVALID_NAME, holder));
        } else if (name.contains(".")) {
            result.add(ParsingModelValidator.parsingError(ErrorCode.PM_DOT_IS_NOT_ALLOWED, holder));
        }
        List<String> supportedProperties = Arrays.asList(holder.getSupportedPropertyNames());
        HashSet<String> foundProperties = new HashSet<String>();
        for (AbstractBlock region : holder.getInnerBlocks()) {
            if (region.getInstructionType() == 0) {
                ParsingError error;
                BlockProperty p = (BlockProperty)region;
                if (!"imports".equalsIgnoreCase(p.getName()) && !"exports".equalsIgnoreCase(p.getName()) && foundProperties.contains(p.getName())) {
                    error = ParsingModelValidator.parsingError(ErrorCode.PM_DUPLICATE_PROPERTY, p);
                    error.setDetails(ErrorDetails.name(p.getName()));
                    result.add(error);
                }
                foundProperties.add(p.getName());
                if (supportedProperties.contains(p.getName())) {
                    result.addAll(ParsingModelValidator.validate(p));
                    continue;
                }
                if (!strict) continue;
                error = ParsingModelValidator.parsingError(ErrorCode.PM_PROPERTY_NOT_APPLIABLE, p);
                error.setDetails(ErrorDetails.name(p.getName()));
                result.add(error);
                continue;
            }
            result.addAll(ParsingModelValidator.validate(region));
        }
        return result;
    }

    private static ParsingError parsingError(ErrorCode errorCode, AbstractBlock block) {
        return new ParsingError(errorCode, block.getDeclaringFile().getEditedFile(), block.getLine());
    }
}

