/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.errors;

import java.io.File;
import java.util.Objects;
import net.roboconf.core.model.beans.Application;
import net.roboconf.core.model.beans.ApplicationTemplate;
import net.roboconf.core.model.beans.Component;
import net.roboconf.core.model.beans.Facet;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.utils.Utils;

public class ErrorDetails {
    private final String elementName;
    private final ErrorDetailsKind errorDetailsKind;

    protected ErrorDetails(String elementName, ErrorDetailsKind errorDetailsKind) {
        Objects.requireNonNull(errorDetailsKind);
        this.elementName = elementName;
        this.errorDetailsKind = errorDetailsKind;
    }

    public String getElementName() {
        return this.elementName;
    }

    public ErrorDetailsKind getErrorDetailsKind() {
        return this.errorDetailsKind;
    }

    public String toString() {
        return this.errorDetailsKind.name() + " " + this.elementName;
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass().equals(this.getClass()) && ((ErrorDetails)obj).errorDetailsKind == this.errorDetailsKind && Objects.equals(((ErrorDetails)obj).elementName, this.elementName);
    }

    public int hashCode() {
        return this.elementName == null ? 43 : this.elementName.hashCode();
    }

    public static ErrorDetails instance(String instanceName) {
        return new ErrorDetails(instanceName, ErrorDetailsKind.INSTANCE);
    }

    public static ErrorDetails instance(Instance instance) {
        return new ErrorDetails(instance.getName(), ErrorDetailsKind.INSTANCE);
    }

    public static ErrorDetails facet(String facetName) {
        return new ErrorDetails(facetName, ErrorDetailsKind.FACET);
    }

    public static ErrorDetails facet(Facet facet) {
        return ErrorDetails.facet(facet.getName());
    }

    public static ErrorDetails component(String componentName) {
        return new ErrorDetails(componentName, ErrorDetailsKind.COMPONENT);
    }

    public static ErrorDetails component(Component component) {
        return new ErrorDetails(component.getName(), ErrorDetailsKind.COMPONENT);
    }

    public static ErrorDetails application(Application app) {
        return new ErrorDetails(app.getName(), ErrorDetailsKind.APPLICATION);
    }

    public static ErrorDetails application(String appName) {
        return new ErrorDetails(appName, ErrorDetailsKind.APPLICATION);
    }

    public static ErrorDetails applicationTpl(ApplicationTemplate tpl) {
        return ErrorDetails.applicationTpl(tpl.getName(), tpl.getVersion());
    }

    public static ErrorDetails applicationTpl(String tplName, String tplVersion) {
        return new ErrorDetails(tplName + " (" + tplVersion + ")", ErrorDetailsKind.APPLICATION_TEMPLATE);
    }

    public static ErrorDetails variable(String variableName) {
        return new ErrorDetails(variableName, ErrorDetailsKind.VARIABLE);
    }

    public static ErrorDetails file(File file) {
        return ErrorDetails.file(file.getAbsolutePath());
    }

    public static ErrorDetails file(String filePath) {
        return new ErrorDetails(filePath, ErrorDetailsKind.FILE);
    }

    public static ErrorDetails directory(File directory) {
        return ErrorDetails.directory(directory.getAbsolutePath());
    }

    public static ErrorDetails directory(String filePath) {
        return new ErrorDetails(filePath, ErrorDetailsKind.DIRECTORY);
    }

    public static ErrorDetails unrecognized(String unrecognizedName) {
        return new ErrorDetails(unrecognizedName, ErrorDetailsKind.UNRECOGNIZED);
    }

    public static ErrorDetails expected(String expectedName) {
        return new ErrorDetails(expectedName, ErrorDetailsKind.EXPECTED);
    }

    public static ErrorDetails unexpected(String unexpectedName) {
        return new ErrorDetails(unexpectedName, ErrorDetailsKind.UNEXPECTED);
    }

    public static ErrorDetails malformed(String malformedName) {
        return new ErrorDetails(malformedName, ErrorDetailsKind.MALFORMED);
    }

    public static ErrorDetails name(String name) {
        return new ErrorDetails(name, ErrorDetailsKind.NAME);
    }

    public static ErrorDetails instruction(String instruction) {
        return new ErrorDetails(instruction, ErrorDetailsKind.INSTRUCTION);
    }

    public static ErrorDetails cycle(String cycle) {
        return new ErrorDetails(cycle, ErrorDetailsKind.CYCLE);
    }

    public static ErrorDetails exception(Throwable t) {
        return new ErrorDetails(Utils.writeExceptionButDoNotUseItForLogging(t), ErrorDetailsKind.EXCEPTION);
    }

    public static ErrorDetails exceptionName(Throwable t) {
        return new ErrorDetails(t.getClass().getName(), ErrorDetailsKind.EXCEPTION_NAME);
    }

    public static ErrorDetails logReference(String logReference) {
        return new ErrorDetails(logReference, ErrorDetailsKind.LOG_REFERENCE);
    }

    public static ErrorDetails alreadyDefined(String name) {
        return new ErrorDetails(name, ErrorDetailsKind.ALREADY_DEFINED);
    }

    public static ErrorDetails conflicting(String name) {
        return new ErrorDetails(name, ErrorDetailsKind.CONFLICTING);
    }

    public static ErrorDetails value(String value) {
        return new ErrorDetails(value, ErrorDetailsKind.VALUE);
    }

    public static ErrorDetails line(int line) {
        return new ErrorDetails(String.valueOf(line), ErrorDetailsKind.LINE);
    }

    public static enum ErrorDetailsKind {
        INSTANCE,
        VARIABLE,
        COMPONENT,
        FACET,
        INSTRUCTION,
        FILE,
        LINE,
        CYCLE,
        APPLICATION,
        APPLICATION_TEMPLATE,
        DIRECTORY,
        UNRECOGNIZED,
        EXPECTED,
        UNEXPECTED,
        ALREADY_DEFINED,
        CONFLICTING,
        MALFORMED,
        EXCEPTION,
        EXCEPTION_NAME,
        LOG_REFERENCE,
        NAME,
        VALUE;

    }
}

