/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.errors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import net.roboconf.core.errors.ErrorCode;
import net.roboconf.core.errors.ErrorDetails;
import net.roboconf.core.errors.RoboconfError;
import net.roboconf.core.errors.i18n.TranslationBundle;
import net.roboconf.core.model.ModelError;
import net.roboconf.core.model.ParsingError;
import net.roboconf.core.model.RuntimeModelIo;
import net.roboconf.core.model.SourceReference;

public final class RoboconfErrorHelpers {
    private static TranslationBundle resourceBundle = new TranslationBundle(null);
    private static final Object LOCK = new Object();

    private RoboconfErrorHelpers() {
    }

    public static boolean containsCriticalErrors(Collection<? extends RoboconfError> errors) {
        RoboconfError error;
        boolean result = false;
        Iterator<? extends RoboconfError> iterator = errors.iterator();
        while (iterator.hasNext() && !(result = (error = iterator.next()).getErrorCode().getLevel() == ErrorCode.ErrorLevel.SEVERE)) {
        }
        return result;
    }

    public static Collection<RoboconfError> findWarnings(Collection<? extends RoboconfError> errors) {
        ArrayList<RoboconfError> result = new ArrayList<RoboconfError>();
        for (RoboconfError roboconfError : errors) {
            if (roboconfError.getErrorCode().getLevel() != ErrorCode.ErrorLevel.WARNING) continue;
            result.add(roboconfError);
        }
        return result;
    }

    public static List<RoboconfError> resolveErrorsWithLocation(RuntimeModelIo.ApplicationLoadResult alr) {
        ArrayList<RoboconfError> result = new ArrayList<RoboconfError>();
        Iterator<RoboconfError> iterator = alr.getLoadErrors().iterator();
        while (iterator.hasNext()) {
            RoboconfError error;
            RoboconfError errorToAdd = error = iterator.next();
            if (error instanceof ModelError) {
                Object modelObject = ((ModelError)error).getModelObject();
                SourceReference sr = alr.getObjectToSource().get(modelObject);
                if (sr != null) {
                    errorToAdd = new ParsingError(error.getErrorCode(), sr.getSourceFile(), sr.getLine(), error.getDetails());
                }
            }
            result.add(errorToAdd);
        }
        return result;
    }

    public static void filterErrorsForRecipes(RuntimeModelIo.ApplicationLoadResult alr) {
        RoboconfErrorHelpers.filterErrorsForRecipes(alr.getLoadErrors());
    }

    public static void filterErrorsForRecipes(Collection<? extends RoboconfError> errors) {
        RoboconfErrorHelpers.filterErrors(errors, ErrorCode.RM_ROOT_INSTALLER_MUST_BE_TARGET, ErrorCode.RM_UNRESOLVABLE_FACET_VARIABLE, ErrorCode.RM_UNREACHABLE_COMPONENT, ErrorCode.RM_ORPHAN_FACET, ErrorCode.RM_ORPHAN_FACET_WITH_CHILDREN);
    }

    public static void filterErrors(Collection<? extends RoboconfError> errors, ErrorCode ... errorCodes) {
        ArrayList<ErrorCode> codesToSkip = new ArrayList<ErrorCode>();
        codesToSkip.addAll(Arrays.asList(errorCodes));
        ArrayList<RoboconfError> toRemove = new ArrayList<RoboconfError>();
        for (RoboconfError roboconfError : errors) {
            if (!codesToSkip.contains((Object)roboconfError.getErrorCode())) continue;
            toRemove.add(roboconfError);
        }
        errors.removeAll(toRemove);
    }

    public static Map<RoboconfError, String> formatErrors(Collection<? extends RoboconfError> errors, String lang, boolean addMetadata) {
        ResourceBundle resourceBundle = RoboconfErrorHelpers.getResourceBundle(lang);
        LinkedHashMap<RoboconfError, String> result = new LinkedHashMap<RoboconfError, String>();
        for (RoboconfError roboconfError : errors) {
            StringBuilder sb = new StringBuilder();
            if (addMetadata) {
                sb.append("[ ");
                sb.append(roboconfError.getErrorCode().getCategory().toString().toLowerCase());
                sb.append(" ] ");
            }
            sb.append(resourceBundle.getString(roboconfError.getErrorCode().name()));
            sb.append(" ");
            Iterator<ErrorDetails> it = Arrays.asList(roboconfError.getDetails()).iterator();
            while (it.hasNext()) {
                ErrorDetails details = it.next();
                sb.append(resourceBundle.getString(details.getErrorDetailsKind().name()));
                sb.append(details.getElementName());
                if (!it.hasNext()) continue;
                sb.append(resourceBundle.getString("@details-separator@"));
            }
            result.put(roboconfError, sb.toString().trim());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResourceBundle getResourceBundle(String lang) {
        Object object = LOCK;
        synchronized (object) {
            if (!Objects.equals(resourceBundle.getLang(), TranslationBundle.resolve(lang))) {
                resourceBundle = new TranslationBundle(lang);
            }
        }
        return resourceBundle;
    }
}

