/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.model;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.roboconf.core.autonomic.RuleParser;
import net.roboconf.core.commands.CommandsParser;
import net.roboconf.core.dsl.ParsingModelIo;
import net.roboconf.core.dsl.converters.FromGraphDefinition;
import net.roboconf.core.dsl.converters.FromInstanceDefinition;
import net.roboconf.core.dsl.converters.FromInstances;
import net.roboconf.core.dsl.parsing.FileDefinition;
import net.roboconf.core.errors.ErrorCode;
import net.roboconf.core.errors.ErrorDetails;
import net.roboconf.core.errors.RoboconfError;
import net.roboconf.core.errors.RoboconfErrorHelpers;
import net.roboconf.core.model.ApplicationTemplateDescriptor;
import net.roboconf.core.model.ModelError;
import net.roboconf.core.model.ParsingError;
import net.roboconf.core.model.RuntimeModelValidator;
import net.roboconf.core.model.SourceReference;
import net.roboconf.core.model.beans.AbstractApplication;
import net.roboconf.core.model.beans.ApplicationTemplate;
import net.roboconf.core.model.beans.Graphs;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.utils.Utils;

public final class RuntimeModelIo {
    private RuntimeModelIo() {
    }

    public static ApplicationLoadResult loadApplication(File projectDirectory) {
        ApplicationTemplate app;
        ApplicationLoadResult result = new ApplicationLoadResult();
        result.applicationTemplate = app = new ApplicationTemplate();
        ApplicationTemplateDescriptor appDescriptor = null;
        File descDirectory = new File(projectDirectory, "descriptor");
        if (!descDirectory.exists()) {
            RoboconfError error = new RoboconfError(ErrorCode.PROJ_NO_DESC_DIR, ErrorDetails.directory(projectDirectory));
            result.loadErrors.add(error);
        } else {
            File descriptorFile = new File(descDirectory, "application.properties");
            if (!descriptorFile.exists()) {
                result.loadErrors.add(new RoboconfError(ErrorCode.PROJ_NO_DESC_FILE));
            } else {
                try {
                    appDescriptor = ApplicationTemplateDescriptor.load(descriptorFile);
                    app.setName(appDescriptor.getName());
                    app.setDescription(appDescriptor.getDescription());
                    app.setVersion(appDescriptor.getVersion());
                    app.setDslId(appDescriptor.getDslId());
                    app.setExternalExportsPrefix(appDescriptor.getExternalExportsPrefix());
                    app.setTags(appDescriptor.tags);
                    for (Map.Entry<String, String> entry : appDescriptor.externalExports.entrySet()) {
                        app.externalExports.put(entry.getKey(), app.getExternalExportsPrefix() + "." + entry.getValue());
                    }
                    result.objectToSource.put(appDescriptor, new SourceReference(appDescriptor, descriptorFile, 1));
                    for (Map.Entry<String, Object> entry : appDescriptor.propertyToLine.entrySet()) {
                        result.objectToSource.put(entry.getKey(), new SourceReference(entry.getKey(), descriptorFile, (Integer)entry.getValue()));
                    }
                    Collection<ModelError> errors = RuntimeModelValidator.validate(appDescriptor);
                    result.loadErrors.addAll(errors);
                }
                catch (IOException e) {
                    RoboconfError roboconfError = new RoboconfError(ErrorCode.PROJ_READ_DESC_FILE, ErrorDetails.exception(e));
                    result.loadErrors.add(roboconfError);
                }
            }
        }
        return RuntimeModelIo.loadApplication(projectDirectory, appDescriptor, result);
    }

    public static ApplicationLoadResult loadApplicationFlexibly(File projectDirectory) {
        ApplicationLoadResult result;
        File descDirectory = new File(projectDirectory, "descriptor");
        if (descDirectory.exists()) {
            result = RuntimeModelIo.loadApplication(projectDirectory);
        } else {
            ApplicationTemplateDescriptor appDescriptor = new ApplicationTemplateDescriptor();
            appDescriptor.setName("generated");
            appDescriptor.setDslId("generated");
            appDescriptor.setVersion("generated");
            ApplicationLoadResult alr = new ApplicationLoadResult();
            alr.applicationTemplate = new ApplicationTemplate("generated").dslId("generated").version("generated");
            File graphDirectory = new File(projectDirectory, "graph");
            File[] graphFiles = graphDirectory.listFiles(new GraphFileFilter());
            if (graphFiles != null && graphFiles.length > 0) {
                appDescriptor.setGraphEntryPoint(graphFiles[0].getName());
            }
            result = RuntimeModelIo.loadApplication(projectDirectory, appDescriptor, alr);
        }
        return result;
    }

    private static ApplicationLoadResult loadApplication(File projectDirectory, ApplicationTemplateDescriptor appDescriptor, ApplicationLoadResult result) {
        ApplicationTemplate app = result.applicationTemplate;
        result.applicationTemplate.setDirectory(projectDirectory);
        File graphDirectory = new File(projectDirectory, "graph");
        if (!graphDirectory.exists()) {
            RoboconfError error = new RoboconfError(ErrorCode.PROJ_NO_GRAPH_DIR, ErrorDetails.directory(projectDirectory));
            result.loadErrors.add(error);
        } else if (appDescriptor != null && !Utils.isEmptyOrWhitespaces(appDescriptor.getGraphEntryPoint())) {
            File mainGraphFile = new File(graphDirectory, appDescriptor.getGraphEntryPoint());
            if (!mainGraphFile.exists()) {
                RoboconfError error = new RoboconfError(ErrorCode.PROJ_MISSING_GRAPH_EP, ErrorDetails.expected(mainGraphFile.getAbsolutePath()));
                result.loadErrors.add(error);
            } else {
                Graphs graphs = RuntimeModelIo.loadGraph(mainGraphFile, graphDirectory, result);
                app.setGraphs(graphs);
            }
        }
        File instDirectory = new File(projectDirectory, "instances");
        if (appDescriptor != null && instDirectory.exists()) {
            if (app.getGraphs() == null) {
                result.loadErrors.add(new RoboconfError(ErrorCode.CO_GRAPH_COULD_NOT_BE_BUILT));
            } else if (!Utils.isEmptyOrWhitespaces(appDescriptor.getInstanceEntryPoint())) {
                File mainInstFile = new File(instDirectory, appDescriptor.getInstanceEntryPoint());
                InstancesLoadResult ilr = RuntimeModelIo.loadInstances(mainInstFile, instDirectory, app.getGraphs(), app.getName());
                result.getParsedFiles().addAll(ilr.getParsedFiles());
                result.objectToSource.putAll(ilr.getObjectToSource());
                result.loadErrors.addAll(ilr.getLoadErrors());
                app.getRootInstances().addAll(ilr.getRootInstances());
            }
        }
        File commandsDirectory = new File(projectDirectory, "commands");
        ArrayList<String> commandNames = new ArrayList<String>();
        if (app.getGraphs() != null && commandsDirectory.exists()) {
            for (File file : Utils.listAllFiles(commandsDirectory)) {
                if (!file.getName().endsWith(".commands")) {
                    result.loadErrors.add(new RoboconfError(ErrorCode.PROJ_INVALID_COMMAND_EXT));
                    continue;
                }
                CommandsParser parser = new CommandsParser((AbstractApplication)app, file);
                result.loadErrors.addAll(parser.getParsingErrors());
                commandNames.add(file.getName().replace(".commands", ""));
            }
        }
        File autonomicRulesDirectory = new File(projectDirectory, "rules.autonomic");
        if (app.getGraphs() != null && autonomicRulesDirectory.exists()) {
            for (File f : Utils.listAllFiles(autonomicRulesDirectory)) {
                if (!f.getName().endsWith(".drl")) {
                    result.loadErrors.add(new RoboconfError(ErrorCode.PROJ_INVALID_RULE_EXT));
                    continue;
                }
                RuleParser parser = new RuleParser(f);
                result.loadErrors.addAll(parser.getParsingErrors());
                ArrayList<String> coll = new ArrayList<String>(parser.getRule().getCommandsToInvoke());
                coll.removeAll(commandNames);
                for (String commandName : coll) {
                    result.loadErrors.add(new RoboconfError(ErrorCode.RULE_UNKNOWN_COMMAND, ErrorDetails.name(commandName)));
                }
            }
        }
        if (projectDirectory.isDirectory()) {
            String[] stringArray = new String[]{".graph", ".instances"};
            File[] directories = new File[]{graphDirectory, instDirectory};
            for (int i = 0; i < stringArray.length; ++i) {
                List<File> files = Utils.listAllFiles(projectDirectory, stringArray[i]);
                ArrayList<File> filesWithInvalidLocation = new ArrayList<File>();
                for (File f : files) {
                    if (Utils.isAncestor(directories[i], f)) continue;
                    result.loadErrors.add(new ParsingError(ErrorCode.PROJ_INVALID_FILE_LOCATION, f, 1));
                    filesWithInvalidLocation.add(f);
                }
                files.removeAll(result.getParsedFiles());
                files.removeAll(filesWithInvalidLocation);
                for (File f : files) {
                    result.loadErrors.add(new ParsingError(ErrorCode.PROJ_UNREACHABLE_FILE, f, 1));
                }
            }
        }
        if (!RoboconfErrorHelpers.containsCriticalErrors(result.loadErrors)) {
            Collection<ModelError> collection = RuntimeModelValidator.validate(app);
            result.loadErrors.addAll(collection);
        }
        return result;
    }

    public static Graphs loadGraph(File graphFile, File graphDirectory, ApplicationLoadResult alr) {
        FromGraphDefinition fromDef = new FromGraphDefinition(graphDirectory);
        Graphs graph = fromDef.buildGraphs(graphFile);
        alr.getParsedFiles().addAll(fromDef.getProcessedImports());
        if (!fromDef.getErrors().isEmpty()) {
            alr.loadErrors.addAll(fromDef.getErrors());
        } else {
            Collection<ModelError> errors = RuntimeModelValidator.validate(graph);
            alr.loadErrors.addAll(errors);
            errors = RuntimeModelValidator.validate(graph, graphDirectory.getParentFile());
            alr.loadErrors.addAll(errors);
            alr.objectToSource.putAll(fromDef.getObjectToSource());
            alr.typeAnnotations.putAll(fromDef.getTypeAnnotations());
        }
        return graph;
    }

    public static InstancesLoadResult loadInstances(File instancesFile, File rootDirectory, Graphs graph, String applicationName) {
        InstancesLoadResult result = new InstancesLoadResult();
        if (!instancesFile.exists()) {
            RoboconfError error = new RoboconfError(ErrorCode.PROJ_MISSING_INSTANCE_EP);
            error.setDetails(ErrorDetails.expected(instancesFile.getAbsolutePath()));
            result.loadErrors.add(error);
        } else {
            FromInstanceDefinition fromDef = new FromInstanceDefinition(rootDirectory);
            Collection<Instance> instances = fromDef.buildInstances(graph, instancesFile);
            result.getParsedFiles().addAll(fromDef.getProcessedImports());
            if (!fromDef.getErrors().isEmpty()) {
                result.loadErrors.addAll(fromDef.getErrors());
            } else {
                Collection<ModelError> errors = RuntimeModelValidator.validate(instances);
                result.loadErrors.addAll(errors);
                result.objectToSource.putAll(fromDef.getObjectToSource());
                result.getRootInstances().addAll(instances);
            }
        }
        for (Instance rootInstance : result.rootInstances) {
            rootInstance.data.put("application.name", applicationName);
        }
        return result;
    }

    public static void writeInstances(File targetFile, Collection<Instance> rootInstances) throws IOException {
        FileDefinition def = new FromInstances().buildFileDefinition(rootInstances, targetFile, false, true);
        ParsingModelIo.saveRelationsFile(def, false, "\n");
    }

    static class GraphFileFilter
    implements FileFilter {
        GraphFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isFile() && f.getName().toLowerCase().endsWith(".graph");
        }
    }

    public static class InstancesLoadResult {
        Collection<Instance> rootInstances = new ArrayList<Instance>();
        final Collection<RoboconfError> loadErrors = new ArrayList<RoboconfError>();
        final Map<Object, SourceReference> objectToSource = new HashMap<Object, SourceReference>();
        final Set<File> parsedFiles = new HashSet<File>();

        public Collection<Instance> getRootInstances() {
            return this.rootInstances;
        }

        public Collection<RoboconfError> getLoadErrors() {
            return this.loadErrors;
        }

        public Map<Object, SourceReference> getObjectToSource() {
            return this.objectToSource;
        }

        public Set<File> getParsedFiles() {
            return this.parsedFiles;
        }
    }

    public static class ApplicationLoadResult {
        ApplicationTemplate applicationTemplate;
        final Collection<RoboconfError> loadErrors = new ArrayList<RoboconfError>();
        final Map<Object, SourceReference> objectToSource = new HashMap<Object, SourceReference>();
        final Set<File> parsedFiles = new HashSet<File>();
        final Map<String, String> typeAnnotations = new HashMap<String, String>();

        public ApplicationTemplate getApplicationTemplate() {
            return this.applicationTemplate;
        }

        public Collection<RoboconfError> getLoadErrors() {
            return this.loadErrors;
        }

        public Map<Object, SourceReference> getObjectToSource() {
            return this.objectToSource;
        }

        public Set<File> getParsedFiles() {
            return this.parsedFiles;
        }

        public Map<String, String> getTypeAnnotations() {
            return this.typeAnnotations;
        }
    }
}

