/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.model.beans;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.roboconf.core.model.beans.AbstractType;
import net.roboconf.core.model.beans.Facet;
import net.roboconf.core.model.beans.ImportedVariable;

public class Component
extends AbstractType
implements Serializable {
    private static final long serialVersionUID = 5163458185512982868L;
    private String installerName;
    private Component extendedComponent;
    public final Map<String, ImportedVariable> importedVariables = new HashMap<String, ImportedVariable>(0);
    private final Collection<Component> extendingComponents = new HashSet<Component>(0);
    private final Collection<Facet> facets = new HashSet<Facet>(0);

    public Component() {
    }

    public Component(String name) {
        this.name = name;
    }

    public String getInstallerName() {
        return this.installerName;
    }

    public void setInstallerName(String installerName) {
        this.installerName = installerName;
    }

    public Component getExtendedComponent() {
        return this.extendedComponent;
    }

    public Collection<Component> getExtendingComponents() {
        return Collections.unmodifiableCollection(this.extendingComponents);
    }

    public Collection<Facet> getFacets() {
        return Collections.unmodifiableCollection(this.facets);
    }

    public Component name(String name) {
        this.name = name;
        return this;
    }

    public Component installerName(String installerName) {
        this.installerName = installerName;
        return this;
    }

    public void extendComponent(Component component) {
        if (this.extendedComponent != null) {
            this.extendedComponent.extendingComponents.remove(this);
        }
        component.extendingComponents.add(this);
        this.extendedComponent = component;
    }

    public void associateFacet(Facet facet) {
        this.facets.add(facet);
        facet.associatedComponents.add(this);
    }

    public void disassociateFacet(Facet facet) {
        this.facets.remove(facet);
        facet.associatedComponents.remove(this);
    }

    public void addImportedVariable(ImportedVariable var) {
        this.importedVariables.put(var.getName(), var);
    }
}

