/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.model.beans;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.InstanceHelpers;

public class Import
implements Serializable {
    private static final long serialVersionUID = 1926254974053785327L;
    private final String instancePath;
    private final String componentName;
    private final Map<String, String> exportedVars = new HashMap<String, String>();

    public Import(Instance instance) {
        this(InstanceHelpers.computeInstancePath(instance), instance.getComponent() == null ? null : instance.getComponent().getName(), InstanceHelpers.findAllExportedVariables(instance));
    }

    public Import(String instancePath, String componentName) {
        this(instancePath, componentName, null);
    }

    public Import(String instancePath, String componentName, Map<String, String> exportedVars) {
        this.instancePath = instancePath;
        this.componentName = componentName;
        if (exportedVars != null) {
            this.exportedVars.putAll(exportedVars);
        }
    }

    public Map<String, String> getExportedVars() {
        return this.exportedVars;
    }

    public String getInstancePath() {
        return this.instancePath;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public boolean equals(Object obj) {
        return obj instanceof Import && Objects.equals(this.instancePath, ((Import)obj).instancePath);
    }

    public int hashCode() {
        return this.instancePath.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.instancePath);
        sb.append(" exports [ ");
        Iterator<Map.Entry<String, String>> it = this.exportedVars.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            sb.append(entry.getKey());
            sb.append("=");
            sb.append(entry.getValue());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(" ] ");
        return sb.toString();
    }
}

