/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.model.beans;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArraySet;
import net.roboconf.core.model.beans.Component;
import net.roboconf.core.model.beans.Import;
import net.roboconf.core.model.helpers.InstanceHelpers;
import net.roboconf.core.utils.RoboconfFlexMap;

public class Instance
implements Serializable {
    public static final String IP_ADDRESS = "ip.address";
    public static final String MACHINE_ID = "machine.id";
    public static final String TARGET_ACQUIRED = "target.acquired";
    public static final String APPLICATION_NAME = "application.name";
    public static final String LAST_PROBLEM = "last.problem";
    public static final String READY_FOR_CFG_MARKER = "ready.for.local.script.configuration";
    public static final String RUNNING_FROM = "running.from";
    public static final String DELETE_WHEN_NOT_DEPLOYED = "delete.when.not.deployed";
    private static final long serialVersionUID = -3320865356277185064L;
    private String name;
    private Component component;
    private Instance parent;
    private final Collection<Instance> children = new CopyOnWriteArraySet<Instance>();
    private InstanceStatus status = InstanceStatus.NOT_DEPLOYED;
    public final Collection<String> channels = new HashSet<String>();
    public final Map<String, String> overriddenExports = new HashMap<String, String>();
    public final Map<String, String> data = new RoboconfFlexMap<String, String>("@!xyz!@");
    private final Map<String, Collection<Import>> variablePrefixToImports = new TreeMap<String, Collection<Import>>();

    public Instance() {
    }

    public Instance(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public synchronized InstanceStatus getStatus() {
        return this.status;
    }

    public synchronized void setStatus(InstanceStatus status) {
        this.status = status;
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        this.component = component;
    }

    public Instance getParent() {
        return this.parent;
    }

    public void setParent(Instance parent) {
        this.parent = parent;
    }

    public Collection<Instance> getChildren() {
        return this.children;
    }

    public int hashCode() {
        return InstanceHelpers.computeInstancePath(this).hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof Instance && InstanceHelpers.haveSamePath(this, (Instance)obj);
    }

    public String toString() {
        return this.name;
    }

    public Instance name(String name) {
        this.name = name;
        return this;
    }

    public Instance component(Component component) {
        this.component = component;
        return this;
    }

    public Instance parent(Instance parent) {
        this.parent = parent;
        return this;
    }

    public Instance channel(String channel) {
        this.channels.add(channel);
        return this;
    }

    public synchronized Instance status(InstanceStatus status) {
        this.status = status;
        return this;
    }

    public Map<String, Collection<Import>> getImports() {
        return this.variablePrefixToImports;
    }

    public static enum InstanceStatus implements Serializable
    {
        NOT_DEPLOYED(true),
        DEPLOYING(false),
        DEPLOYED_STOPPED(true),
        UNRESOLVED(true),
        WAITING_FOR_ANCESTOR(true),
        STARTING(false),
        DEPLOYED_STARTED(true),
        STOPPING(false),
        UNDEPLOYING(false),
        PROBLEM(false);

        private final boolean stable;

        private InstanceStatus(boolean stable) {
            this.stable = stable;
        }

        public static InstanceStatus whichStatus(String s) {
            InstanceStatus result = InstanceStatus.exactStatus(s);
            return result == null ? NOT_DEPLOYED : result;
        }

        public static InstanceStatus exactStatus(String s) {
            InstanceStatus result = null;
            for (InstanceStatus status : InstanceStatus.values()) {
                if (!status.toString().equalsIgnoreCase(s)) continue;
                result = status;
                break;
            }
            return result;
        }

        public static boolean isValidState(String s) {
            boolean valid = false;
            for (InstanceStatus status : InstanceStatus.values()) {
                if (!status.toString().equalsIgnoreCase(s)) continue;
                valid = true;
                break;
            }
            return valid;
        }

        public boolean isStable() {
            return this.stable;
        }
    }
}

