/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.roboconf.core.utils.ProcessStore;
import net.roboconf.core.utils.Utils;

public final class ProgramUtils {
    private ProgramUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExecutionResult executeCommandWithResult(Logger logger, String[] command, File workingDir, Map<String, String> environmentVars, String applicationName, String scopedInstancePath) throws IOException, InterruptedException {
        logger.fine("Executing command: " + Arrays.toString(command));
        ProcessBuilder pb = new ProcessBuilder(command);
        if (workingDir != null) {
            pb.directory(workingDir);
        }
        Map<String, String> env = pb.environment();
        if (environmentVars != null && env != null) {
            for (Map.Entry<String, String> entry : environmentVars.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) continue;
                env.put(entry.getKey(), entry.getValue());
            }
        }
        StringBuilder normalOutput = new StringBuilder();
        StringBuilder errorOutput = new StringBuilder();
        int exitValue = -1;
        Process process = pb.start();
        logger.fine("Storing process [" + applicationName + "] [" + scopedInstancePath + "]");
        ProcessStore.setProcess(applicationName, scopedInstancePath, process);
        try {
            new Thread(new OutputRunnable(process, true, errorOutput, logger)).start();
            new Thread(new OutputRunnable(process, false, normalOutput, logger)).start();
            exitValue = process.waitFor();
            if (exitValue != 0) {
                logger.warning("Command execution returned a non-zero code. Code:" + exitValue);
            }
        }
        finally {
            ProcessStore.clearProcess(applicationName, scopedInstancePath);
        }
        return new ExecutionResult(normalOutput.toString().trim(), errorOutput.toString().trim(), exitValue);
    }

    public static int executeCommand(Logger logger, String[] command, File workingDir, Map<String, String> environmentVars, String applicationName, String scopedInstancePath) throws IOException, InterruptedException {
        ExecutionResult result = ProgramUtils.executeCommandWithResult(logger, command, workingDir, environmentVars, applicationName, scopedInstancePath);
        if (!Utils.isEmptyOrWhitespaces(result.getNormalOutput())) {
            logger.fine(result.getNormalOutput());
        }
        if (!Utils.isEmptyOrWhitespaces(result.getErrorOutput())) {
            logger.warning(result.getErrorOutput());
        }
        return result.getExitValue();
    }

    public static int executeCommand(Logger logger, List<String> command, File workingDir, Map<String, String> environmentVars, String applicationName, String scopedInstanceName) throws IOException, InterruptedException {
        return ProgramUtils.executeCommand(logger, command.toArray(new String[0]), workingDir, environmentVars, applicationName, scopedInstanceName);
    }

    private static class OutputRunnable
    implements Runnable {
        private final Process process;
        private final boolean errorLevel;
        private final Logger logger;
        private final StringBuilder sb;

        public OutputRunnable(Process process, boolean errorLevel, StringBuilder sb, Logger logger) {
            this.process = process;
            this.errorLevel = errorLevel;
            this.sb = sb;
            this.logger = logger;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String prefix = this.errorLevel ? "-- ERROR --" : "";
            BufferedReader br = null;
            try {
                InputStream is = this.errorLevel ? this.process.getErrorStream() : this.process.getInputStream();
                br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
                String line = br.readLine();
                while (line != null) {
                    this.sb.append(prefix + line + "\n");
                    line = br.readLine();
                }
                Utils.closeQuietly(br);
            }
            catch (IOException e) {
                this.logger.severe(Utils.writeExceptionButDoNotUseItForLogging(e));
            }
            finally {
                Utils.closeQuietly(br);
            }
        }
    }

    public static class ExecutionResult {
        private final String normalOutput;
        private final String errorOutput;
        private final int exitValue;

        public ExecutionResult(String normalOutput, String errorOutput, int exitValue) {
            this.normalOutput = normalOutput;
            this.errorOutput = errorOutput;
            this.exitValue = exitValue;
        }

        public String getNormalOutput() {
            return this.normalOutput;
        }

        public String getErrorOutput() {
            return this.errorOutput;
        }

        public int getExitValue() {
            return this.exitValue;
        }
    }
}

