/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

public class RoboconfFlexMap<K extends Comparable<?>, V>
implements Serializable,
Map<K, V> {
    private static final long serialVersionUID = 7715241436637667834L;
    private final ConcurrentHashMap<K, V> map = new ConcurrentHashMap();
    private final V nullValue;

    public RoboconfFlexMap(V nullValue) {
        this.nullValue = nullValue;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return new TreeSet(this.map.keySet());
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof RoboconfFlexMap && this.nullValue.equals(((RoboconfFlexMap)obj).nullValue) && this.map.equals(((RoboconfFlexMap)obj).map);
    }

    @Override
    public V get(Object key) {
        return this.outFilter(this.map.get(key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(this.rawInFilter(value));
    }

    @Override
    public V put(K key, V value) {
        return this.map.put(key, this.inFilter(value));
    }

    @Override
    public V remove(Object key) {
        return this.outFilter(this.map.remove(key));
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        TreeMap<K, V> tempMap = new TreeMap<K, V>();
        for (Map.Entry<K, V> entry : this.map.entrySet()) {
            tempMap.put(entry.getKey(), this.outFilter(entry.getValue()));
        }
        return tempMap.entrySet();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        LinkedHashMap<K, V> m2 = new LinkedHashMap<K, V>(m);
        for (Map.Entry entry : m2.entrySet()) {
            this.put((K)((Comparable)entry.getKey()), (V)entry.getValue());
        }
    }

    @Override
    public Collection<V> values() {
        ArrayList<V> result = new ArrayList<V>(this.map.size());
        for (Map.Entry<K, V> entry : this.entrySet()) {
            result.add(this.outFilter(entry.getValue()));
        }
        return result;
    }

    private V outFilter(V value) {
        return Objects.equals(value, this.nullValue) ? null : (V)value;
    }

    private V inFilter(V value) {
        return value == null ? this.nullValue : value;
    }

    private Object rawInFilter(Object value) {
        return value == null ? this.nullValue : value;
    }
}

