/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.configuration;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.utils.json.JSONWriter;
import org.apache.felix.webconsole.DefaultVariableResolver;
import org.apache.felix.webconsole.SimpleWebConsolePlugin;
import org.apache.felix.webconsole.WebConsoleUtil;
import org.apache.felix.webconsole.internal.OsgiManagerPlugin;
import org.apache.felix.webconsole.internal.configuration.ConfigAdminSupport;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;

public class ConfigManager
extends SimpleWebConsolePlugin
implements OsgiManagerPlugin {
    private static final long serialVersionUID = 5021174538498622428L;
    private static final String LABEL = "configMgr";
    private static final String TITLE = "%configMgr.pluginTitle";
    private static final String[] CSS = new String[]{"/res/ui/config.css"};
    static final String PID_FILTER = "pidFilter";
    static final String PID = "pid";
    static final String FACTORY_PID = "factoryPid";
    static final String PLACEHOLDER_PID = "[Temporary PID replaced by real PID upon save]";
    static final String REFERER = "referer";
    static final String FACTORY_CREATE = "factoryCreate";
    static final String ACTION_CREATE = "create";
    static final String ACTION_DELETE = "delete";
    static final String ACTION_APPLY = "apply";
    static final String ACTION_UNBIND = "unbind";
    static final String PROPERTY_LIST = "propertylist";
    static final String LOCATION = "$location";
    static final String CONFIGURATION_ADMIN_NAME = "org.osgi.service.cm.ConfigurationAdmin";
    static final String META_TYPE_NAME = "org.osgi.service.metatype.MetaTypeService";
    public static final String UNBOUND_LOCATION = "??unbound:bundle/location";
    private final String TEMPLATE = this.readTemplateFile("/templates/config.html");

    public ConfigManager() {
        super(LABEL, TITLE, "OSGi", CSS);
    }

    static final boolean isAllowedPid(String pid) {
        for (int i = 0; i < pid.length(); ++i) {
            char c = pid.charAt(i);
            if (c != '&' && c != '<' && c != '>' && c != '\"' && c != '\'') continue;
            return false;
        }
        return true;
    }

    private static final Locale getLocale(HttpServletRequest request) {
        try {
            return request.getLocale();
        }
        catch (Throwable t) {
            return Locale.getDefault();
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String pid = request.getParameter(PID);
        if (pid == null) {
            String info = request.getPathInfo();
            pid = WebConsoleUtil.urlDecode(info.substring(info.lastIndexOf(47) + 1));
        }
        String pidFilter = request.getParameter(PID_FILTER);
        ConfigAdminSupport cas = this.getConfigurationAdminSupport();
        if (pid == null || pid.length() == 0 || cas == null) {
            return;
        }
        if (!ConfigManager.isAllowedPid(pid)) {
            response.sendError(500);
            return;
        }
        if (pidFilter != null && !ConfigManager.isAllowedPid(pidFilter)) {
            response.sendError(500);
            return;
        }
        Configuration config = null;
        if (request.getParameter(ACTION_CREATE) != null) {
            config = cas.getPlaceholderConfiguration(pid);
            pid = config.getPid();
        } else if (request.getParameter(ACTION_APPLY) != null) {
            String redirect = cas.applyConfiguration(request, pid);
            if (redirect != null) {
                if (pidFilter != null) {
                    redirect = redirect + "?pidFilter=" + pidFilter;
                }
                WebConsoleUtil.sendRedirect(request, response, redirect);
            } else {
                response.setContentType("application/json");
                response.setCharacterEncoding("UTF-8");
                response.getWriter().print("{ \"status\": true }");
            }
            return;
        }
        if (config == null) {
            config = cas.getConfiguration(pid);
        }
        if (request.getParameter(ACTION_UNBIND) != null) {
            if (config != null && config.getBundleLocation() != null) {
                config.setBundleLocation(UNBOUND_LOCATION);
            }
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            response.getWriter().print("{ \"status\": true }");
            return;
        }
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        Locale loc = ConfigManager.getLocale(request);
        String locale = loc != null ? loc.toString() : null;
        cas.printConfigurationJson(response.getWriter(), pid, config, pidFilter, locale);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if ("true".equals(request.getParameter("post"))) {
            this.doPost(request, response);
            return;
        }
        String info = request.getPathInfo();
        if (info.endsWith(".json")) {
            Locale loc;
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            String pid = info.substring(info.lastIndexOf(47) + 1, info.length() - 5);
            String pidFilter = request.getParameter(PID_FILTER);
            if (pidFilter == null) {
                pidFilter = pid;
            }
            try {
                this.getBundleContext().createFilter(pidFilter);
                if (pid == pidFilter) {
                    pid = null;
                }
            }
            catch (InvalidSyntaxException ise) {
                pidFilter = null;
            }
            if (pid != null && !ConfigManager.isAllowedPid(pid)) {
                response.sendError(500);
            }
            if (pidFilter != null && !ConfigManager.isAllowedPid(pidFilter)) {
                response.sendError(500);
            }
            String locale = (loc = ConfigManager.getLocale(request)) != null ? loc.toString() : null;
            PrintWriter pw = response.getWriter();
            pw.write("[");
            ConfigAdminSupport ca = this.getConfigurationAdminSupport();
            if (ca != null) {
                StringBuffer sb = new StringBuffer();
                if (pid != null && pidFilter != null) {
                    sb.append("(&");
                }
                if (pid != null) {
                    sb.append('(');
                    sb.append("service.pid");
                    sb.append('=');
                    sb.append(pid);
                    sb.append(')');
                }
                if (pidFilter != null) {
                    sb.append(pidFilter);
                }
                if (pid != null && pidFilter != null) {
                    sb.append(')');
                }
                String filter = sb.toString();
                try {
                    Configuration[] configs = ca.listConfigurations(filter);
                    boolean printComma = false;
                    for (int i = 0; configs != null && i < configs.length; ++i) {
                        Configuration config = configs[i];
                        if (config == null) continue;
                        if (printComma) {
                            pw.print(',');
                        }
                        ca.printConfigurationJson(pw, config.getPid(), config, null, locale);
                        printComma = true;
                    }
                }
                catch (InvalidSyntaxException invalidSyntaxException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            pw.write("]");
            return;
        }
        super.doGet(request, response);
    }

    protected void renderContent(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Locale loc;
        String pid = request.getPathInfo().substring(this.getLabel().length() + 1);
        pid = pid.length() == 0 ? null : pid.substring(pid.lastIndexOf(47) + 1);
        String pidFilter = request.getParameter(PID_FILTER);
        if (pidFilter == null) {
            pidFilter = pid;
        }
        if (pidFilter != null) {
            try {
                this.getBundleContext().createFilter(pidFilter);
                if (pid == pidFilter) {
                    pid = null;
                }
            }
            catch (InvalidSyntaxException ise) {
                pidFilter = null;
            }
        }
        if (pid != null && !ConfigManager.isAllowedPid(pid)) {
            response.sendError(500);
        }
        if (pidFilter != null && !ConfigManager.isAllowedPid(pidFilter)) {
            response.sendError(500);
        }
        String locale = (loc = ConfigManager.getLocale(request)) != null ? loc.toString() : null;
        StringWriter json = new StringWriter();
        JSONWriter jw = new JSONWriter(json);
        jw.object();
        ConfigAdminSupport ca = this.getConfigurationAdminSupport();
        jw.key("status").value(ca != null ? Boolean.TRUE : Boolean.FALSE);
        if (ca != null) {
            ca.listConfigurations(jw, pidFilter, locale, loc);
            ca.listFactoryConfigurations(jw, pidFilter, locale);
        }
        jw.endObject();
        if (request.getParameter(ACTION_CREATE) != null && pid != null) {
            pid = PLACEHOLDER_PID;
        }
        String referer = request.getParameter(REFERER);
        boolean factoryCreate = "true".equals(request.getParameter(FACTORY_CREATE));
        DefaultVariableResolver vars = (DefaultVariableResolver)WebConsoleUtil.getVariableResolver((ServletRequest)request);
        vars.put("__data__", json.toString());
        vars.put("selectedPid", pid != null ? pid : "");
        vars.put("configurationReferer", referer != null ? referer : "");
        vars.put(FACTORY_CREATE, factoryCreate);
        vars.put("param.apply", ACTION_APPLY);
        vars.put("param.create", ACTION_CREATE);
        vars.put("param.unbind", ACTION_UNBIND);
        vars.put("param.delete", ACTION_DELETE);
        vars.put("param.propertylist", PROPERTY_LIST);
        vars.put("param.pidFilter", PID_FILTER);
        response.getWriter().print(this.TEMPLATE);
    }

    private ConfigAdminSupport getConfigurationAdminSupport() {
        Object configurationAdmin = this.getService(CONFIGURATION_ADMIN_NAME);
        if (configurationAdmin != null) {
            return new ConfigAdminSupport(this, this.getBundleContext(), configurationAdmin);
        }
        return null;
    }
}

