/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.internal.api.impl;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import net.roboconf.core.errors.ErrorCode;
import net.roboconf.core.errors.RoboconfError;
import net.roboconf.core.errors.RoboconfErrorHelpers;
import net.roboconf.core.model.ApplicationDescriptor;
import net.roboconf.core.model.RuntimeModelIo;
import net.roboconf.core.model.beans.AbstractApplication;
import net.roboconf.core.model.beans.Application;
import net.roboconf.core.model.beans.ApplicationTemplate;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.InstanceHelpers;
import net.roboconf.core.model.runtime.EventType;
import net.roboconf.core.utils.Utils;
import net.roboconf.dm.internal.api.IRandomMngr;
import net.roboconf.dm.internal.utils.ConfigurationUtils;
import net.roboconf.dm.management.ManagedApplication;
import net.roboconf.dm.management.api.IApplicationMngr;
import net.roboconf.dm.management.api.IApplicationTemplateMngr;
import net.roboconf.dm.management.api.IAutonomicMngr;
import net.roboconf.dm.management.api.IConfigurationMngr;
import net.roboconf.dm.management.api.IMessagingMngr;
import net.roboconf.dm.management.api.INotificationMngr;
import net.roboconf.dm.management.api.ITargetsMngr;
import net.roboconf.dm.management.exceptions.AlreadyExistingException;
import net.roboconf.dm.management.exceptions.InvalidApplicationException;
import net.roboconf.dm.management.exceptions.UnauthorizedActionException;
import net.roboconf.messaging.api.business.ListenerCommand;
import net.roboconf.messaging.api.messages.Message;
import net.roboconf.messaging.api.messages.from_dm_to_agent.MsgCmdChangeBinding;

public class ApplicationMngrImpl
implements IApplicationMngr {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final Map<String, ManagedApplication> nameToManagedApplication = new ConcurrentHashMap<String, ManagedApplication>();
    private final INotificationMngr notificationMngr;
    private final IConfigurationMngr configurationMngr;
    private final ITargetsMngr targetsMngr;
    private final IMessagingMngr messagingMngr;
    private final IRandomMngr randomMngr;
    private final IAutonomicMngr autonomicMngr;
    private IApplicationTemplateMngr applicationTemplateMngr;

    public ApplicationMngrImpl(INotificationMngr notificationMngr, IConfigurationMngr configurationMngr, ITargetsMngr targetsMngr, IMessagingMngr messagingMngr, IRandomMngr randomMngr, IAutonomicMngr autonomicMngr) {
        this.notificationMngr = notificationMngr;
        this.configurationMngr = configurationMngr;
        this.messagingMngr = messagingMngr;
        this.targetsMngr = targetsMngr;
        this.randomMngr = randomMngr;
        this.autonomicMngr = autonomicMngr;
    }

    public void setApplicationTemplateMngr(IApplicationTemplateMngr applicationTemplateMngr) {
        this.applicationTemplateMngr = applicationTemplateMngr;
    }

    @Override
    public Application findApplicationByName(String applicationName) {
        ManagedApplication ma = this.nameToManagedApplication.get(applicationName);
        return ma != null ? ma.getApplication() : null;
    }

    @Override
    public ManagedApplication findManagedApplicationByName(String applicationName) {
        return this.nameToManagedApplication.get(applicationName);
    }

    @Override
    public Collection<ManagedApplication> getManagedApplications() {
        return this.nameToManagedApplication.values();
    }

    @Override
    public ManagedApplication createApplication(String name, String description, String tplName, String tplQualifier) throws IOException, AlreadyExistingException, InvalidApplicationException {
        this.messagingMngr.checkMessagingConfiguration();
        ApplicationTemplate tpl = this.applicationTemplateMngr.findTemplate(tplName, tplQualifier);
        if (tpl == null) {
            throw new InvalidApplicationException(new RoboconfError(ErrorCode.PROJ_APPLICATION_TEMPLATE_NOT_FOUND));
        }
        return this.createApplication(name, description, tpl);
    }

    @Override
    public ManagedApplication createApplication(String name, String description, ApplicationTemplate tpl) throws IOException, AlreadyExistingException {
        this.messagingMngr.checkMessagingConfiguration();
        ManagedApplication ma = this.createNewApplication(name, description, tpl, this.configurationMngr.getWorkingDirectory());
        this.targetsMngr.copyOriginalMapping(ma.getApplication());
        this.randomMngr.generateAllRandomValues(ma.getApplication());
        this.messagingMngr.getMessagingClient().listenToAgentMessages(ma.getApplication(), ListenerCommand.START);
        this.notificationMngr.application(ma.getApplication(), EventType.CREATED);
        this.autonomicMngr.loadApplicationRules(ma.getApplication());
        this.logger.fine("Application " + ma.getApplication().getName() + " was successfully loaded and added.");
        return ma;
    }

    @Override
    public void updateApplication(ManagedApplication ma, String newDesc) throws IOException {
        this.messagingMngr.checkMessagingConfiguration();
        Application app = ma.getApplication();
        app.setDescription(newDesc);
        File targetDirectory = app.getDirectory();
        File descFile = new File(targetDirectory, "descriptor/application.properties");
        Utils.createDirectory((File)descFile.getParentFile());
        ApplicationDescriptor.save((File)descFile, (Application)app);
        this.notificationMngr.application(ma.getApplication(), EventType.CHANGED);
        this.logger.fine("The description of application " + ma.getApplication().getName() + " was successfully updated.");
    }

    @Override
    public void deleteApplication(ManagedApplication ma) throws UnauthorizedActionException, IOException {
        String applicationName = ma.getApplication().getName();
        for (Instance rootInstance : ma.getApplication().getRootInstances()) {
            if (rootInstance.getStatus() == Instance.InstanceStatus.NOT_DEPLOYED) continue;
            throw new UnauthorizedActionException(applicationName + " contains instances that are still deployed.");
        }
        try {
            this.messagingMngr.checkMessagingConfiguration();
            this.messagingMngr.getMessagingClient().listenToAgentMessages(ma.getApplication(), ListenerCommand.STOP);
            this.messagingMngr.getMessagingClient().deleteMessagingServerArtifacts(ma.getApplication());
        }
        catch (IOException e) {
            Utils.logException((Logger)this.logger, (Throwable)e);
        }
        this.randomMngr.releaseAllRandomValues(ma.getApplication());
        this.notificationMngr.application(ma.getApplication(), EventType.DELETED);
        Application app = ma.getApplication();
        this.targetsMngr.applicationWasDeleted((AbstractApplication)app);
        this.autonomicMngr.unloadApplicationRules(app);
        this.logger.info("Deleting the application called " + app.getName() + "...");
        this.nameToManagedApplication.remove(app.getName());
        app.removeAssociationWithTemplate();
        File targetDirectory = ConfigurationUtils.findApplicationDirectory(app.getName(), this.configurationMngr.getWorkingDirectory());
        Utils.deleteFilesRecursively((File[])new File[]{targetDirectory});
        this.logger.info("Application " + app.getName() + " was successfully deleted.");
    }

    @Override
    public void restoreApplications() {
        File configurationDirectory = this.configurationMngr.getWorkingDirectory();
        this.logger.info("Restoring applications from " + configurationDirectory + "...");
        this.nameToManagedApplication.clear();
        File templatesDirectory = new File(configurationDirectory, "applications");
        for (File dir : Utils.listDirectories((File)templatesDirectory)) {
            try {
                File descriptorFile = new File(dir, "descriptor/application.properties");
                ApplicationDescriptor desc = ApplicationDescriptor.load((File)descriptorFile);
                ApplicationTemplate tpl = this.applicationTemplateMngr.findTemplate(desc.getTemplateName(), desc.getTemplateVersion());
                if (tpl == null) {
                    throw new InvalidApplicationException(new RoboconfError(ErrorCode.PROJ_APPLICATION_TEMPLATE_NOT_FOUND));
                }
                if (this.nameToManagedApplication.containsKey(desc.getName())) {
                    throw new AlreadyExistingException(desc.getName());
                }
                Application app = new Application(desc.getName(), tpl).description(desc.getDescription());
                File targetDirectory = ConfigurationUtils.findApplicationDirectory(app.getName(), configurationDirectory);
                app.setDirectory(targetDirectory);
                ManagedApplication ma = new ManagedApplication(app);
                this.nameToManagedApplication.put(ma.getName(), ma);
                this.randomMngr.restoreRandomValuesCache(app);
                this.messagingMngr.getMessagingClient().listenToAgentMessages(ma.getApplication(), ListenerCommand.START);
                ConfigurationUtils.loadApplicationBindings(app);
                this.autonomicMngr.loadApplicationRules(app);
                RuntimeModelIo.InstancesLoadResult ilr = ConfigurationUtils.restoreInstances(ma);
                ApplicationMngrImpl.checkErrors(ilr.getLoadErrors(), this.logger);
                ma.getApplication().getRootInstances().clear();
                ma.getApplication().getRootInstances().addAll(ilr.getRootInstances());
            }
            catch (IOException | AlreadyExistingException | InvalidApplicationException e) {
                this.logger.warning("Application restoration failed for directory " + dir + " (" + e.getClass().getSimpleName() + ").");
                Utils.logException((Logger)this.logger, (Throwable)e);
            }
        }
        this.logger.info("Applications restoration from " + configurationDirectory + " has just completed.");
    }

    @Override
    public boolean isTemplateUsed(ApplicationTemplate tpl) {
        boolean result = false;
        for (ManagedApplication ma : this.nameToManagedApplication.values()) {
            if (!tpl.equals((Object)ma.getApplication().getTemplate())) continue;
            result = true;
            break;
        }
        return result;
    }

    static void checkErrors(Collection<RoboconfError> errors, Logger logger) throws InvalidApplicationException {
        if (RoboconfErrorHelpers.containsCriticalErrors(errors)) {
            throw new InvalidApplicationException(errors);
        }
        Collection warnings = RoboconfErrorHelpers.findWarnings(errors);
        for (String warningMsg : RoboconfErrorHelpers.formatErrors((Collection)warnings, null, (boolean)true).values()) {
            logger.warning(warningMsg);
        }
    }

    private ManagedApplication createNewApplication(String name, String description, ApplicationTemplate tpl, File configurationDirectory) throws AlreadyExistingException, IOException {
        this.logger.info("Creating application " + name + " from template " + tpl + "...");
        if (Utils.isEmptyOrWhitespaces((String)name)) {
            throw new IOException("An application name cannot be empty.");
        }
        Application app = new Application(name, tpl).description(description);
        if (!app.getName().matches("[a-zA-Z_](\\w|[-.() ])*")) {
            throw new IOException("Application names cannot contain invalid characters. Letters, digits, dots, underscores, brackets, spaces and the minus symbol are allowed.");
        }
        if (this.nameToManagedApplication.containsKey(name)) {
            throw new AlreadyExistingException(name);
        }
        File targetDirectory = ConfigurationUtils.findApplicationDirectory(app.getName(), configurationDirectory);
        Utils.createDirectory((File)targetDirectory);
        app.setDirectory(targetDirectory);
        File descFile = new File(targetDirectory, "descriptor/application.properties");
        Utils.createDirectory((File)descFile.getParentFile());
        ApplicationDescriptor.save((File)descFile, (Application)app);
        List tplDirectories = Utils.listDirectories((File)tpl.getDirectory());
        List<String> toSkip = Arrays.asList("descriptor", "graph", "instances");
        for (File dir : tplDirectories) {
            if (toSkip.contains(dir.getName().toLowerCase())) continue;
            File newDir = new File(targetDirectory, dir.getName());
            Utils.copyDirectory((File)dir, (File)newDir);
        }
        for (Instance rootInstance : app.getRootInstances()) {
            rootInstance.data.put("application.name", app.getName());
        }
        ConfigurationUtils.loadApplicationBindings(app);
        ManagedApplication ma = new ManagedApplication(app);
        this.nameToManagedApplication.put(app.getName(), ma);
        ConfigurationUtils.saveInstances(ma);
        this.logger.info("Application " + name + " was successfully created from the template " + tpl + ".");
        return ma;
    }

    @Override
    public void bindOrUnbindApplication(ManagedApplication ma, String externalExportPrefix, String applicationName, boolean bind) throws UnauthorizedActionException, IOException {
        Application app = this.findApplicationByName(applicationName);
        if (app == null) {
            throw new UnauthorizedActionException("Application " + applicationName + " does not exist.");
        }
        if (!externalExportPrefix.equals(app.getTemplate().getExternalExportsPrefix())) {
            throw new UnauthorizedActionException("Application " + applicationName + "'s template does not have " + externalExportPrefix + " as external exports prefix.");
        }
        boolean notify = true;
        if (bind) {
            ma.getApplication().bindWithApplication(externalExportPrefix, applicationName);
        } else {
            notify = ma.getApplication().unbindFromApplication(externalExportPrefix, applicationName);
        }
        if (notify) {
            ConfigurationUtils.saveApplicationBindings(ma.getApplication());
            this.logger.fine("External prefix " + externalExportPrefix + " is now bound to application " + applicationName + " in " + ma.getName() + ".");
            for (Instance inst : InstanceHelpers.findAllScopedInstances((AbstractApplication)ma.getApplication())) {
                MsgCmdChangeBinding msg = new MsgCmdChangeBinding(externalExportPrefix, (Set)ma.getApplication().getApplicationBindings().get(externalExportPrefix));
                this.messagingMngr.sendMessageSafely(ma, inst, (Message)msg);
            }
        }
    }

    @Override
    public void replaceApplicationBindings(ManagedApplication ma, String externalExportPrefix, Set<String> applicationNames) throws UnauthorizedActionException, IOException {
        for (String applicationName : applicationNames) {
            Application app = this.findApplicationByName(applicationName);
            if (app == null) {
                throw new UnauthorizedActionException("Application " + applicationName + " does not exist.");
            }
            if (externalExportPrefix.equals(app.getTemplate().getExternalExportsPrefix())) continue;
            throw new UnauthorizedActionException("Application " + applicationName + "'s template does not have " + externalExportPrefix + " as external exports prefix.");
        }
        boolean notify = ma.getApplication().replaceApplicationBindings(externalExportPrefix, applicationNames);
        if (notify) {
            ConfigurationUtils.saveApplicationBindings(ma.getApplication());
            for (String applicationName : applicationNames) {
                this.logger.fine("External prefix " + externalExportPrefix + " is now bound to application " + applicationName + " in " + ma.getName() + ".");
            }
            for (Instance inst : InstanceHelpers.findAllScopedInstances((AbstractApplication)ma.getApplication())) {
                MsgCmdChangeBinding msg = new MsgCmdChangeBinding(externalExportPrefix, (Set)ma.getApplication().getApplicationBindings().get(externalExportPrefix));
                this.messagingMngr.sendMessageSafely(ma, inst, (Message)msg);
            }
        }
    }
}

