/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.internal.api.impl;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import net.roboconf.core.autonomic.Rule;
import net.roboconf.core.autonomic.RuleParser;
import net.roboconf.core.errors.RoboconfErrorHelpers;
import net.roboconf.core.model.beans.Application;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.utils.Utils;
import net.roboconf.dm.internal.api.impl.beans.AutonomicApplicationContext;
import net.roboconf.dm.management.ManagedApplication;
import net.roboconf.dm.management.api.IAutonomicMngr;
import net.roboconf.dm.management.api.ICommandsMngr;
import net.roboconf.dm.management.api.IPreferencesMngr;
import net.roboconf.messaging.api.messages.from_agent_to_dm.MsgNotifAutonomic;

public class AutonomicMngrImpl
implements IAutonomicMngr {
    static final String AUTONOMIC_MARKER = "autonomic";
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    final Map<String, AutonomicApplicationContext> appNameToContext = new ConcurrentHashMap<String, AutonomicApplicationContext>();
    final AtomicInteger autonomicVmCount = new AtomicInteger(0);
    private final ICommandsMngr commandsMngr;
    private IPreferencesMngr preferencesMngr;

    public AutonomicMngrImpl(ICommandsMngr commandsMngr) {
        this.commandsMngr = commandsMngr;
    }

    public void setPreferencesMngr(IPreferencesMngr preferencesMngr) {
        this.preferencesMngr = preferencesMngr;
    }

    @Override
    public void loadApplicationRules(Application app) {
        AutonomicApplicationContext ctx = new AutonomicApplicationContext(app);
        AutonomicMngrImpl.loadRule(app, ctx, null);
        this.appNameToContext.put(app.getName(), ctx);
    }

    @Override
    public void refreshApplicationRules(Application app, String ruleFileName) {
        AutonomicApplicationContext ctx = this.appNameToContext.get(app.getName());
        if (ctx != null) {
            AutonomicMngrImpl.loadRule(app, ctx, ruleFileName);
        }
    }

    @Override
    public void unloadApplicationRules(Application app) {
        this.appNameToContext.remove(app.getName());
    }

    @Override
    public void notifyVmWasDeletedByHand(Instance rootInstance) {
        if (rootInstance.data.remove(AUTONOMIC_MARKER) != null) {
            this.autonomicVmCount.decrementAndGet();
        }
    }

    @Override
    public int getAutonomicInstancesCount() {
        return this.autonomicVmCount.get();
    }

    @Override
    public void handleEvent(ManagedApplication ma, MsgNotifAutonomic event) {
        try {
            this.logger.fine("Autonomic event '" + event.getEventName() + "' is about to be recorded.");
            AutonomicApplicationContext ctx = this.appNameToContext.get(ma.getName());
            if (ctx == null) {
                this.logger.fine("No autonomic context was found for application " + ma.getApplication() + ".");
            } else {
                ctx.registerEvent(event.getEventName());
                List<Rule> rulesToExecute = ctx.findRulesToExecute();
                if (rulesToExecute.isEmpty()) {
                    this.logger.fine("No rule was found after the event '" + event.getEventName() + "' occurred.");
                } else {
                    String strictMaxVmAS = this.preferencesMngr.get("autonomic.strict.maximum.vm.number", "true");
                    boolean strictMaxVm = Boolean.parseBoolean(strictMaxVmAS);
                    String maxVmCountAS = this.preferencesMngr.get("autonomic.maximum.vm.number", "2147483647");
                    int maxVmCount = Integer.parseInt(maxVmCountAS);
                    if (maxVmCount < 0) {
                        maxVmCount = Integer.MAX_VALUE;
                    }
                    if (maxVmCount <= this.autonomicVmCount.get()) {
                        strictMaxVm = true;
                    }
                    ICommandsMngr.CommandExecutionContext execCtx = new ICommandsMngr.CommandExecutionContext(this.autonomicVmCount, ctx.getVmCount(), maxVmCount, strictMaxVm, AUTONOMIC_MARKER, "");
                    for (Rule rule : rulesToExecute) {
                        this.logger.fine("Applying rule '" + rule.getRuleName() + "' for event '" + event.getEventName() + "'.");
                        ctx.recordPreExecution(rule.getRuleName());
                        for (String commandName : rule.getCommandsToInvoke()) {
                            this.commandsMngr.execute(ma.getApplication(), commandName, execCtx, 3, rule.getRuleName());
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.warning("An autonomic event could not be handled. " + e.getMessage());
            Utils.logException((Logger)this.logger, (Throwable)e);
        }
    }

    static void loadRule(Application app, AutonomicApplicationContext ctx, String ruleFileName) {
        Logger logger = Logger.getLogger(AutonomicMngrImpl.class.getName());
        File autonomicRulesDirectory = new File(app.getDirectory(), "rules.autonomic");
        if (autonomicRulesDirectory.exists()) {
            if (ruleFileName != null) {
                File f;
                String fileName = ruleFileName;
                if (!fileName.endsWith(".drl")) {
                    fileName = fileName + ".drl";
                }
                if ((f = new File(autonomicRulesDirectory, fileName)).exists()) {
                    AutonomicMngrImpl.readRule(f, ctx, logger);
                }
            } else {
                for (File f : Utils.listAllFiles((File)autonomicRulesDirectory)) {
                    if (!f.getName().endsWith(".drl")) {
                        logger.warning("Invalid file extension for rule " + f.getName() + ", it is skipped.");
                        continue;
                    }
                    AutonomicMngrImpl.readRule(f, ctx, logger);
                }
            }
        }
    }

    private static void readRule(File f, AutonomicApplicationContext ctx, Logger logger) {
        RuleParser parser = new RuleParser(f);
        if (RoboconfErrorHelpers.containsCriticalErrors((Collection)parser.getParsingErrors())) {
            logger.warning("Critical errors were found for rule " + parser.getRule().getRuleName());
        } else {
            Rule rule = parser.getRule();
            ctx.ruleNameToRule.put(rule.getRuleName(), rule);
        }
    }
}

