/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.internal.api.impl;

import java.io.File;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import javax.sql.DataSource;
import net.roboconf.core.commands.CommandsParser;
import net.roboconf.core.model.ParsingError;
import net.roboconf.core.model.beans.AbstractApplication;
import net.roboconf.core.model.beans.Application;
import net.roboconf.core.model.runtime.CommandHistoryItem;
import net.roboconf.core.utils.Utils;
import net.roboconf.dm.internal.commands.CommandsExecutor;
import net.roboconf.dm.management.Manager;
import net.roboconf.dm.management.api.ICommandsMngr;
import net.roboconf.dm.management.exceptions.CommandException;

public class CommandsMngrImpl
implements ICommandsMngr {
    static final int DEFAULT_ITEMS_PER_PAGE = 20;
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final Manager manager;

    public CommandsMngrImpl(Manager manager) {
        this.manager = manager;
    }

    @Override
    public void createOrUpdateCommand(Application app, String commandName, String commandText) throws IOException {
        File cmdFile = this.findCommandFile(app, commandName);
        Utils.createDirectory((File)cmdFile.getParentFile());
        Utils.writeStringInto((String)commandText, (File)cmdFile);
    }

    @Override
    public void deleteCommand(Application app, String commandName) throws IOException {
        File cmdFile = this.findCommandFile(app, commandName);
        Utils.deleteFilesRecursively((File[])new File[]{cmdFile});
    }

    @Override
    public List<String> listCommands(Application app) {
        ArrayList<String> result = new ArrayList<String>();
        File cmdDir = new File(app.getDirectory(), "commands");
        if (cmdDir.isDirectory()) {
            for (File f : Utils.listAllFiles((File)cmdDir)) {
                if (!f.getName().endsWith(".commands")) continue;
                String cmdName = f.getName().replace(".commands", "");
                result.add(cmdName);
            }
        }
        return result;
    }

    @Override
    public String getCommandInstructions(Application app, String commandName) throws IOException {
        String result;
        File cmdFile = this.findCommandFile(app, commandName);
        result = cmdFile.exists() ? (result = Utils.readFileContent((File)cmdFile)) : "";
        return result;
    }

    @Override
    public List<ParsingError> validate(Application app, String commandText) {
        CommandsParser parser = new CommandsParser((AbstractApplication)app, commandText);
        return parser.getParsingErrors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getHistoryNumberOfPages(int itemsPerPage, String applicationName) {
        int result = 0;
        DataSource dataSource = this.manager.getDataSource();
        if (itemsPerPage < 1) {
            itemsPerPage = 20;
        }
        if (dataSource != null) {
            Connection conn = null;
            PreparedStatement ps = null;
            ResultSet sqlRes = null;
            try {
                conn = dataSource.getConnection();
                StringBuilder sb = new StringBuilder();
                sb.append("SELECT count( * ) FROM commands_history");
                if (!Utils.isEmptyOrWhitespaces((String)applicationName)) {
                    sb.append(" WHERE application = ?");
                }
                ps = conn.prepareStatement(sb.toString());
                if (!Utils.isEmptyOrWhitespaces((String)applicationName)) {
                    ps.setString(1, applicationName);
                }
                if ((sqlRes = ps.executeQuery()).next()) {
                    int count = sqlRes.getInt(1);
                    result = count == 0 ? 0 : count / itemsPerPage + 1;
                }
                this.closeResultSet(sqlRes);
                this.closeStatement(ps);
                this.closeConnection(conn);
            }
            catch (SQLException e) {
                this.logger.severe("An error occurred while counting pages in commands history.");
                Utils.logException((Logger)this.logger, (Throwable)e);
            }
            finally {
                this.closeResultSet(sqlRes);
                this.closeStatement(ps);
                this.closeConnection(conn);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CommandHistoryItem> getHistory(int start, int maxEntry, String sortCriteria, String sortingOrder, String applicationName) {
        ArrayList<CommandHistoryItem> result = new ArrayList<CommandHistoryItem>();
        DataSource dataSource = this.manager.getDataSource();
        if (start < 0) {
            start = 0;
        }
        if (maxEntry < 1) {
            maxEntry = 20;
        }
        if (!Arrays.asList("start", "application", "command", "origin", "result").contains(sortCriteria)) {
            sortCriteria = "start";
        }
        if (!Arrays.asList("asc", "desc").contains(sortingOrder)) {
            sortingOrder = "asc";
        }
        if (dataSource != null) {
            Connection conn = null;
            PreparedStatement ps = null;
            ResultSet sqlRes = null;
            try {
                conn = dataSource.getConnection();
                StringBuilder sb = new StringBuilder();
                sb.append("SELECT * FROM commands_history ");
                if (!Utils.isEmptyOrWhitespaces((String)applicationName)) {
                    sb.append(" WHERE application = ?");
                }
                sb.append(" ORDER BY ");
                sb.append(sortCriteria);
                sb.append(" ");
                sb.append(sortingOrder);
                sb.append(" LIMIT ");
                sb.append(maxEntry);
                sb.append(" OFFSET ");
                sb.append(start);
                ps = conn.prepareStatement(sb.toString());
                if (!Utils.isEmptyOrWhitespaces((String)applicationName)) {
                    ps.setString(1, applicationName);
                }
                sqlRes = ps.executeQuery();
                while (sqlRes.next()) {
                    String appName = sqlRes.getString("application");
                    String commandName = sqlRes.getString("command");
                    int origin = sqlRes.getInt("origin");
                    String originDetails = sqlRes.getString("details");
                    int executionResult = sqlRes.getInt("result");
                    long executionStart = sqlRes.getLong("start");
                    long duration = sqlRes.getLong("duration");
                    result.add(new CommandHistoryItem(appName, commandName, origin, originDetails, executionResult, executionStart, duration));
                }
                this.closeResultSet(sqlRes);
                this.closeStatement(ps);
                this.closeConnection(conn);
            }
            catch (SQLException e) {
                this.logger.severe("An error occurred while retrieving commands history from database.");
                Utils.logException((Logger)this.logger, (Throwable)e);
            }
            finally {
                this.closeResultSet(sqlRes);
                this.closeStatement(ps);
                this.closeConnection(conn);
            }
        }
        return result;
    }

    @Override
    public void execute(Application app, String commandName, int origin, String originDetails) throws CommandException, NoSuchFileException {
        this.execute(app, commandName, null, origin, originDetails);
    }

    @Override
    public void execute(Application app, String commandName, ICommandsMngr.CommandExecutionContext executionContext, int origin, String originDetails) throws CommandException, NoSuchFileException {
        File cmdFile = this.findCommandFile(app, commandName);
        if (!cmdFile.isFile()) {
            throw new NoSuchFileException(cmdFile.getAbsolutePath());
        }
        int result = 1;
        long startInMilliSeconds = System.currentTimeMillis();
        long startInNanoSeconds = System.nanoTime();
        try {
            CommandsExecutor executor = new CommandsExecutor(this.manager, app, cmdFile, executionContext);
            executor.execute();
            if (executor.wereInstructionSkipped()) {
                result = 2;
            }
        }
        catch (CommandException e) {
            result = 3;
            throw e;
        }
        finally {
            this.recordInHistory(startInMilliSeconds, startInNanoSeconds, result, app.getName(), commandName, origin, originDetails);
        }
    }

    void closeConnection(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            Utils.logException((Logger)this.logger, (Throwable)e);
        }
    }

    void closeStatement(PreparedStatement ps) {
        try {
            if (ps != null) {
                ps.close();
            }
        }
        catch (SQLException e) {
            Utils.logException((Logger)this.logger, (Throwable)e);
        }
    }

    void closeStatement(Statement st) {
        try {
            if (st != null) {
                st.close();
            }
        }
        catch (SQLException e) {
            Utils.logException((Logger)this.logger, (Throwable)e);
        }
    }

    void closeResultSet(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException e) {
            Utils.logException((Logger)this.logger, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordInHistory(long startInMilliSeconds, long startInNanoSeconds, int result, String applicationName, String commandName, int origin, String originDetails) {
        long duration = System.nanoTime() - startInNanoSeconds;
        DataSource dataSource = this.manager.getDataSource();
        if (dataSource != null) {
            boolean failed = false;
            Connection conn = null;
            try {
                conn = dataSource.getConnection();
                this.recordEntry(conn, startInMilliSeconds, duration, result, applicationName, commandName, origin, originDetails);
            }
            catch (SQLException e) {
                failed = true;
            }
            try {
                if (failed) {
                    this.createTable(conn);
                    this.recordEntry(conn, startInMilliSeconds, duration, result, applicationName, commandName, origin, originDetails);
                }
            }
            catch (SQLException e) {
                this.logger.severe("An error occurred while storing the result of a command execution in database.");
                Utils.logException((Logger)this.logger, (Throwable)e);
            }
            finally {
                this.closeConnection(conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordEntry(Connection conn, long start, long duration, int result, String applicationName, String commandName, int origin, String originDetails) throws SQLException {
        String req = "INSERT INTO commands_history( application, command, start, duration, result, origin, details ) values( ?, ?, ?, ?, ?, ?, ? )";
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(req);
            ps.setString(1, applicationName);
            ps.setString(2, commandName);
            ps.setLong(3, start);
            ps.setLong(4, duration);
            ps.setInt(5, result);
            ps.setInt(6, origin);
            ps.setString(7, originDetails);
            ps.execute();
        }
        finally {
            this.closeStatement(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTable(Connection conn) throws SQLException {
        StringBuilder sb = new StringBuilder("CREATE TABLE IF NOT EXISTS commands_history (");
        sb.append("id INT NOT NULL AUTO_INCREMENT,");
        sb.append("application VARCHAR(255),");
        sb.append("command VARCHAR(255),");
        sb.append("start BIGINT,");
        sb.append("duration BIGINT,");
        sb.append("result SMALLINT,");
        sb.append("origin SMALLINT,");
        sb.append("details VARCHAR(255),");
        sb.append("PRIMARY KEY( id ))");
        Statement st = null;
        try {
            st = conn.createStatement();
            st.execute(sb.toString());
        }
        finally {
            this.closeStatement(st);
        }
    }

    private File findCommandFile(Application app, String commandName) {
        String name = commandName;
        if (!name.endsWith(".commands")) {
            name = name + ".commands";
        }
        File cmdDir = new File(app.getDirectory(), "commands");
        return new File(cmdDir, name);
    }
}

