/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.internal.api.impl;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import net.roboconf.core.utils.IconUtils;
import net.roboconf.core.utils.Utils;
import net.roboconf.dm.internal.utils.ConfigurationUtils;
import net.roboconf.dm.management.api.IConfigurationMngr;

public class ConfigurationMngrImpl
implements IConfigurationMngr {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private File workingDirectory;

    public ConfigurationMngrImpl() {
        String karafData = System.getProperty("karaf.data");
        this.workingDirectory = Utils.isEmptyOrWhitespaces((String)karafData) ? new File(System.getProperty("java.io.tmpdir"), "roboconf-dm") : new File(karafData, "roboconf");
        try {
            Utils.createDirectory((File)this.workingDirectory);
        }
        catch (IOException e) {
            this.logger.severe("The DM's configuration directory could not be found and/or created.");
            Utils.logException((Logger)this.logger, (Throwable)e);
        }
    }

    @Override
    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Override
    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    @Override
    public File findIconFromPath(String urlPath) {
        Map.Entry entry = IconUtils.decodeIconUrl((String)urlPath);
        return ConfigurationUtils.findIcon((String)entry.getKey(), (String)entry.getValue(), this.workingDirectory);
    }
}

