/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.internal.api.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import net.roboconf.core.model.beans.Application;
import net.roboconf.core.model.beans.ApplicationTemplate;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.runtime.EventType;
import net.roboconf.dm.management.api.INotificationMngr;
import net.roboconf.dm.management.events.IDmListener;

public class NotificationMngrImpl
implements INotificationMngr {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final List<IDmListener> dmListeners = new ArrayList<IDmListener>();
    private final AtomicBoolean enableNotifications = new AtomicBoolean(false);

    @Override
    public String getId() {
        return "main";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enableNotifications() {
        this.logger.info("Notifications are being enabled for DM listeners...");
        this.enableNotifications.set(true);
        List<IDmListener> list = this.dmListeners;
        synchronized (list) {
            for (IDmListener listener : this.dmListeners) {
                listener.enableNotifications();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disableNotifications() {
        this.logger.info("Notifications are being disabled for DM listeners...");
        this.enableNotifications.set(false);
        List<IDmListener> list = this.dmListeners;
        synchronized (list) {
            for (IDmListener listener : this.dmListeners) {
                listener.disableNotifications();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IDmListener listener) {
        if (listener == null) {
            this.logger.info("An invalid DM listener failed to be added.");
        } else {
            List<IDmListener> list = this.dmListeners;
            synchronized (list) {
                this.dmListeners.add(listener);
            }
            if (this.enableNotifications.get()) {
                listener.enableNotifications();
            }
            this.logger.info("The listener '" + listener.getId() + "' is now available in Roboconf's DM.");
        }
        this.listListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IDmListener listener) {
        if (listener != null) {
            List<IDmListener> list = this.dmListeners;
            synchronized (list) {
                this.dmListeners.remove(listener);
            }
            this.logger.info("The listener '" + listener.getId() + "' is not available anymore in Roboconf's DM.");
        } else {
            this.logger.info("An invalid DM listener was removed.");
        }
        this.listListeners();
    }

    public List<IDmListener> getDmListeners() {
        return Collections.unmodifiableList(this.dmListeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void application(Application application, EventType eventType) {
        List<IDmListener> list = this.dmListeners;
        synchronized (list) {
            for (IDmListener listener : this.dmListeners) {
                listener.application(application, eventType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applicationTemplate(ApplicationTemplate tpl, EventType eventType) {
        List<IDmListener> list = this.dmListeners;
        synchronized (list) {
            for (IDmListener listener : this.dmListeners) {
                listener.applicationTemplate(tpl, eventType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void instance(Instance instance, Application application, EventType eventType) {
        List<IDmListener> list = this.dmListeners;
        synchronized (list) {
            for (IDmListener listener : this.dmListeners) {
                listener.instance(instance, application, eventType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void raw(String message, Object ... data) {
        List<IDmListener> list = this.dmListeners;
        synchronized (list) {
            for (IDmListener listener : this.dmListeners) {
                listener.raw(message, data);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listListeners() {
        ArrayList<IDmListener> dmListenersCopy = new ArrayList<IDmListener>();
        List<IDmListener> list = this.dmListeners;
        synchronized (list) {
            dmListenersCopy.addAll(this.dmListeners);
        }
        if (dmListenersCopy.isEmpty()) {
            this.logger.info("No listener was found in Roboconf's DM.");
        } else {
            StringBuilder sb = new StringBuilder("Available listeners in Roboconf's DM: ");
            Iterator it = dmListenersCopy.iterator();
            while (it.hasNext()) {
                sb.append(((IDmListener)it.next()).getId());
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(".");
            this.logger.info(sb.toString());
        }
    }
}

