/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.internal.api.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import net.roboconf.core.model.beans.AbstractApplication;
import net.roboconf.core.model.beans.Application;
import net.roboconf.core.model.beans.ExportedVariable;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.InstanceHelpers;
import net.roboconf.core.utils.Utils;
import net.roboconf.dm.internal.api.IRandomMngr;
import net.roboconf.dm.internal.api.impl.beans.InstanceContext;
import net.roboconf.dm.internal.utils.ConfigurationUtils;
import net.roboconf.dm.management.api.IPreferencesMngr;

public class RandomMngrImpl
implements IRandomMngr {
    final Map<InstanceContext, List<Integer>> agentToRandomPorts = new HashMap<InstanceContext, List<Integer>>();
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private IPreferencesMngr preferencesMngr;
    public static final int PORT_MIN = 10000;
    public static final int PORT_MAX = 65500;

    public void setPreferencesMngr(IPreferencesMngr preferencesMngr) {
        this.preferencesMngr = preferencesMngr;
    }

    @Override
    public synchronized void generateRandomValues(Application application, Instance instance) {
        for (ExportedVariable var : instance.getComponent().exportedVariables.values()) {
            if (!var.isRandom() || var.getRandomKind() != ExportedVariable.RandomKind.PORT || this.acknowledgePort(application, instance, var.getName())) continue;
            this.generateRandomPort(application, instance, var.getName());
        }
        ConfigurationUtils.saveInstances(application);
    }

    @Override
    public void generateAllRandomValues(Application application) {
        for (Instance instance : InstanceHelpers.getAllInstances((AbstractApplication)application)) {
            this.generateRandomValues(application, instance);
        }
    }

    @Override
    public synchronized void releaseRandomValues(Application application, Instance instance) {
        ArrayList<Integer> portsToRelease = new ArrayList<Integer>();
        for (ExportedVariable var : instance.getComponent().exportedVariables.values()) {
            String value;
            if (!var.isRandom() || var.getRandomKind() != ExportedVariable.RandomKind.PORT || (value = (String)instance.overriddenExports.get(var.getName())) == null) continue;
            portsToRelease.add(Integer.parseInt(value));
        }
        InstanceContext ctx = this.findAgentContext(application, instance);
        List<Integer> ports = this.agentToRandomPorts.get(ctx);
        if (ports != null) {
            ports.removeAll(portsToRelease);
            if (ports.isEmpty()) {
                this.agentToRandomPorts.remove(ctx);
            }
        }
    }

    @Override
    public void releaseAllRandomValues(Application application) {
        ArrayList<InstanceContext> toRemove = new ArrayList<InstanceContext>();
        for (InstanceContext ctx : this.agentToRandomPorts.keySet()) {
            if (ctx.getQualifier() != null || !Objects.equals(application.getName(), ctx.getName())) continue;
            toRemove.add(ctx);
        }
        for (InstanceContext ctx : toRemove) {
            this.agentToRandomPorts.remove(ctx);
        }
    }

    @Override
    public void restoreRandomValuesCache(Application application) {
        for (Instance instance : InstanceHelpers.getAllInstances((AbstractApplication)application)) {
            ArrayList<ExportedVariable> variablesToRegenerate = new ArrayList<ExportedVariable>();
            for (ExportedVariable var : instance.getComponent().exportedVariables.values()) {
                String value;
                if (!var.isRandom() || var.getRandomKind() != ExportedVariable.RandomKind.PORT || (value = (String)instance.overriddenExports.get(var.getName())) == null || this.acknowledgePort(application, instance, var.getName())) continue;
                variablesToRegenerate.add(var);
            }
            for (ExportedVariable var : variablesToRegenerate) {
                this.logger.warning("Generating a new random port for " + var.getName() + " in instance " + instance + " of " + application);
                this.generateRandomPort(application, instance, var.getName());
            }
            if (variablesToRegenerate.isEmpty()) continue;
            ConfigurationUtils.saveInstances(application);
        }
    }

    private void generateRandomPort(Application application, Instance instance, String exportedVariableName) {
        ArrayList<Integer> forbiddenPorts = new ArrayList<Integer>();
        String preferences = this.preferencesMngr.get("forbidden.random.ports", "");
        for (String s : Utils.splitNicely((String)preferences, (String)",")) {
            if (Utils.isEmptyOrWhitespaces((String)s)) continue;
            try {
                forbiddenPorts.add(Integer.parseInt(s));
            }
            catch (NumberFormatException e) {
                this.logger.severe("An invalid port was found in the preferences: " + s);
            }
        }
        InstanceContext ctx = this.findAgentContext(application, instance);
        List<Integer> portsUsedByAgent = this.agentToRandomPorts.get(ctx);
        if (portsUsedByAgent != null) {
            forbiddenPorts.addAll(portsUsedByAgent);
        }
        Integer randomPort = -1;
        for (int i = 10000; i < 65500 && randomPort == -1; ++i) {
            if (forbiddenPorts.contains(i)) continue;
            randomPort = i;
        }
        this.logger.fine("Associating a random port to " + exportedVariableName + " in instance " + instance + " of " + application);
        InstanceContext newCtx = this.findAgentContext(application, instance);
        List<Integer> associatedPorts = this.agentToRandomPorts.get(newCtx);
        if (associatedPorts == null) {
            associatedPorts = new ArrayList<Integer>();
            this.agentToRandomPorts.put(newCtx, associatedPorts);
        }
        associatedPorts.add(randomPort);
        instance.overriddenExports.put(exportedVariableName, String.valueOf(randomPort));
    }

    private boolean acknowledgePort(Application application, Instance instance, String exportedVariableName) {
        boolean acknowledged = false;
        String value = (String)instance.overriddenExports.get(exportedVariableName);
        if (value != null) {
            this.logger.fine("Acknowledging random port value for " + exportedVariableName + " in instance " + instance + " of " + application);
            Integer portValue = Integer.parseInt(value);
            InstanceContext ctx = this.findAgentContext(application, instance);
            List<Integer> associatedPorts = this.agentToRandomPorts.get(ctx);
            if (associatedPorts == null) {
                associatedPorts = new ArrayList<Integer>();
                this.agentToRandomPorts.put(ctx, associatedPorts);
            }
            if (associatedPorts.contains(portValue)) {
                this.logger.warning("Random port already used! Failed to acknowledge/restore " + exportedVariableName + " in instance " + instance + " of " + application);
                acknowledged = false;
            } else {
                associatedPorts.add(portValue);
                acknowledged = true;
            }
        }
        return acknowledged;
    }

    private InstanceContext findAgentContext(Application application, Instance instance) {
        Instance scopedInstance = InstanceHelpers.findScopedInstance((Instance)instance);
        return new InstanceContext((AbstractApplication)application, scopedInstance);
    }
}

