/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.internal.api.impl.beans;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import net.roboconf.core.autonomic.Rule;
import net.roboconf.core.model.beans.Application;

public class AutonomicApplicationContext {
    public final Map<String, Rule> ruleNameToRule = new ConcurrentHashMap<String, Rule>();
    final Map<String, Long> eventNameToLastRecordTime = new HashMap<String, Long>();
    final Map<String, Long> ruleNameToLastExecution = new HashMap<String, Long>();
    final Map<String, String> ruleNameToLastTrigger = new HashMap<String, String>();
    final AtomicInteger vmCount = new AtomicInteger(0);
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final Application app;

    public AutonomicApplicationContext(Application app) {
        this.app = app;
    }

    public String toString() {
        return this.app.toString();
    }

    public AtomicInteger getVmCount() {
        return this.vmCount;
    }

    public void registerEvent(String eventName) {
        this.eventNameToLastRecordTime.put(eventName, System.nanoTime());
    }

    public void recordPreExecution(String ruleName) {
        this.ruleNameToLastExecution.put(ruleName, System.nanoTime());
    }

    public List<Rule> findRulesToExecute() {
        this.logger.fine("Looking for rules to execute after an event was recorded for application " + this.app);
        ArrayList<Rule> result = new ArrayList<Rule>();
        long now = System.nanoTime();
        for (Rule rule : this.ruleNameToRule.values()) {
            long validPeriodStart = now - TimeUnit.SECONDS.toNanos(rule.getDelayBetweenSucceedingInvocations());
            Long lastExecutionTime = this.ruleNameToLastExecution.get(rule.getRuleName());
            if (lastExecutionTime != null && lastExecutionTime - validPeriodStart > 0L) {
                this.logger.finer("Ignoring the rule " + rule.getRuleName() + " since the execution delay has not yet expired.");
                continue;
            }
            Long lastRecord = this.eventNameToLastRecordTime.get(rule.getEventName());
            if (lastRecord == null) continue;
            StringBuilder sbTrigger = new StringBuilder();
            sbTrigger.append(rule.getEventName());
            sbTrigger.append(lastRecord);
            String lastTrigger = this.ruleNameToLastTrigger.get(rule.getRuleName());
            if (Objects.equals(lastTrigger, sbTrigger.toString())) {
                this.logger.finer("Ignoring the rule " + rule.getRuleName() + " since no new event occurred since its last execution.");
                continue;
            }
            validPeriodStart = now - TimeUnit.SECONDS.toNanos(rule.getTimingWindow());
            if (rule.getTimingWindow() != -1 && lastRecord - validPeriodStart < 0L) {
                this.logger.finer("Ignoring the rule " + rule.getRuleName() + " since no new event occurred since its last execution.");
                continue;
            }
            this.logger.finer("Rule " + rule.getRuleName() + " was found following the occurrence of the " + rule.getEventName() + " event.");
            this.ruleNameToLastTrigger.put(rule.getRuleName(), sbTrigger.toString());
            result.add(rule);
        }
        return result;
    }
}

