/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.internal.commands;

import net.roboconf.core.commands.AbstractCommandInstruction;
import net.roboconf.core.commands.CreateInstanceCommandInstruction;
import net.roboconf.core.model.beans.Component;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.dm.internal.commands.AbstractCommandExecution;
import net.roboconf.dm.management.ManagedApplication;
import net.roboconf.dm.management.Manager;
import net.roboconf.dm.management.api.ICommandsMngr;
import net.roboconf.dm.management.exceptions.CommandException;

class CreateInstanceCommandExecution
extends AbstractCommandExecution {
    private final CreateInstanceCommandInstruction instr;
    private final Manager manager;

    public CreateInstanceCommandExecution(CreateInstanceCommandInstruction instr, Manager manager) {
        this.instr = instr;
        this.manager = manager;
    }

    @Override
    public void execute() throws CommandException {
        Instance parentInstance = this.resolveInstance((AbstractCommandInstruction)this.instr, this.instr.getParentInstancePath(), true);
        ManagedApplication ma = this.resolveManagedApplication(this.manager, (AbstractCommandInstruction)this.instr);
        CreateInstanceCommandExecution.verify(this.executionContext, this.instr.getComponent());
        try {
            Instance instance = new Instance(this.instr.getInstanceName()).component(this.instr.getComponent());
            this.manager.instancesMngr().addInstance(ma, parentInstance, instance);
            CreateInstanceCommandExecution.update(this.executionContext, instance);
        }
        catch (Exception e) {
            throw new CommandException(e);
        }
    }

    public static void verify(ICommandsMngr.CommandExecutionContext executionContext, Component component) throws CommandException {
        if (executionContext != null && "target".equalsIgnoreCase(component.getInstallerName()) && executionContext.getMaxVm() > 0 && executionContext.getMaxVm() <= executionContext.getGlobalVmNumber().get() && executionContext.isStrictMaxVm()) {
            throw new CommandException("The maximum number of VM created by the autonomic has been reached.");
        }
    }

    public static void update(ICommandsMngr.CommandExecutionContext executionContext, Instance createdInstance) {
        if (executionContext != null) {
            createdInstance.data.put(executionContext.getNewVmMarkerKey(), executionContext.getNewVmMarkerValue());
            executionContext.getGlobalVmNumber().incrementAndGet();
            executionContext.getAppVmNumber().incrementAndGet();
        }
    }
}

