/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.internal.commands;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import net.roboconf.core.commands.EmailCommandInstruction;
import net.roboconf.core.utils.Utils;
import net.roboconf.dm.internal.commands.AbstractCommandExecution;
import net.roboconf.dm.management.Manager;
import net.roboconf.dm.management.exceptions.CommandException;

class EmailCommandExecution
extends AbstractCommandExecution {
    private final EmailCommandInstruction instr;
    private final Manager manager;

    public EmailCommandExecution(EmailCommandInstruction instr, Manager manager) {
        this.instr = instr;
        this.manager = manager;
    }

    @Override
    public void execute() throws CommandException {
        try {
            Message message = this.getMessageToSend();
            Transport.send((Message)message);
        }
        catch (Exception e) {
            throw new CommandException(e);
        }
    }

    Message getMessageToSend() throws MessagingException {
        Properties mailProperties = this.manager.preferencesMngr().getJavaxMailProperties();
        String subject = "Roboconf event";
        String data = this.instr.getMsg();
        String emailSubjectPattern = "Subject: ([^\n]+)(\n|$)(.*)";
        Matcher m = Pattern.compile("Subject: ([^\n]+)(\n|$)(.*)").matcher(this.instr.getMsg());
        if (m.find()) {
            subject = m.group(1);
            data = m.group(3).trim();
        }
        String username = mailProperties.getProperty("mail.user", "");
        String password = mailProperties.getProperty("mail.password", "");
        Session session = null;
        session = "true".equalsIgnoreCase(mailProperties.getProperty("mail.smtp.auth")) ? Session.getInstance((Properties)mailProperties, (Authenticator)new MailAuthenticator(username, password)) : Session.getDefaultInstance((Properties)mailProperties);
        MimeMessage message = new MimeMessage(session);
        message.setFrom((Address)new InternetAddress(mailProperties.getProperty("mail.from")));
        LinkedHashSet tos = new LinkedHashSet();
        tos.addAll(this.instr.getTos());
        String defaultRecipients = this.manager.preferencesMngr().get("email.default.recipients", "");
        List recipients = Utils.splitNicely((String)defaultRecipients, (String)",");
        tos.addAll(recipients);
        for (String to : tos) {
            message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(to));
        }
        message.setSubject(subject);
        message.setText(data.trim());
        return message;
    }

    static class MailAuthenticator
    extends Authenticator {
        String username = "";
        String password = "";

        public MailAuthenticator(String username, String password) {
            this.username = username;
            this.password = password;
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.username, this.password);
        }
    }
}

