/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.internal.environment.messaging;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.logging.Logger;
import net.roboconf.core.model.beans.AbstractApplication;
import net.roboconf.core.model.beans.Application;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.ImportHelpers;
import net.roboconf.core.model.helpers.InstanceHelpers;
import net.roboconf.core.utils.DockerAndScriptUtils;
import net.roboconf.core.utils.Utils;
import net.roboconf.dm.internal.utils.DmUtils;
import net.roboconf.dm.management.ManagedApplication;
import net.roboconf.dm.management.Manager;
import net.roboconf.messaging.api.AbstractMessageProcessor;
import net.roboconf.messaging.api.business.IDmClient;
import net.roboconf.messaging.api.messages.Message;
import net.roboconf.messaging.api.messages.from_agent_to_dm.MsgNotifAutonomic;
import net.roboconf.messaging.api.messages.from_agent_to_dm.MsgNotifHeartbeat;
import net.roboconf.messaging.api.messages.from_agent_to_dm.MsgNotifInstanceChanged;
import net.roboconf.messaging.api.messages.from_agent_to_dm.MsgNotifInstanceRemoved;
import net.roboconf.messaging.api.messages.from_agent_to_dm.MsgNotifLogs;
import net.roboconf.messaging.api.messages.from_agent_to_dm.MsgNotifMachineDown;
import net.roboconf.messaging.api.messages.from_dm_to_agent.MsgCmdSetScopedInstance;
import net.roboconf.messaging.api.messages.from_dm_to_dm.MsgEcho;

public class DmMessageProcessor
extends AbstractMessageProcessor<IDmClient> {
    private final Logger logger = Logger.getLogger(DmMessageProcessor.class.getName());
    private final Manager manager;
    String tmpDir = System.getProperty("java.io.tmpdir");

    public DmMessageProcessor(Manager manager) {
        super("Roboconf DM - Message Processor");
        this.manager = manager;
    }

    public void processMessage(Message message) {
        if (message instanceof MsgNotifMachineDown) {
            this.processMsgNotifMachineDown((MsgNotifMachineDown)message);
        } else if (message instanceof MsgNotifInstanceChanged) {
            this.processMsgNotifInstanceChanged((MsgNotifInstanceChanged)message);
        } else if (message instanceof MsgNotifInstanceRemoved) {
            this.processMsgNotifInstanceRemoved((MsgNotifInstanceRemoved)message);
        } else if (message instanceof MsgNotifHeartbeat) {
            this.processMsgNotifHeartbeat((MsgNotifHeartbeat)message);
        } else if (message instanceof MsgNotifAutonomic) {
            this.processMsgMonitoringEvent((MsgNotifAutonomic)message);
        } else if (message instanceof MsgEcho) {
            this.manager.debugMngr().notifyMsgEchoReceived((MsgEcho)message);
        } else if (message instanceof MsgNotifLogs) {
            this.processMsgNotifLogs((MsgNotifLogs)message);
        } else {
            this.logger.warning("The DM got an undetermined message to process: " + message.getClass().getName());
        }
    }

    private void processMsgNotifLogs(MsgNotifLogs message) {
        StringBuilder path = new StringBuilder();
        path.append("roboconf-logs/");
        path.append(message.getApplicationName());
        path.append("/");
        path.append(DockerAndScriptUtils.cleanInstancePath((String)message.getScopedInstancePath()));
        File dumpDir = new File(this.tmpDir, path.toString());
        try {
            Utils.createDirectory((File)dumpDir);
            for (Map.Entry entry : message.getLogFiles().entrySet()) {
                ByteArrayInputStream in = new ByteArrayInputStream((byte[])entry.getValue());
                Utils.copyStream((InputStream)in, (File)new File(dumpDir, (String)entry.getKey()));
            }
        }
        catch (IOException e) {
            StringBuilder sb = new StringBuilder();
            sb.append("An error occurred while dumping logs from agent ");
            sb.append(message.getScopedInstancePath());
            sb.append(" @ ");
            sb.append(message.getApplicationName());
            sb.append(". ");
            if (!Utils.isEmptyOrWhitespaces((String)e.getMessage())) {
                sb.append(e.getMessage());
            }
            this.logger.severe(sb.toString());
            Utils.logException((Logger)this.logger, (Throwable)e);
        }
    }

    private void processMsgNotifMachineDown(MsgNotifMachineDown message) {
        String scopedInstancePath = message.getScopedInstancePath();
        ManagedApplication ma = this.manager.applicationMngr().findManagedApplicationByName(message.getApplicationName());
        Application app = ma == null ? null : ma.getApplication();
        Instance scopedInstance = InstanceHelpers.findInstanceByPath((AbstractApplication)app, (String)scopedInstancePath);
        if (scopedInstance == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("A 'DOWN' notification was received from an unknown agent: ");
            sb.append(scopedInstancePath);
            sb.append(" (app = ");
            sb.append(app);
            sb.append(").");
            this.logger.warning(sb.toString());
        } else {
            DmUtils.markScopedInstanceAsNotDeployed(scopedInstance, ma, this.manager.notificationMngr(), this.manager.instancesMngr());
            this.logger.info(scopedInstance + " is now terminated. Back to NOT_DEPLOYED state.");
        }
    }

    private void processMsgNotifHeartbeat(MsgNotifHeartbeat message) {
        String scopedInstancePath = message.getScopedInstancePath();
        ManagedApplication ma = this.manager.applicationMngr().findManagedApplicationByName(message.getApplicationName());
        Application app = ma == null ? null : ma.getApplication();
        Instance scopedInstance = InstanceHelpers.findInstanceByPath((AbstractApplication)app, (String)scopedInstancePath);
        if (scopedInstance == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("A 'HEART BEAT' was received from an unknown agent: ");
            sb.append(scopedInstancePath);
            sb.append(" (app = ");
            sb.append(ma);
            sb.append(", inst = ");
            sb.append(scopedInstancePath);
            sb.append("). The heart beat is dropped.");
            this.logger.warning(sb.toString());
        } else if (!InstanceHelpers.isTarget((Instance)scopedInstance)) {
            StringBuilder sb = new StringBuilder();
            sb.append("A 'HEART BEAT' was received for a non-scoped instance: ");
            sb.append(scopedInstancePath);
            sb.append(" (app = ");
            sb.append(ma);
            sb.append(", inst = ");
            sb.append(scopedInstancePath);
            sb.append("). The heart beat is dropped.");
            this.logger.warning(sb.toString());
        } else {
            String ipAddress = message.getIpAddress();
            boolean ipWasSet = false;
            if (scopedInstance.data.get("ip.address") == null) {
                this.logger.fine(scopedInstancePath + " @ " + ipAddress + " is up and running.");
                scopedInstance.data.put("ip.address", ipAddress);
                ipWasSet = true;
            }
            this.logger.finest("A heart beat was acknowledged for " + scopedInstancePath + " in the application " + ma + ".");
            Instance.InstanceStatus oldStatus = scopedInstance.getStatus();
            ma.acknowledgeHeartBeat(scopedInstance);
            if (ipWasSet || oldStatus != scopedInstance.getStatus()) {
                this.manager.instancesMngr().instanceWasUpdated(scopedInstance, ma);
            }
            try {
                if (message.isModelRequired()) {
                    this.logger.fine("The DM is sending its model to agent " + scopedInstancePath + ".");
                    Map<String, byte[]> scriptResources = this.manager.targetsMngr().findScriptResourcesForAgent((AbstractApplication)ma.getApplication(), scopedInstance);
                    MsgCmdSetScopedInstance msg = new MsgCmdSetScopedInstance(scopedInstance, app.getExternalExports(), app.getApplicationBindings(), scriptResources);
                    ((IDmClient)this.messagingClient).sendMessageToAgent(ma.getApplication(), scopedInstance, (Message)msg);
                }
                this.manager.messagingMngr().sendStoredMessages(ma, scopedInstance);
            }
            catch (IOException e) {
                this.logger.warning("Agent " + scopedInstancePath + " requested its model but an error occurred. " + e.getMessage());
                Utils.logException((Logger)this.logger, (Throwable)e);
            }
        }
    }

    private void processMsgNotifInstanceChanged(MsgNotifInstanceChanged message) {
        String instancePath = message.getInstancePath();
        ManagedApplication ma = this.manager.applicationMngr().findManagedApplicationByName(message.getApplicationName());
        Application app = ma == null ? null : ma.getApplication();
        Instance instance = InstanceHelpers.findInstanceByPath((AbstractApplication)app, (String)instancePath);
        if (instance == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("A 'CHANGED' notification was received from an unknown instance: ");
            sb.append(instancePath);
            sb.append(" (app = ");
            sb.append(app);
            sb.append(").");
            this.logger.warning(sb.toString());
        } else if (InstanceHelpers.findRootInstance((Instance)instance).getStatus() == Instance.InstanceStatus.NOT_DEPLOYED) {
            StringBuilder sb = new StringBuilder();
            sb.append("A 'CHANGED' notification was received from a instance: ");
            sb.append(instancePath);
            sb.append(" (app = ");
            sb.append(app);
            sb.append(") but the root instance is not deployed. Status update is dismissed.");
            this.logger.warning(sb.toString());
        } else {
            Instance.InstanceStatus oldStatus = instance.getStatus();
            instance.setStatus(message.getNewStatus());
            ImportHelpers.updateImports((Instance)instance, (Map)message.getNewImports());
            StringBuilder sb = new StringBuilder();
            sb.append("Status changed from ");
            sb.append(oldStatus);
            sb.append(" to ");
            sb.append(message.getNewStatus());
            sb.append(" for instance ");
            sb.append(instancePath);
            sb.append(". Imports were updated too.");
            this.logger.fine(sb.toString());
            this.manager.instancesMngr().instanceWasUpdated(instance, ma);
        }
    }

    private void processMsgNotifInstanceRemoved(MsgNotifInstanceRemoved message) {
        String instancePath = message.getInstancePath();
        Application app = this.manager.applicationMngr().findApplicationByName(message.getApplicationName());
        Instance instance = InstanceHelpers.findInstanceByPath((AbstractApplication)app, (String)instancePath);
        if (instance == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("A 'REMOVE' notification was received for an unknown instance: ");
            sb.append(instancePath);
            sb.append(" (app = ");
            sb.append(app);
            sb.append(").");
            this.logger.warning(sb.toString());
        } else {
            if (InstanceHelpers.isTarget((Instance)instance)) {
                this.logger.warning("Anormal behavior. A 'REMOVE' notification was received for a scoped instance: " + instancePath + ".");
            } else {
                instance.getParent().getChildren().remove(instance);
            }
            this.logger.info("Instance " + instancePath + " was removed from the model.");
        }
    }

    private void processMsgMonitoringEvent(MsgNotifAutonomic message) {
        Application app = this.manager.applicationMngr().findApplicationByName(message.getApplicationName());
        Instance scopedInstance = InstanceHelpers.findInstanceByPath((AbstractApplication)app, (String)message.getScopedInstancePath());
        if (scopedInstance == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("A notification associated with autonomic management was received for an unknown instance: ");
            sb.append(message.getScopedInstancePath());
            sb.append(" (app = ");
            sb.append(app);
            sb.append(").");
            this.logger.warning(sb.toString());
        } else {
            ManagedApplication ma = this.manager.applicationMngr().findManagedApplicationByName(app.getName());
            this.manager.autonomicMngr().handleEvent(ma, message);
        }
    }
}

