/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.internal.tasks;

import java.util.TimerTask;
import java.util.logging.Logger;
import net.roboconf.core.model.beans.AbstractApplication;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.InstanceHelpers;
import net.roboconf.dm.management.ManagedApplication;
import net.roboconf.dm.management.api.IApplicationMngr;
import net.roboconf.dm.management.api.IMessagingMngr;

public class CheckerForStoredMessagesTask
extends TimerTask {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final IMessagingMngr messagingMngr;
    private final IApplicationMngr appManager;

    public CheckerForStoredMessagesTask(IApplicationMngr appManager, IMessagingMngr messagingMngr) {
        this.appManager = appManager;
        this.messagingMngr = messagingMngr;
    }

    @Override
    public void run() {
        this.logger.finest("The task that checks stored messages runs.");
        for (ManagedApplication ma : this.appManager.getManagedApplications()) {
            for (Instance scopedInstance : InstanceHelpers.findAllScopedInstances((AbstractApplication)ma.getApplication())) {
                this.messagingMngr.sendStoredMessages(ma, scopedInstance);
            }
        }
    }
}

