/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.internal.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Logger;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.InstanceHelpers;
import net.roboconf.core.model.runtime.EventType;
import net.roboconf.core.utils.Utils;
import net.roboconf.dm.management.ManagedApplication;
import net.roboconf.dm.management.api.IInstancesMngr;
import net.roboconf.dm.management.api.INotificationMngr;

public final class DmUtils {
    private DmUtils() {
    }

    public static void markScopedInstanceAsNotDeployed(Instance scopedInstance, ManagedApplication ma, INotificationMngr notificationMngr, IInstancesMngr instanceMngr) {
        scopedInstance.data.remove("ip.address");
        scopedInstance.data.remove("machine.id");
        scopedInstance.data.remove("target.acquired");
        scopedInstance.data.remove("running.from");
        scopedInstance.data.remove("ready.for.local.script.configuration");
        ArrayList<Instance> instancesToDelete = new ArrayList<Instance>();
        for (Instance i : InstanceHelpers.buildHierarchicalList((Instance)scopedInstance)) {
            Instance.InstanceStatus oldstatus = i.getStatus();
            i.setStatus(Instance.InstanceStatus.NOT_DEPLOYED);
            if (oldstatus != Instance.InstanceStatus.NOT_DEPLOYED) {
                notificationMngr.instance(i, ma.getApplication(), EventType.CHANGED);
            }
            i.getImports().clear();
            if (!i.data.containsKey("delete.when.not.deployed")) continue;
            instancesToDelete.add(i);
        }
        Collections.reverse(instancesToDelete);
        for (Instance i : instancesToDelete) {
            try {
                instanceMngr.removeInstance(ma, i, true);
            }
            catch (Exception e) {
                Logger logger = Logger.getLogger(DmUtils.class.getName());
                logger.severe("An error occurred while deleting an instance marked with DELETE_WHEN_NOT_DEPLOYED. Instance = " + InstanceHelpers.computeInstancePath((Instance)i) + " App = " + ma.getName());
                Utils.logException((Logger)logger, (Throwable)e);
            }
        }
    }
}

