/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.internal.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import net.roboconf.core.model.beans.AbstractApplication;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.InstanceHelpers;
import net.roboconf.core.utils.Utils;
import net.roboconf.dm.management.ManagedApplication;
import net.roboconf.dm.management.api.ITargetHandlerResolver;
import net.roboconf.dm.management.api.ITargetsMngr;
import net.roboconf.target.api.TargetException;

public final class TargetHelpers {
    private TargetHelpers() {
    }

    public static void verifyTargets(ITargetHandlerResolver targetHandlerResolver, ManagedApplication ma, ITargetsMngr targetsMngr) {
        Logger logger = Logger.getLogger(TargetHelpers.class.getName());
        for (Instance inst : InstanceHelpers.getAllInstances((AbstractApplication)ma.getApplication())) {
            if (!InstanceHelpers.isTarget((Instance)inst)) continue;
            try {
                String path = InstanceHelpers.computeInstancePath((Instance)inst);
                Map<String, String> targetProperties = targetsMngr.findTargetProperties((AbstractApplication)ma.getApplication(), path).asMap();
                targetHandlerResolver.findTargetHandler(targetProperties);
            }
            catch (TargetException e) {
                logger.warning(e.getMessage());
            }
        }
    }

    public static Map<String, String> expandProperties(Instance scopedInstance, Map<String, String> targetProperties) {
        Logger logger = Logger.getLogger(TargetHelpers.class.getName());
        String ipAddress = (String)scopedInstance.data.get("ip.address");
        if (ipAddress == null) {
            ipAddress = (String)InstanceHelpers.findRootInstance((Instance)scopedInstance).data.get("ip.address");
        }
        if (ipAddress == null) {
            ipAddress = "";
        }
        Properties params = new Properties();
        params.setProperty("ip", ipAddress);
        HashMap<String, String> newTargetProperties = new HashMap<String, String>(targetProperties.size());
        for (Map.Entry<String, String> entry : targetProperties.entrySet()) {
            String p = Utils.expandTemplate((String)entry.getValue(), (Properties)params);
            newTargetProperties.put(entry.getKey(), p);
            if (p.equals(entry.getValue())) continue;
            logger.fine("Target property '" + entry.getKey() + "' was expanded to " + p);
        }
        return newTargetProperties;
    }

    public static String findTargetHandlerName(Properties props) {
        return props.getProperty("handler");
    }

    public static String findTargetHandlerName(Map<String, String> props) {
        return props.get("handler");
    }
}

