/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.management;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import net.roboconf.core.model.beans.AbstractApplication;
import net.roboconf.core.model.beans.Application;
import net.roboconf.core.model.beans.Graphs;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.InstanceHelpers;
import net.roboconf.core.model.runtime.EventType;
import net.roboconf.dm.management.api.INotificationMngr;
import net.roboconf.messaging.api.messages.Message;

public class ManagedApplication {
    static final String MISSED_HEARTBEATS = "dm.missed.heartbeats";
    static final int THRESHOLD = 2;
    private final Application application;
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final Map<Instance, List<Message>> scopedInstanceToAwaitingMessages;

    public ManagedApplication(Application application) {
        Objects.requireNonNull(application);
        Objects.requireNonNull(application.getTemplate());
        this.application = application;
        this.scopedInstanceToAwaitingMessages = new HashMap<Instance, List<Message>>();
    }

    public Map<Instance, List<Message>> getScopedInstanceToAwaitingMessages() {
        return this.scopedInstanceToAwaitingMessages;
    }

    public Application getApplication() {
        return this.application;
    }

    public File getDirectory() {
        return this.application.getDirectory();
    }

    public String getName() {
        return this.application.getName();
    }

    public Graphs getGraphs() {
        return this.application.getTemplate().getGraphs();
    }

    public File getTemplateDirectory() {
        return this.application.getTemplate().getDirectory();
    }

    public String toString() {
        return String.valueOf(this.application);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeAwaitingMessage(Instance instance, Message msg) {
        Instance scopedInstance = InstanceHelpers.findScopedInstance((Instance)instance);
        this.logger.finer("Storing message " + msg.getClass().getSimpleName() + " for instance " + scopedInstance);
        Map<Instance, List<Message>> map = this.scopedInstanceToAwaitingMessages;
        synchronized (map) {
            List<Message> messages = this.scopedInstanceToAwaitingMessages.get(scopedInstance);
            if (messages == null) {
                messages = new ArrayList<Message>(1);
                this.scopedInstanceToAwaitingMessages.put(scopedInstance, messages);
            }
            messages.add(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message> removeAwaitingMessages(Instance instance) {
        Instance scopedInstance = InstanceHelpers.findScopedInstance((Instance)instance);
        ArrayList result = null;
        Map<Instance, List<Message>> map = this.scopedInstanceToAwaitingMessages;
        synchronized (map) {
            result = this.scopedInstanceToAwaitingMessages.remove(scopedInstance);
        }
        return result != null ? result : new ArrayList(0);
    }

    public void acknowledgeHeartBeat(Instance scopedInstance) {
        String count = (String)scopedInstance.data.get(MISSED_HEARTBEATS);
        if (count != null && Integer.parseInt(count) > 2) {
            this.logger.info("Agent " + InstanceHelpers.computeInstancePath((Instance)scopedInstance) + " is alive and reachable again.");
        }
        if (scopedInstance.getStatus() != Instance.InstanceStatus.DEPLOYED_STARTED || !scopedInstance.data.containsKey("running.from")) {
            scopedInstance.data.put("running.from", String.valueOf(new Date().getTime()));
        }
        scopedInstance.setStatus(Instance.InstanceStatus.DEPLOYED_STARTED);
        scopedInstance.data.remove(MISSED_HEARTBEATS);
    }

    public void checkStates(INotificationMngr notificationMngr) {
        List scopedInstances = InstanceHelpers.findAllScopedInstances((AbstractApplication)this.application);
        for (Instance scopedInstance : scopedInstances) {
            int count;
            if (scopedInstance.getStatus() == Instance.InstanceStatus.NOT_DEPLOYED || scopedInstance.getStatus() == Instance.InstanceStatus.DEPLOYING || scopedInstance.getStatus() == Instance.InstanceStatus.UNDEPLOYING) {
                scopedInstance.data.remove(MISSED_HEARTBEATS);
                continue;
            }
            String countAs = (String)scopedInstance.data.get(MISSED_HEARTBEATS);
            int n = count = countAs == null ? 0 : Integer.parseInt(countAs);
            if (++count > 2) {
                scopedInstance.setStatus(Instance.InstanceStatus.PROBLEM);
                notificationMngr.instance(scopedInstance, this.application, EventType.CHANGED);
                this.logger.severe("Agent " + InstanceHelpers.computeInstancePath((Instance)scopedInstance) + " has not sent heart beats for quite a long time. Status changed to PROBLEM.");
            }
            scopedInstance.data.put(MISSED_HEARTBEATS, String.valueOf(count));
        }
    }
}

