/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.management.api;

import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.roboconf.core.model.ParsingError;
import net.roboconf.core.model.beans.Application;
import net.roboconf.core.model.runtime.CommandHistoryItem;
import net.roboconf.dm.management.exceptions.CommandException;

public interface ICommandsMngr {
    public void createOrUpdateCommand(Application var1, String var2, String var3) throws IOException;

    public void deleteCommand(Application var1, String var2) throws IOException;

    public List<String> listCommands(Application var1);

    public String getCommandInstructions(Application var1, String var2) throws IOException;

    public List<ParsingError> validate(Application var1, String var2);

    public void execute(Application var1, String var2, int var3, String var4) throws CommandException, NoSuchFileException;

    public void execute(Application var1, String var2, CommandExecutionContext var3, int var4, String var5) throws CommandException, NoSuchFileException;

    public List<CommandHistoryItem> getHistory(int var1, int var2, String var3, String var4, String var5);

    public int getHistoryNumberOfPages(int var1, String var2);

    public static final class CommandExecutionContext {
        private final AtomicInteger globalVmNumber;
        private final AtomicInteger appVmNumber;
        private final int maxVm;
        private final boolean strictMaxVm;
        private final String newVmMarkerKey;
        private final String newVmMarkerValue;

        public CommandExecutionContext(AtomicInteger globalVmNumber, AtomicInteger appVmNumber, int maxVm, boolean strictMaxVm, String newVmMarkerKey, String newVmMarkerValue) {
            this.maxVm = maxVm;
            this.strictMaxVm = strictMaxVm;
            this.newVmMarkerKey = newVmMarkerKey;
            this.newVmMarkerValue = newVmMarkerValue;
            this.globalVmNumber = globalVmNumber;
            this.appVmNumber = appVmNumber;
        }

        public int getMaxVm() {
            return this.maxVm;
        }

        public boolean isStrictMaxVm() {
            return this.strictMaxVm;
        }

        public String getNewVmMarkerKey() {
            return this.newVmMarkerKey;
        }

        public String getNewVmMarkerValue() {
            return this.newVmMarkerValue;
        }

        public AtomicInteger getGlobalVmNumber() {
            return this.globalVmNumber;
        }

        public AtomicInteger getAppVmNumber() {
            return this.appVmNumber;
        }
    }
}

