/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.management.api;

import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.roboconf.core.model.runtime.Preference;

public interface IPreferencesMngr {
    @PreferenceDescription(desc="The e-mail address of the sender.\nThis is a javax.mail property.")
    public static final String JAVAX_MAIL_FROM = "mail.from";
    @PreferenceDescription(desc="The user name for the SMTP server.\nThis is a javax.mail property.")
    public static final String JAVAX_MAIL_SMTP_USER = "mail.user";
    @PreferenceDescription(desc="The password for the SMTP server.\nThis is a javax.mail property.")
    public static final String JAVAX_MAIL_SMTP_PWD = "mail.password";
    @PreferenceDescription(desc="Whether authentication is required or not.\nThis is a javax.mail property.", values={"true", "false"})
    public static final String JAVAX_MAIL_SMTP_AUTH = "mail.smtp.auth";
    @PreferenceDescription(desc="The host name or IP address of the SMTP server.\nThis is a javax.mail property.")
    public static final String JAVAX_MAIL_SMTP_HOST = "mail.smtp.host";
    @PreferenceDescription(desc="The port used to reach the SMTP server.\nThis is a javax.mail property.")
    public static final String JAVAX_MAIL_SMTP_PORT = "mail.smtp.port";
    @PreferenceDescription(desc="Whether TLS is enabled or not.\nThis is a javax.mail property.", values={"true", "false"})
    public static final String JAVAX_MAIL_START_SSL_ENABLE = "mail.smtp.starttls.enable";
    @PreferenceDescription(desc="A list of trusted host names or IP addresses for secured connections.\nThis is a javax.mail property.")
    public static final String JAVAX_MAIL_SSL_TRUST = "mail.smtp.ssl.trust";
    @PreferenceDescription(desc="A list of default recipients that will receive all the e-mails sent by Roboconf.\nThese recipients come in addition to those configured somewhere else\n(e.g. within a command or through the autonomic).")
    public static final String EMAIL_DEFAULT_RECIPIENTS = "email.default.recipients";
    @PreferenceDescription(desc="Instead of forcing a given port, it is possible to let Roboconf pick up one randomly.\nRandom ports are selected between 10000 and 65500.\nThis preference allows to exclude one or several ports from being chosen by Roboconf.\nPorts must be separated by a comma. Example: 11000, 11001, 11002")
    public static final String FORBIDDEN_RANDOM_PORTS = "forbidden.random.ports";
    @PreferenceDescription(desc="The maximum number of VMs the autonomic can create.\nThis is a global maximum, the count is effctive for all the applications.")
    public static final String AUTONOMIC_MAX_VM_NUMBER = "autonomic.maximum.vm.number";
    @PreferenceDescription(values={"true", "false"}, desc="Whether the maximum number of VMs is strict or if it could support some outbounds.\nGiven all the concurrency in Roboconf, it may happen several autonomic VMs are created at once and\nmay result in the maximum being a little overheaded.\n\nSet it to \"true\" to be strict. Setting it to \"false\" may result in the maximum being never reached.")
    public static final String AUTONOMIC_STRICT_MAX_VM_NUMBER = "autonomic.strict.maximum.vm.number";
    @PreferenceDescription(values={"EN (for English)", "FR (for French)"}, desc="The user language (e.g. for the web console).")
    public static final String USER_LANGUAGE = "user.language";
    @PreferenceDescription(desc="List of web extensions (automatically fetched by the web console).\nThis preference is generally populated by bundles and directly from the code. The web console only loads extensions located on the DM's web server. So, one could save (e.g.) 'http://google.com' in this preference. But the web console would not embed its content.")
    public static final String WEB_EXTENSIONS = "web.extensions";

    public String get(String var1);

    public String get(String var1, String var2);

    public void save(String var1, String var2) throws IOException;

    public void addToList(String var1, String var2) throws IOException;

    public void removeFromList(String var1, String var2) throws IOException;

    public Collection<String> getAsCollection(String var1);

    public void updateProperties(Dictionary<?, ?> var1);

    public String delete(String var1);

    public Properties getJavaxMailProperties();

    public List<Preference> getAllPreferences();

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface PreferenceDescription {
        public String desc() default "";

        public String[] values() default {};
    }

    public static final class Defaults {
        public final Map<String, Preference.PreferenceKeyCategory> keyToCategory = new HashMap<String, Preference.PreferenceKeyCategory>();
        public final Map<String, String> keyToDefaultValue = new HashMap<String, String>();

        public Defaults() {
            this.keyToCategory.put(IPreferencesMngr.JAVAX_MAIL_FROM, Preference.PreferenceKeyCategory.EMAIL);
            this.keyToCategory.put(IPreferencesMngr.JAVAX_MAIL_SMTP_USER, Preference.PreferenceKeyCategory.EMAIL);
            this.keyToCategory.put(IPreferencesMngr.JAVAX_MAIL_SMTP_PWD, Preference.PreferenceKeyCategory.EMAIL);
            this.keyToCategory.put(IPreferencesMngr.JAVAX_MAIL_SMTP_AUTH, Preference.PreferenceKeyCategory.EMAIL);
            this.keyToCategory.put(IPreferencesMngr.JAVAX_MAIL_SMTP_HOST, Preference.PreferenceKeyCategory.EMAIL);
            this.keyToCategory.put(IPreferencesMngr.JAVAX_MAIL_SMTP_PORT, Preference.PreferenceKeyCategory.EMAIL);
            this.keyToCategory.put(IPreferencesMngr.JAVAX_MAIL_SSL_TRUST, Preference.PreferenceKeyCategory.EMAIL);
            this.keyToCategory.put(IPreferencesMngr.JAVAX_MAIL_START_SSL_ENABLE, Preference.PreferenceKeyCategory.EMAIL);
            this.keyToCategory.put(IPreferencesMngr.EMAIL_DEFAULT_RECIPIENTS, Preference.PreferenceKeyCategory.EMAIL);
            this.keyToCategory.put(IPreferencesMngr.AUTONOMIC_MAX_VM_NUMBER, Preference.PreferenceKeyCategory.AUTONOMIC);
            this.keyToCategory.put(IPreferencesMngr.AUTONOMIC_STRICT_MAX_VM_NUMBER, Preference.PreferenceKeyCategory.AUTONOMIC);
            this.keyToCategory.put(IPreferencesMngr.USER_LANGUAGE, Preference.PreferenceKeyCategory.WEB);
            this.keyToCategory.put(IPreferencesMngr.WEB_EXTENSIONS, Preference.PreferenceKeyCategory.WEB);
            this.keyToCategory.put(IPreferencesMngr.FORBIDDEN_RANDOM_PORTS, Preference.PreferenceKeyCategory.MISCELLANEOUS);
            this.keyToDefaultValue.put(IPreferencesMngr.JAVAX_MAIL_FROM, "dm@roboconf.net");
            this.keyToDefaultValue.put(IPreferencesMngr.JAVAX_MAIL_SMTP_AUTH, "true");
            this.keyToDefaultValue.put(IPreferencesMngr.JAVAX_MAIL_SMTP_HOST, "smtp.gmail.com");
            this.keyToDefaultValue.put(IPreferencesMngr.JAVAX_MAIL_SMTP_PORT, "587");
            this.keyToDefaultValue.put(IPreferencesMngr.JAVAX_MAIL_SSL_TRUST, "smtp.gmail.com");
            this.keyToDefaultValue.put(IPreferencesMngr.JAVAX_MAIL_START_SSL_ENABLE, "true");
            this.keyToDefaultValue.put(IPreferencesMngr.USER_LANGUAGE, "EN");
        }
    }
}

