/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.rest.services.internal;

import com.sun.jersey.spi.container.servlet.ServletContainer;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.ws.rs.core.Application;
import net.roboconf.core.utils.Utils;
import net.roboconf.dm.management.Manager;
import net.roboconf.dm.rest.commons.security.AuthenticationManager;
import net.roboconf.dm.rest.services.internal.RestApplication;
import net.roboconf.dm.rest.services.internal.filters.AuthenticationFilter;
import net.roboconf.dm.rest.services.internal.icons.IconServlet;
import net.roboconf.dm.rest.services.internal.websocket.RoboconfWebSocketServlet;
import net.roboconf.dm.rest.services.internal.websocket.WebSocketHandler;
import net.roboconf.dm.rest.services.jmx.RestServicesMBean;
import net.roboconf.dm.scheduler.IScheduler;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.ops4j.pax.url.mvn.MavenResolver;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpService;

public class ServletRegistrationComponent
implements RestServicesMBean,
Pojo {
    InstanceManager __IM;
    public static final String REST_CONTEXT = "/roboconf-dm";
    public static final String WEBSOCKET_CONTEXT = "/roboconf-dm-websocket";
    static final String ICONS_CONTEXT = "/roboconf-icons";
    private boolean __FhttpService;
    private HttpService httpService;
    private boolean __Fmanager;
    private Manager manager;
    private boolean __Fscheduler;
    private IScheduler scheduler;
    private boolean __FmavenResolver;
    private MavenResolver mavenResolver;
    private boolean __FenableCors;
    private boolean enableCors;
    private boolean __FenableAuthentication;
    private boolean enableAuthentication;
    private boolean __FsessionPeriod;
    private long sessionPeriod;
    private boolean __Flogger;
    private final Logger logger;
    private boolean __FbundleContext;
    private final BundleContext bundleContext;
    private boolean __Fapp;
    RestApplication app;
    private boolean __FjerseyServlet;
    ServletContainer jerseyServlet;
    private boolean __FfilterServiceRegistration;
    ServiceRegistration<Filter> filterServiceRegistration;
    private boolean __FauthenticationFilter;
    AuthenticationFilter authenticationFilter;
    private boolean __FauthenticationMngr;
    AuthenticationManager authenticationMngr;
    private boolean __FrestRequestsCount;
    public final AtomicLong restRequestsCount;
    private boolean __FrestRequestsWithAuthFailureCount;
    public final AtomicLong restRequestsWithAuthFailureCount;
    public static final AtomicLong WS_CONNECTION_ERRORS_COUNT = new AtomicLong();
    boolean __Mstarting;
    boolean __Mstopping;
    boolean __MschedulerAppears;
    boolean __MschedulerDisappears;
    boolean __MmavenResolverAppears;
    boolean __MmavenResolverDisappears;
    boolean __MsetHttpService$org_osgi_service_http_HttpService;
    boolean __MsetManager$net_roboconf_dm_management_Manager;
    boolean __MsetEnableCors$boolean;
    boolean __MsetEnableAuthentication$boolean;
    boolean __MsetAuthenticationRealm$java_lang_String;
    boolean __MsetSessionPeriod$long;
    boolean __MsetScheduler$net_roboconf_dm_scheduler_IScheduler;
    boolean __MsetMavenResolver$org_ops4j_pax_url_mvn_MavenResolver;
    boolean __MgetCurrentWebSocketClientsCount;
    boolean __MgetWebSocketConnectionErrorsCount;
    boolean __MgetRestRequestsWithAuthFailureCount;
    boolean __MgetRestRequestsCount;
    boolean __MisAuthenticationRequired;
    boolean __MisCorsEnabled;
    boolean __Mreset;

    HttpService __gethttpService() {
        if (!this.__FhttpService) {
            return this.httpService;
        }
        return (HttpService)this.__IM.onGet((Object)this, "httpService");
    }

    void __sethttpService(HttpService httpService) {
        if (!this.__FhttpService) {
            this.httpService = httpService;
            return;
        }
        this.__IM.onSet((Object)this, "httpService", (Object)httpService);
    }

    Manager __getmanager() {
        if (!this.__Fmanager) {
            return this.manager;
        }
        return (Manager)this.__IM.onGet((Object)this, "manager");
    }

    void __setmanager(Manager manager) {
        if (!this.__Fmanager) {
            this.manager = manager;
            return;
        }
        this.__IM.onSet((Object)this, "manager", (Object)manager);
    }

    IScheduler __getscheduler() {
        if (!this.__Fscheduler) {
            return this.scheduler;
        }
        return (IScheduler)this.__IM.onGet((Object)this, "scheduler");
    }

    void __setscheduler(IScheduler iScheduler) {
        if (!this.__Fscheduler) {
            this.scheduler = iScheduler;
            return;
        }
        this.__IM.onSet((Object)this, "scheduler", (Object)iScheduler);
    }

    MavenResolver __getmavenResolver() {
        if (!this.__FmavenResolver) {
            return this.mavenResolver;
        }
        return (MavenResolver)this.__IM.onGet((Object)this, "mavenResolver");
    }

    void __setmavenResolver(MavenResolver mavenResolver) {
        if (!this.__FmavenResolver) {
            this.mavenResolver = mavenResolver;
            return;
        }
        this.__IM.onSet((Object)this, "mavenResolver", (Object)mavenResolver);
    }

    boolean __getenableCors() {
        if (!this.__FenableCors) {
            return this.enableCors;
        }
        Object object = this.__IM.onGet((Object)this, "enableCors");
        Boolean bl = (Boolean)object;
        return bl;
    }

    void __setenableCors(boolean bl) {
        if (!this.__FenableCors) {
            this.enableCors = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this.__IM.onSet((Object)this, "enableCors", (Object)bl2);
    }

    boolean __getenableAuthentication() {
        if (!this.__FenableAuthentication) {
            return this.enableAuthentication;
        }
        Object object = this.__IM.onGet((Object)this, "enableAuthentication");
        Boolean bl = (Boolean)object;
        return bl;
    }

    void __setenableAuthentication(boolean bl) {
        if (!this.__FenableAuthentication) {
            this.enableAuthentication = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this.__IM.onSet((Object)this, "enableAuthentication", (Object)bl2);
    }

    long __getsessionPeriod() {
        if (!this.__FsessionPeriod) {
            return this.sessionPeriod;
        }
        Object object = this.__IM.onGet((Object)this, "sessionPeriod");
        Long l = (Long)object;
        return l;
    }

    void __setsessionPeriod(long l) {
        if (!this.__FsessionPeriod) {
            this.sessionPeriod = l;
            return;
        }
        Long l2 = new Long(l);
        this.__IM.onSet((Object)this, "sessionPeriod", (Object)l2);
    }

    Logger __getlogger() {
        if (!this.__Flogger) {
            return this.logger;
        }
        return (Logger)this.__IM.onGet((Object)this, "logger");
    }

    void __setlogger(Logger logger) {
        if (!this.__Flogger) {
            this.logger = logger;
            return;
        }
        this.__IM.onSet((Object)this, "logger", (Object)logger);
    }

    BundleContext __getbundleContext() {
        if (!this.__FbundleContext) {
            return this.bundleContext;
        }
        return (BundleContext)this.__IM.onGet((Object)this, "bundleContext");
    }

    void __setbundleContext(BundleContext bundleContext) {
        if (!this.__FbundleContext) {
            this.bundleContext = bundleContext;
            return;
        }
        this.__IM.onSet((Object)this, "bundleContext", (Object)bundleContext);
    }

    RestApplication __getapp() {
        if (!this.__Fapp) {
            return this.app;
        }
        return (RestApplication)((Object)this.__IM.onGet((Object)this, "app"));
    }

    void __setapp(RestApplication restApplication) {
        if (!this.__Fapp) {
            this.app = restApplication;
            return;
        }
        this.__IM.onSet((Object)this, "app", (Object)restApplication);
    }

    ServletContainer __getjerseyServlet() {
        if (!this.__FjerseyServlet) {
            return this.jerseyServlet;
        }
        return (ServletContainer)this.__IM.onGet((Object)this, "jerseyServlet");
    }

    void __setjerseyServlet(ServletContainer servletContainer) {
        if (!this.__FjerseyServlet) {
            this.jerseyServlet = servletContainer;
            return;
        }
        this.__IM.onSet((Object)this, "jerseyServlet", (Object)servletContainer);
    }

    ServiceRegistration __getfilterServiceRegistration() {
        if (!this.__FfilterServiceRegistration) {
            return this.filterServiceRegistration;
        }
        return (ServiceRegistration)this.__IM.onGet((Object)this, "filterServiceRegistration");
    }

    void __setfilterServiceRegistration(ServiceRegistration serviceRegistration) {
        if (!this.__FfilterServiceRegistration) {
            this.filterServiceRegistration = serviceRegistration;
            return;
        }
        this.__IM.onSet((Object)this, "filterServiceRegistration", (Object)serviceRegistration);
    }

    AuthenticationFilter __getauthenticationFilter() {
        if (!this.__FauthenticationFilter) {
            return this.authenticationFilter;
        }
        return (AuthenticationFilter)this.__IM.onGet((Object)this, "authenticationFilter");
    }

    void __setauthenticationFilter(AuthenticationFilter authenticationFilter) {
        if (!this.__FauthenticationFilter) {
            this.authenticationFilter = authenticationFilter;
            return;
        }
        this.__IM.onSet((Object)this, "authenticationFilter", (Object)authenticationFilter);
    }

    AuthenticationManager __getauthenticationMngr() {
        if (!this.__FauthenticationMngr) {
            return this.authenticationMngr;
        }
        return (AuthenticationManager)this.__IM.onGet((Object)this, "authenticationMngr");
    }

    void __setauthenticationMngr(AuthenticationManager authenticationManager) {
        if (!this.__FauthenticationMngr) {
            this.authenticationMngr = authenticationManager;
            return;
        }
        this.__IM.onSet((Object)this, "authenticationMngr", (Object)authenticationManager);
    }

    AtomicLong __getrestRequestsCount() {
        if (!this.__FrestRequestsCount) {
            return this.restRequestsCount;
        }
        return (AtomicLong)this.__IM.onGet((Object)this, "restRequestsCount");
    }

    void __setrestRequestsCount(AtomicLong atomicLong) {
        if (!this.__FrestRequestsCount) {
            this.restRequestsCount = atomicLong;
            return;
        }
        this.__IM.onSet((Object)this, "restRequestsCount", (Object)atomicLong);
    }

    AtomicLong __getrestRequestsWithAuthFailureCount() {
        if (!this.__FrestRequestsWithAuthFailureCount) {
            return this.restRequestsWithAuthFailureCount;
        }
        return (AtomicLong)this.__IM.onGet((Object)this, "restRequestsWithAuthFailureCount");
    }

    void __setrestRequestsWithAuthFailureCount(AtomicLong atomicLong) {
        if (!this.__FrestRequestsWithAuthFailureCount) {
            this.restRequestsWithAuthFailureCount = atomicLong;
            return;
        }
        this.__IM.onSet((Object)this, "restRequestsWithAuthFailureCount", (Object)atomicLong);
    }

    public ServletRegistrationComponent(BundleContext bundleContext) {
        this(null, bundleContext);
    }

    private ServletRegistrationComponent(InstanceManager _manager, BundleContext bundleContext) {
        this._setInstanceManager(_manager);
        this.__setenableCors(false);
        this.__setenableAuthentication(false);
        this.__setlogger(Logger.getLogger(this.getClass().getName()));
        this.__setrestRequestsCount(new AtomicLong());
        this.__setrestRequestsWithAuthFailureCount(new AtomicLong());
        this.__setbundleContext(bundleContext);
    }

    public void starting() throws Exception {
        if (!this.__Mstarting) {
            this.__M_starting();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "starting", new Object[0]);
            this.__M_starting();
            this.__IM.onExit((Object)this, "starting", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "starting", throwable);
            throw throwable;
        }
    }

    private void __M_starting() throws Exception {
        this.__getlogger().fine("iPojo registers REST and icons servlets related to Roboconf's DM.");
        this.__setapp(new RestApplication(this.__getmanager()));
        this.__getapp().setScheduler(this.__getscheduler());
        this.__getapp().setMavenResolver(this.__getmavenResolver());
        this.__getapp().enableCors(this.__getenableCors());
        this.__getapp().setAuthenticationManager(this.__getauthenticationMngr());
        Hashtable<String, String> initParams = new Hashtable<String, String>();
        ((Dictionary)initParams).put("servlet-name", "Roboconf DM (REST)");
        this.__setjerseyServlet(new ServletContainer((Application)this.__getapp()));
        this.__gethttpService().registerServlet(REST_CONTEXT, (Servlet)this.__getjerseyServlet(), initParams, null);
        initParams = new Hashtable();
        ((Dictionary)initParams).put("servlet-name", "Roboconf DM (icons)");
        IconServlet iconServlet = new IconServlet(this.__getmanager());
        this.__gethttpService().registerServlet(ICONS_CONTEXT, (Servlet)iconServlet, initParams, null);
        initParams = new Hashtable();
        ((Dictionary)initParams).put("servlet-name", "Roboconf DM (websocket)");
        RoboconfWebSocketServlet websocketServlet = new RoboconfWebSocketServlet();
        this.__gethttpService().registerServlet(WEBSOCKET_CONTEXT, (Servlet)websocketServlet, initParams, null);
        this.__setauthenticationFilter(new AuthenticationFilter(this));
        this.__getauthenticationFilter().setAuthenticationEnabled(this.__getenableAuthentication());
        this.__getauthenticationFilter().setAuthenticationManager(this.__getauthenticationMngr());
        this.__getauthenticationFilter().setSessionPeriod(this.__getsessionPeriod());
        this.__getauthenticationFilter().setEnableCors(this.__getenableCors());
        initParams = new Hashtable();
        ((Dictionary)initParams).put("urlPatterns", "*");
        if (this.__getbundleContext() != null) {
            this.__setfilterServiceRegistration(this.__getbundleContext().registerService(Filter.class, (Object)this.__getauthenticationFilter(), initParams));
        } else {
            this.__getlogger().warning("No bundle context was available, the authentication filter was not registered.");
        }
    }

    public void stopping() throws Exception {
        if (!this.__Mstopping) {
            this.__M_stopping();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stopping", new Object[0]);
            this.__M_stopping();
            this.__IM.onExit((Object)this, "stopping", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stopping", throwable);
            throw throwable;
        }
    }

    private void __M_stopping() throws Exception {
        if (this.__getfilterServiceRegistration() != null) {
            this.__getfilterServiceRegistration().unregister();
        }
        this.__getlogger().fine("iPojo unregisters REST and icons servlets related to Roboconf's DM.");
        if (this.__gethttpService() != null) {
            this.__gethttpService().unregister(REST_CONTEXT);
            this.__gethttpService().unregister(ICONS_CONTEXT);
            this.__gethttpService().unregister(WEBSOCKET_CONTEXT);
        } else {
            this.__getlogger().fine("The HTTP service is gone. The servlets were already unregistered.");
        }
        this.__setapp(null);
        this.__setjerseyServlet(null);
        this.__setfilterServiceRegistration(null);
        this.__setauthenticationFilter(null);
    }

    public void schedulerAppears() throws Exception {
        if (!this.__MschedulerAppears) {
            this.__M_schedulerAppears();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "schedulerAppears", new Object[0]);
            this.__M_schedulerAppears();
            this.__IM.onExit((Object)this, "schedulerAppears", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "schedulerAppears", throwable);
            throw throwable;
        }
    }

    private void __M_schedulerAppears() throws Exception {
        this.__getlogger().fine("Roboconf's scheduler is here. Updating the REST resource.");
        if (this.__getapp() != null) {
            this.__getapp().setScheduler(this.__getscheduler());
        }
    }

    public void schedulerDisappears() throws Exception {
        if (!this.__MschedulerDisappears) {
            this.__M_schedulerDisappears();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "schedulerDisappears", new Object[0]);
            this.__M_schedulerDisappears();
            this.__IM.onExit((Object)this, "schedulerDisappears", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "schedulerDisappears", throwable);
            throw throwable;
        }
    }

    private void __M_schedulerDisappears() throws Exception {
        this.__getlogger().fine("Roboconf's scheduler vanished. Updating the REST resource.");
        if (this.__getapp() != null) {
            this.__getapp().setScheduler(null);
        }
    }

    public void mavenResolverAppears() throws Exception {
        if (!this.__MmavenResolverAppears) {
            this.__M_mavenResolverAppears();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "mavenResolverAppears", new Object[0]);
            this.__M_mavenResolverAppears();
            this.__IM.onExit((Object)this, "mavenResolverAppears", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "mavenResolverAppears", throwable);
            throw throwable;
        }
    }

    private void __M_mavenResolverAppears() throws Exception {
        this.__getlogger().fine("Roboconf's URL resolver is here. Updating the REST resource.");
        if (this.__getapp() != null) {
            this.__getapp().setMavenResolver(this.__getmavenResolver());
        }
    }

    public void mavenResolverDisappears() throws Exception {
        if (!this.__MmavenResolverDisappears) {
            this.__M_mavenResolverDisappears();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "mavenResolverDisappears", new Object[0]);
            this.__M_mavenResolverDisappears();
            this.__IM.onExit((Object)this, "mavenResolverDisappears", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "mavenResolverDisappears", throwable);
            throw throwable;
        }
    }

    private void __M_mavenResolverDisappears() throws Exception {
        this.__getlogger().fine("Roboconf's URL resolver vanished. Updating the REST resource.");
        if (this.__getapp() != null) {
            this.__getapp().setMavenResolver(null);
        }
    }

    public void setHttpService(HttpService httpService) {
        if (!this.__MsetHttpService$org_osgi_service_http_HttpService) {
            this.__M_setHttpService(httpService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setHttpService$org_osgi_service_http_HttpService", new Object[]{httpService});
            this.__M_setHttpService(httpService);
            this.__IM.onExit((Object)this, "setHttpService$org_osgi_service_http_HttpService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setHttpService$org_osgi_service_http_HttpService", throwable);
            throw throwable;
        }
    }

    private void __M_setHttpService(HttpService httpService) {
        this.__sethttpService(httpService);
    }

    public void setManager(Manager manager) {
        if (!this.__MsetManager$net_roboconf_dm_management_Manager) {
            this.__M_setManager(manager);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setManager$net_roboconf_dm_management_Manager", new Object[]{manager});
            this.__M_setManager(manager);
            this.__IM.onExit((Object)this, "setManager$net_roboconf_dm_management_Manager", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setManager$net_roboconf_dm_management_Manager", throwable);
            throw throwable;
        }
    }

    private void __M_setManager(Manager manager) {
        this.__setmanager(manager);
    }

    public void setEnableCors(boolean enableCors) {
        if (!this.__MsetEnableCors$boolean) {
            this.__M_setEnableCors(enableCors);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setEnableCors$boolean", new Object[]{new Boolean(enableCors)});
            this.__M_setEnableCors(enableCors);
            this.__IM.onExit((Object)this, "setEnableCors$boolean", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setEnableCors$boolean", throwable);
            throw throwable;
        }
    }

    private void __M_setEnableCors(boolean enableCors) {
        this.__getlogger().fine("CORS is now " + (enableCors ? "enabled" : "disabled") + ". Updating the REST resource.");
        this.__setenableCors(enableCors);
        if (this.__getapp() != null) {
            this.__getapp().enableCors(enableCors);
        }
        if (this.__getauthenticationFilter() != null) {
            this.__getauthenticationFilter().setEnableCors(enableCors);
        }
        try {
            if (this.__getjerseyServlet() != null) {
                this.__getjerseyServlet().reload();
            }
        }
        catch (Exception e) {
            Utils.logException((Logger)this.__getlogger(), (Throwable)e);
        }
    }

    public void setEnableAuthentication(boolean enableAuthentication) {
        if (!this.__MsetEnableAuthentication$boolean) {
            this.__M_setEnableAuthentication(enableAuthentication);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setEnableAuthentication$boolean", new Object[]{new Boolean(enableAuthentication)});
            this.__M_setEnableAuthentication(enableAuthentication);
            this.__IM.onExit((Object)this, "setEnableAuthentication$boolean", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setEnableAuthentication$boolean", throwable);
            throw throwable;
        }
    }

    private void __M_setEnableAuthentication(boolean enableAuthentication) {
        this.__getlogger().fine("Authentication is now " + (enableAuthentication ? "enabled" : "disabled") + ". Updating the REST resource.");
        this.__setenableAuthentication(enableAuthentication);
        if (this.__getauthenticationFilter() != null) {
            this.__getauthenticationFilter().setAuthenticationEnabled(enableAuthentication);
        }
    }

    public void setAuthenticationRealm(String authenticationRealm) {
        if (!this.__MsetAuthenticationRealm$java_lang_String) {
            this.__M_setAuthenticationRealm(authenticationRealm);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setAuthenticationRealm$java_lang_String", new Object[]{authenticationRealm});
            this.__M_setAuthenticationRealm(authenticationRealm);
            this.__IM.onExit((Object)this, "setAuthenticationRealm$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setAuthenticationRealm$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_setAuthenticationRealm(String authenticationRealm) {
        this.__getlogger().fine("New authentication realm: " + authenticationRealm);
        this.__setauthenticationMngr(new AuthenticationManager(authenticationRealm));
        if (this.__getauthenticationFilter() != null) {
            this.__getauthenticationFilter().setAuthenticationManager(this.__getauthenticationMngr());
        }
        if (this.__getapp() != null) {
            this.__getapp().setAuthenticationManager(this.__getauthenticationMngr());
        }
    }

    public void setSessionPeriod(long sessionPeriod) {
        if (!this.__MsetSessionPeriod$long) {
            this.__M_setSessionPeriod(sessionPeriod);
            return;
        }
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = new Long(sessionPeriod);
            this.__IM.onEntry((Object)this, "setSessionPeriod$long", objectArray);
            this.__M_setSessionPeriod(sessionPeriod);
            this.__IM.onExit((Object)this, "setSessionPeriod$long", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setSessionPeriod$long", throwable);
            throw throwable;
        }
    }

    private void __M_setSessionPeriod(long sessionPeriod) {
        this.__getlogger().fine("New session period: " + sessionPeriod);
        this.__setsessionPeriod(sessionPeriod);
        if (this.__getauthenticationFilter() != null) {
            this.__getauthenticationFilter().setSessionPeriod(sessionPeriod);
        }
    }

    public void setScheduler(IScheduler scheduler) {
        if (!this.__MsetScheduler$net_roboconf_dm_scheduler_IScheduler) {
            this.__M_setScheduler(scheduler);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setScheduler$net_roboconf_dm_scheduler_IScheduler", new Object[]{scheduler});
            this.__M_setScheduler(scheduler);
            this.__IM.onExit((Object)this, "setScheduler$net_roboconf_dm_scheduler_IScheduler", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setScheduler$net_roboconf_dm_scheduler_IScheduler", throwable);
            throw throwable;
        }
    }

    private void __M_setScheduler(IScheduler scheduler) {
        this.__setscheduler(scheduler);
    }

    public void setMavenResolver(MavenResolver mavenResolver) {
        if (!this.__MsetMavenResolver$org_ops4j_pax_url_mvn_MavenResolver) {
            this.__M_setMavenResolver(mavenResolver);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setMavenResolver$org_ops4j_pax_url_mvn_MavenResolver", new Object[]{mavenResolver});
            this.__M_setMavenResolver(mavenResolver);
            this.__IM.onExit((Object)this, "setMavenResolver$org_ops4j_pax_url_mvn_MavenResolver", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setMavenResolver$org_ops4j_pax_url_mvn_MavenResolver", throwable);
            throw throwable;
        }
    }

    private void __M_setMavenResolver(MavenResolver mavenResolver) {
        this.__setmavenResolver(mavenResolver);
    }

    @Override
    public int getCurrentWebSocketClientsCount() {
        int n;
        if (!this.__MgetCurrentWebSocketClientsCount) {
            return this.__M_getCurrentWebSocketClientsCount();
        }
        try {
            this.__IM.onEntry((Object)this, "getCurrentWebSocketClientsCount", new Object[0]);
            n = this.__M_getCurrentWebSocketClientsCount();
            this.__IM.onExit((Object)this, "getCurrentWebSocketClientsCount", (Object)new Integer(n));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getCurrentWebSocketClientsCount", throwable);
            throw throwable;
        }
        return n;
    }

    private int __M_getCurrentWebSocketClientsCount() {
        return WebSocketHandler.getSessionsCount();
    }

    @Override
    public long getWebSocketConnectionErrorsCount() {
        long l;
        if (!this.__MgetWebSocketConnectionErrorsCount) {
            return this.__M_getWebSocketConnectionErrorsCount();
        }
        try {
            this.__IM.onEntry((Object)this, "getWebSocketConnectionErrorsCount", new Object[0]);
            l = this.__M_getWebSocketConnectionErrorsCount();
            this.__IM.onExit((Object)this, "getWebSocketConnectionErrorsCount", (Object)new Long(l));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getWebSocketConnectionErrorsCount", throwable);
            throw throwable;
        }
        return l;
    }

    private long __M_getWebSocketConnectionErrorsCount() {
        return WS_CONNECTION_ERRORS_COUNT.get();
    }

    @Override
    public long getRestRequestsWithAuthFailureCount() {
        long l;
        if (!this.__MgetRestRequestsWithAuthFailureCount) {
            return this.__M_getRestRequestsWithAuthFailureCount();
        }
        try {
            this.__IM.onEntry((Object)this, "getRestRequestsWithAuthFailureCount", new Object[0]);
            l = this.__M_getRestRequestsWithAuthFailureCount();
            this.__IM.onExit((Object)this, "getRestRequestsWithAuthFailureCount", (Object)new Long(l));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getRestRequestsWithAuthFailureCount", throwable);
            throw throwable;
        }
        return l;
    }

    private long __M_getRestRequestsWithAuthFailureCount() {
        return this.__getrestRequestsWithAuthFailureCount().get();
    }

    @Override
    public long getRestRequestsCount() {
        long l;
        if (!this.__MgetRestRequestsCount) {
            return this.__M_getRestRequestsCount();
        }
        try {
            this.__IM.onEntry((Object)this, "getRestRequestsCount", new Object[0]);
            l = this.__M_getRestRequestsCount();
            this.__IM.onExit((Object)this, "getRestRequestsCount", (Object)new Long(l));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getRestRequestsCount", throwable);
            throw throwable;
        }
        return l;
    }

    private long __M_getRestRequestsCount() {
        return this.__getrestRequestsCount().get();
    }

    @Override
    public boolean isAuthenticationRequired() {
        boolean bl;
        if (!this.__MisAuthenticationRequired) {
            return this.__M_isAuthenticationRequired();
        }
        try {
            this.__IM.onEntry((Object)this, "isAuthenticationRequired", new Object[0]);
            bl = this.__M_isAuthenticationRequired();
            this.__IM.onExit((Object)this, "isAuthenticationRequired", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isAuthenticationRequired", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __M_isAuthenticationRequired() {
        return this.__getenableAuthentication();
    }

    @Override
    public boolean isCorsEnabled() {
        boolean bl;
        if (!this.__MisCorsEnabled) {
            return this.__M_isCorsEnabled();
        }
        try {
            this.__IM.onEntry((Object)this, "isCorsEnabled", new Object[0]);
            bl = this.__M_isCorsEnabled();
            this.__IM.onExit((Object)this, "isCorsEnabled", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isCorsEnabled", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __M_isCorsEnabled() {
        return this.__getenableCors();
    }

    @Override
    public void reset() {
        if (!this.__Mreset) {
            this.__M_reset();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "reset", new Object[0]);
            this.__M_reset();
            this.__IM.onExit((Object)this, "reset", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "reset", throwable);
            throw throwable;
        }
    }

    private void __M_reset() {
        this.__getrestRequestsCount().set(0L);
        this.__getrestRequestsWithAuthFailureCount().set(0L);
        WS_CONNECTION_ERRORS_COUNT.set(0L);
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("app")) {
                this.__Fapp = true;
            }
            if (set.contains("authenticationFilter")) {
                this.__FauthenticationFilter = true;
            }
            if (set.contains("authenticationMngr")) {
                this.__FauthenticationMngr = true;
            }
            if (set.contains("bundleContext")) {
                this.__FbundleContext = true;
            }
            if (set.contains("enableAuthentication")) {
                this.__FenableAuthentication = true;
            }
            if (set.contains("enableCors")) {
                this.__FenableCors = true;
            }
            if (set.contains("filterServiceRegistration")) {
                this.__FfilterServiceRegistration = true;
            }
            if (set.contains("httpService")) {
                this.__FhttpService = true;
            }
            if (set.contains("jerseyServlet")) {
                this.__FjerseyServlet = true;
            }
            if (set.contains("logger")) {
                this.__Flogger = true;
            }
            if (set.contains("manager")) {
                this.__Fmanager = true;
            }
            if (set.contains("mavenResolver")) {
                this.__FmavenResolver = true;
            }
            if (set.contains("restRequestsCount")) {
                this.__FrestRequestsCount = true;
            }
            if (set.contains("restRequestsWithAuthFailureCount")) {
                this.__FrestRequestsWithAuthFailureCount = true;
            }
            if (set.contains("scheduler")) {
                this.__Fscheduler = true;
            }
            if (set.contains("sessionPeriod")) {
                this.__FsessionPeriod = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("starting")) {
                this.__Mstarting = true;
            }
            if (set.contains("stopping")) {
                this.__Mstopping = true;
            }
            if (set.contains("schedulerAppears")) {
                this.__MschedulerAppears = true;
            }
            if (set.contains("schedulerDisappears")) {
                this.__MschedulerDisappears = true;
            }
            if (set.contains("mavenResolverAppears")) {
                this.__MmavenResolverAppears = true;
            }
            if (set.contains("mavenResolverDisappears")) {
                this.__MmavenResolverDisappears = true;
            }
            if (set.contains("setHttpService$org_osgi_service_http_HttpService")) {
                this.__MsetHttpService$org_osgi_service_http_HttpService = true;
            }
            if (set.contains("setManager$net_roboconf_dm_management_Manager")) {
                this.__MsetManager$net_roboconf_dm_management_Manager = true;
            }
            if (set.contains("setEnableCors$boolean")) {
                this.__MsetEnableCors$boolean = true;
            }
            if (set.contains("setEnableAuthentication$boolean")) {
                this.__MsetEnableAuthentication$boolean = true;
            }
            if (set.contains("setAuthenticationRealm$java_lang_String")) {
                this.__MsetAuthenticationRealm$java_lang_String = true;
            }
            if (set.contains("setSessionPeriod$long")) {
                this.__MsetSessionPeriod$long = true;
            }
            if (set.contains("setScheduler$net_roboconf_dm_scheduler_IScheduler")) {
                this.__MsetScheduler$net_roboconf_dm_scheduler_IScheduler = true;
            }
            if (set.contains("setMavenResolver$org_ops4j_pax_url_mvn_MavenResolver")) {
                this.__MsetMavenResolver$org_ops4j_pax_url_mvn_MavenResolver = true;
            }
            if (set.contains("getCurrentWebSocketClientsCount")) {
                this.__MgetCurrentWebSocketClientsCount = true;
            }
            if (set.contains("getWebSocketConnectionErrorsCount")) {
                this.__MgetWebSocketConnectionErrorsCount = true;
            }
            if (set.contains("getRestRequestsWithAuthFailureCount")) {
                this.__MgetRestRequestsWithAuthFailureCount = true;
            }
            if (set.contains("getRestRequestsCount")) {
                this.__MgetRestRequestsCount = true;
            }
            if (set.contains("isAuthenticationRequired")) {
                this.__MisAuthenticationRequired = true;
            }
            if (set.contains("isCorsEnabled")) {
                this.__MisCorsEnabled = true;
            }
            if (set.contains("reset")) {
                this.__Mreset = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

