/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.rest.services.internal.annotations;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import net.roboconf.dm.rest.services.internal.RestApplication;

public class RestIndexer {
    public final List<RestOperationBean> restMethods = new ArrayList<RestOperationBean>();
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    public RestIndexer() {
        boolean duplicates = false;
        HashMap<String, String> patternToResourceName = new HashMap<String, String>();
        for (Class<?> clazz : RestApplication.getResourceClasses()) {
            String basePath = "";
            if (clazz.isAnnotationPresent(Path.class)) {
                Path pathAnnotation = clazz.getAnnotation(Path.class);
                basePath = pathAnnotation.value();
            }
            Class<?> superClass = clazz.getInterfaces()[0];
            for (Method m : superClass.getMethods()) {
                String restVerb = null;
                if (m.isAnnotationPresent(POST.class)) {
                    restVerb = "POST";
                } else if (m.isAnnotationPresent(GET.class)) {
                    restVerb = "GET";
                } else if (m.isAnnotationPresent(DELETE.class)) {
                    restVerb = "DELETE";
                } else if (m.isAnnotationPresent(PUT.class)) {
                    restVerb = "PUT";
                }
                if (restVerb == null) continue;
                String subPath = "";
                if (m.isAnnotationPresent(Path.class)) {
                    Path pathAnnotation = m.getAnnotation(Path.class);
                    subPath = pathAnnotation.value();
                }
                RestOperationBean restOperationBean = new RestOperationBean();
                restOperationBean.methodName = m.getName();
                restOperationBean.restVerb = restVerb;
                restOperationBean.jerseyPath = basePath + subPath;
                restOperationBean.urlPattern = restOperationBean.jerseyPath.replaceAll("\\{[^}]+\\}", "[^/]+");
                this.restMethods.add(restOperationBean);
                String key = restVerb + "_" + restOperationBean.urlPattern;
                String assoc = (String)patternToResourceName.get(key);
                if (assoc != null) {
                    duplicates = true;
                    this.logger.severe("Duplicate pattern: " + key + " = " + assoc);
                    continue;
                }
                patternToResourceName.put(key, clazz.getSimpleName() + "_" + m.getName());
            }
        }
        if (duplicates) {
            this.logger.severe("REST methods contain inconsistencies. Audit and permissions checking are currently NOT reliable.");
            throw new RuntimeException("Duplicates were found in URL patterns.");
        }
    }

    public static class RestOperationBean {
        private String methodName;
        private String urlPattern;
        private String jerseyPath;
        private String restVerb;

        public String getMethodName() {
            return this.methodName;
        }

        public String getUrlPattern() {
            return this.urlPattern;
        }

        public String getJerseyPath() {
            return this.jerseyPath;
        }

        public String getRestVerb() {
            return this.restVerb;
        }

        public String toString() {
            return this.methodName;
        }
    }
}

