/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.rest.services.internal.audit;

import java.util.logging.Level;
import java.util.logging.LogRecord;

public class AuditLogRecord
extends LogRecord {
    public static final String LOGGER_NAME = "audit.roboconf.rest.services";
    private static final long serialVersionUID = -463999943841687911L;
    static final String SEPARATOR = " | ";
    static final String ANONYMOUS = "anonymous";
    static final String ALLOWED = "OK";
    static final String BLOCKED = "BLOCKED";
    private static final int PADDING_USER = 30;
    private static final int PADDING_TARGET = 60;
    private static final int PADDING_VERB = 6;
    private static final int PADDING_AUTHORIZED = "BLOCKED".length();
    private static final int PADDING_IP = 16;

    public AuditLogRecord(String user, String targetResource, String targetPath, String restVerb, String ipAddress, String userAgent, boolean authorized) {
        super(AuditLogRecord.findLevel(user, targetResource, authorized), AuditLogRecord.buildMessage(user, targetResource, targetPath, restVerb, ipAddress, userAgent, authorized));
        this.setLoggerName(LOGGER_NAME);
        this.setSourceClassName(null);
        this.setSourceMethodName(null);
    }

    private static String buildMessage(String user, String targetResource, String targetPath, String restVerb, String ipAddress, String userAgent, boolean authorized) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%16s", ipAddress));
        sb.append(SEPARATOR);
        sb.append(String.format("%" + PADDING_AUTHORIZED + "s", authorized ? ALLOWED : BLOCKED));
        sb.append(SEPARATOR);
        sb.append(String.format("%30s", user == null ? ANONYMOUS : user));
        sb.append(SEPARATOR);
        sb.append(String.format("%6s", restVerb));
        sb.append(SEPARATOR);
        sb.append(String.format("%60s", targetResource == null ? "-" : targetResource));
        sb.append(SEPARATOR);
        sb.append(targetPath);
        sb.append(SEPARATOR);
        sb.append(userAgent == null ? "-" : userAgent);
        return sb.toString();
    }

    private static Level findLevel(String user, String targetResource, boolean authorized) {
        Level result = Level.INFO;
        if (user == null) {
            result = Level.SEVERE;
        } else if (!authorized) {
            result = Level.SEVERE;
        } else if (targetResource == null) {
            result = Level.WARNING;
        }
        return result;
    }
}

