/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.rest.services.internal.icons;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.roboconf.core.utils.IconUtils;
import net.roboconf.core.utils.Utils;
import net.roboconf.dm.management.Manager;

public class IconServlet
extends HttpServlet {
    private static final long serialVersionUID = -5151659440091869460L;
    private final transient Manager manager;
    private final transient Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public IconServlet(Manager manager) {
        this.manager = manager;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.logger.finer("An icon was requested for " + req.getPathInfo());
        File f = this.manager.configurationMngr().findIconFromPath(req.getPathInfo());
        if (f == null) {
            resp.setStatus(404);
        } else {
            resp.setContentType(IconUtils.findMimeType((File)f));
            resp.setContentLength((int)f.length());
            ServletOutputStream out = resp.getOutputStream();
            Utils.copyStream((File)f, (OutputStream)out);
            out.flush();
            Utils.closeQuietly((OutputStream)out);
        }
    }
}

