/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.rest.services.internal.resources.impl;

import java.util.logging.Logger;
import javax.ws.rs.Path;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import net.roboconf.core.errors.ErrorCode;
import net.roboconf.core.errors.ErrorDetails;
import net.roboconf.dm.management.Manager;
import net.roboconf.dm.rest.commons.security.AuthenticationManager;
import net.roboconf.dm.rest.services.internal.errors.RestError;
import net.roboconf.dm.rest.services.internal.resources.IAuthenticationResource;
import net.roboconf.dm.rest.services.internal.utils.RestServicesUtils;

@Path(value="/auth")
public class AuthenticationResource
implements IAuthenticationResource {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private AuthenticationManager authenticationManager;
    private final Manager manager;

    public AuthenticationResource(Manager manager) {
        this.manager = manager;
    }

    @Override
    public Response login(String username, String password) {
        Response response;
        this.logger.fine("Authenticating user " + username + "...");
        if (this.authenticationManager == null) {
            response = RestServicesUtils.handleError(Response.Status.INTERNAL_SERVER_ERROR, new RestError(ErrorCode.REST_AUTH_NO_MNGR, new ErrorDetails[0]), RestServicesUtils.lang(this.manager)).build();
            this.logger.fine("No authentication manager was available. User was " + username);
        } else {
            String sessionId = this.authenticationManager.login(username, password);
            if (sessionId == null) {
                response = RestServicesUtils.handleError(Response.Status.FORBIDDEN, new RestError(ErrorCode.REST_AUTH_FAILED, new ErrorDetails[0]), RestServicesUtils.lang(this.manager)).build();
                this.logger.fine("Authentication failed. User was " + username);
            } else {
                Cookie cookie = new Cookie("roboconf-sid", sessionId, "/", null);
                response = Response.ok().cookie(new NewCookie[]{new NewCookie(cookie)}).build();
                this.logger.fine("Authentication succeeded. User was " + username);
            }
        }
        return response;
    }

    @Override
    public Response logout(String sessionId) {
        this.logger.fine("Terminating session " + sessionId + "...");
        if (this.authenticationManager != null) {
            this.authenticationManager.logout(sessionId);
        }
        return Response.ok().build();
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }
}

