/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.rest.services.internal.resources.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import net.roboconf.core.errors.ErrorCode;
import net.roboconf.core.errors.ErrorDetails;
import net.roboconf.core.model.beans.AbstractApplication;
import net.roboconf.core.model.beans.Application;
import net.roboconf.core.model.beans.Component;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.ComponentHelpers;
import net.roboconf.core.model.helpers.InstanceHelpers;
import net.roboconf.dm.management.ManagedApplication;
import net.roboconf.dm.management.Manager;
import net.roboconf.dm.rest.commons.Diagnostic;
import net.roboconf.dm.rest.services.internal.errors.RestError;
import net.roboconf.dm.rest.services.internal.resources.IDebugResource;
import net.roboconf.dm.rest.services.internal.utils.RestServicesUtils;

@Path(value="/debug")
public class DebugResource
implements IDebugResource {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final Manager manager;

    public DebugResource(Manager manager) {
        this.manager = manager;
    }

    @Override
    public Response checkMessagingConnectionForTheDm(String message) {
        this.logger.fine("Request: check the connection to the message queue. message=" + message);
        String lang = RestServicesUtils.lang(this.manager);
        Response response = this.manager.debugMngr().pingMessageQueue(message) ? RestServicesUtils.handleError(Response.Status.OK, new RestError(ErrorCode.REST_DEBUG_AGENT_KO, ErrorDetails.name((String)"ECHO"), ErrorDetails.value((String)message)), lang).build() : RestServicesUtils.handleError(Response.Status.INTERNAL_SERVER_ERROR, new RestError(ErrorCode.REST_MESSAGING_ERROR, new ErrorDetails[0]), lang).build();
        return response;
    }

    @Override
    public Response checkMessagingConnectionWithAgent(String applicationName, String scopedInstancePath, String message) {
        int pingResult;
        Instance instance;
        this.logger.fine("Request: check the connection with agent " + applicationName + " :: " + scopedInstancePath + ". message=" + message);
        ManagedApplication ma = this.manager.applicationMngr().findManagedApplicationByName(applicationName);
        String lang = RestServicesUtils.lang(this.manager);
        Response response = ma == null ? RestServicesUtils.handleError(Response.Status.NOT_FOUND, new RestError(ErrorCode.REST_INEXISTING, ErrorDetails.application((String)applicationName)), lang).build() : ((instance = InstanceHelpers.findInstanceByPath((AbstractApplication)ma.getApplication(), (String)scopedInstancePath)) == null ? RestServicesUtils.handleError(Response.Status.NOT_FOUND, new RestError(ErrorCode.REST_INEXISTING, ErrorDetails.instance((String)scopedInstancePath), ErrorDetails.application((String)applicationName)), lang).build() : ((pingResult = this.manager.debugMngr().pingAgent(ma, instance, message)) == 1 ? RestServicesUtils.handleError(Response.Status.BAD_REQUEST, new RestError(ErrorCode.REST_DEBUG_AGENT_KO, new ErrorDetails[0]), lang).build() : (pingResult == 2 ? RestServicesUtils.handleError(Response.Status.INTERNAL_SERVER_ERROR, new RestError(ErrorCode.REST_MESSAGING_ERROR, new ErrorDetails[0]), lang).build() : RestServicesUtils.handleError(Response.Status.OK, new RestError(ErrorCode.REST_DEBUG_AGENT_KO, ErrorDetails.name((String)"PING"), ErrorDetails.value((String)message)), lang).build())));
        return response;
    }

    @Override
    public Response diagnoseInstance(String applicationName, String instancePath) {
        Instance instance;
        this.logger.fine("Request: create a diagnostic for " + instancePath + " in application " + applicationName);
        Application application = this.manager.applicationMngr().findApplicationByName(applicationName);
        String lang = RestServicesUtils.lang(this.manager);
        Response response = application == null ? RestServicesUtils.handleError(Response.Status.NOT_FOUND, new RestError(ErrorCode.REST_INEXISTING, ErrorDetails.application((String)applicationName)), lang).build() : ((instance = InstanceHelpers.findInstanceByPath((AbstractApplication)application, (String)instancePath)) == null ? RestServicesUtils.handleError(Response.Status.NOT_FOUND, new RestError(ErrorCode.REST_INEXISTING, ErrorDetails.instance((String)instancePath), ErrorDetails.application((String)applicationName)), lang).build() : Response.status((Response.Status)Response.Status.OK).entity((Object)this.createDiagnostic(instance)).build());
        return response;
    }

    @Override
    public List<Diagnostic> diagnoseApplication(String applicationName) {
        this.logger.fine("Request: create a diagnostic for the application called " + applicationName + ".");
        ArrayList<Diagnostic> result = new ArrayList<Diagnostic>();
        Application application = this.manager.applicationMngr().findApplicationByName(applicationName);
        if (application != null) {
            for (Instance inst : InstanceHelpers.getAllInstances((AbstractApplication)application)) {
                result.add(this.createDiagnostic(inst));
            }
        }
        return result;
    }

    Diagnostic createDiagnostic(Instance instance) {
        Diagnostic result = new Diagnostic(InstanceHelpers.computeInstancePath((Instance)instance));
        for (Map.Entry entry : ComponentHelpers.findComponentDependenciesFor((Component)instance.getComponent()).entrySet()) {
            String facetOrComponentName = (String)entry.getKey();
            Collection imports = (Collection)instance.getImports().get(facetOrComponentName);
            boolean resolved = imports != null && !imports.isEmpty();
            boolean optional = (Boolean)entry.getValue();
            result.getDependenciesInformation().add(new Diagnostic.DependencyInformation(facetOrComponentName, optional, resolved));
        }
        return result;
    }
}

