/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.rest.services.internal.resources.impl;

import java.util.List;
import java.util.logging.Logger;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import net.roboconf.core.model.runtime.CommandHistoryItem;
import net.roboconf.dm.management.Manager;
import net.roboconf.dm.rest.services.internal.resources.IHistoryResource;

@Path(value="/history")
public class HistoryResource
implements IHistoryResource {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final Manager manager;

    public HistoryResource(Manager manager) {
        this.manager = manager;
    }

    @Override
    public Response getCommandHistoryNumberOfPages(String applicationName, int itemsPerPage) {
        this.logger.fine("Request: get the number of pages for commands history.");
        int number = this.manager.commandsMngr().getHistoryNumberOfPages(itemsPerPage, applicationName);
        return Response.ok((Object)String.valueOf(number)).build();
    }

    @Override
    public List<CommandHistoryItem> getCommandHistory(int pageNumber, String applicationName, int itemsPerPage, String sortingCriteria, String sortingOrder) {
        if (pageNumber < 1) {
            pageNumber = 1;
        }
        this.logger.fine("Request: get the history of commands execution (page = " + pageNumber + ").");
        return this.manager.commandsMngr().getHistory((pageNumber - 1) * itemsPerPage, itemsPerPage, sortingCriteria, sortingOrder, applicationName);
    }
}

