/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.rest.services.internal.resources.impl;

import com.sun.jersey.core.header.FormDataContentDisposition;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import net.roboconf.core.errors.ErrorCode;
import net.roboconf.core.errors.ErrorDetails;
import net.roboconf.core.model.beans.Application;
import net.roboconf.core.model.beans.ApplicationTemplate;
import net.roboconf.core.urlresolvers.DefaultUrlResolver;
import net.roboconf.core.urlresolvers.IUrlResolver;
import net.roboconf.core.utils.Utils;
import net.roboconf.dm.management.ManagedApplication;
import net.roboconf.dm.management.Manager;
import net.roboconf.dm.management.exceptions.AlreadyExistingException;
import net.roboconf.dm.management.exceptions.InvalidApplicationException;
import net.roboconf.dm.management.exceptions.UnauthorizedActionException;
import net.roboconf.dm.rest.services.internal.errors.RestError;
import net.roboconf.dm.rest.services.internal.resources.IManagementResource;
import net.roboconf.dm.rest.services.internal.utils.MavenUrlResolver;
import net.roboconf.dm.rest.services.internal.utils.RestServicesUtils;
import org.ops4j.pax.url.mvn.MavenResolver;

@Path(value="/applications")
public class ManagementResource
implements IManagementResource {
    private static final Set<String> SUPPORTED_EXTENSIONS;
    public static final long MAX_IMAGE_SIZE = 0x100000L;
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final Manager manager;
    private MavenResolver mavenResolver;

    public ManagementResource(Manager manager) {
        this.manager = manager;
    }

    public void setMavenResolver(MavenResolver mavenResolver) {
        this.mavenResolver = mavenResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response loadUploadedZippedApplicationTemplate(InputStream uploadedInputStream, FormDataContentDisposition fileDetail) {
        Response response;
        this.logger.fine("Request: load application from an uploaded ZIP file (" + fileDetail.getFileName() + ").");
        File tempZipFile = new File(System.getProperty("java.io.tmpdir"), fileDetail.getFileName());
        try {
            Utils.copyStream((InputStream)uploadedInputStream, (File)tempZipFile);
            response = this.loadZippedApplicationTemplate(tempZipFile.toURI().toURL().toString());
        }
        catch (IOException e) {
            try {
                response = RestServicesUtils.handleError(Response.Status.NOT_ACCEPTABLE, new RestError(ErrorCode.REST_MNGMT_ZIP_ERROR, e, new ErrorDetails[0]), RestServicesUtils.lang(this.manager)).build();
            }
            catch (Throwable throwable) {
                Utils.closeQuietly((InputStream)uploadedInputStream);
                Utils.deleteFilesRecursivelyAndQuietly((File[])new File[]{tempZipFile});
                throw throwable;
            }
            Utils.closeQuietly((InputStream)uploadedInputStream);
            Utils.deleteFilesRecursivelyAndQuietly((File[])new File[]{tempZipFile});
        }
        Utils.closeQuietly((InputStream)uploadedInputStream);
        Utils.deleteFilesRecursivelyAndQuietly((File[])new File[]{tempZipFile});
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Response loadZippedApplicationTemplate(String url) {
        Response response;
        this.logger.fine("Request: load application from URL " + url + ".");
        IUrlResolver.ResolvedFile resolvedFile = null;
        File extractionDir = null;
        if (Utils.isEmptyOrWhitespaces((String)url)) {
            return RestServicesUtils.handleError(Response.Status.NOT_ACCEPTABLE, new RestError(ErrorCode.REST_MNGMT_INVALID_URL, ErrorDetails.value((String)url)), RestServicesUtils.lang(this.manager)).build();
        }
        try {
            MavenUrlResolver resolver = this.mavenResolver != null ? new MavenUrlResolver(this.mavenResolver) : new DefaultUrlResolver();
            resolvedFile = resolver.resolve(url);
            extractionDir = new File(System.getProperty("java.io.tmpdir"), "roboconf/" + UUID.randomUUID().toString());
            Utils.extractZipArchive((File)resolvedFile.getFile(), (File)extractionDir);
            response = this.loadUnzippedApplicationTemplate(extractionDir.getAbsolutePath());
        }
        catch (IOException e) {
            try {
                response = RestServicesUtils.handleError(Response.Status.UNAUTHORIZED, new RestError(ErrorCode.REST_SAVE_ERROR, e, new ErrorDetails[0]), RestServicesUtils.lang(this.manager)).build();
            }
            catch (Throwable throwable) {
                Utils.deleteFilesRecursivelyAndQuietly((File[])new File[]{extractionDir});
                if (resolvedFile == null) throw throwable;
                if (resolvedFile.existedBefore()) throw throwable;
                Utils.deleteFilesRecursivelyAndQuietly((File[])new File[]{resolvedFile.getFile()});
                throw throwable;
            }
            Utils.deleteFilesRecursivelyAndQuietly((File[])new File[]{extractionDir});
            if (resolvedFile == null) return response;
            if (resolvedFile.existedBefore()) return response;
            Utils.deleteFilesRecursivelyAndQuietly((File[])new File[]{resolvedFile.getFile()});
            return response;
        }
        Utils.deleteFilesRecursivelyAndQuietly((File[])new File[]{extractionDir});
        if (resolvedFile == null) return response;
        if (resolvedFile.existedBefore()) return response;
        Utils.deleteFilesRecursivelyAndQuietly((File[])new File[]{resolvedFile.getFile()});
        return response;
    }

    @Override
    public Response loadUnzippedApplicationTemplate(String localFilePath) {
        Response response;
        if (localFilePath == null) {
            localFilePath = "null";
        }
        this.logger.fine("Request: load application from a local file (" + localFilePath + ").");
        try {
            ApplicationTemplate tpl = this.manager.applicationTemplateMngr().loadApplicationTemplate(new File(localFilePath));
            response = Response.ok().entity((Object)tpl).build();
        }
        catch (AlreadyExistingException e) {
            response = RestServicesUtils.handleError(Response.Status.FORBIDDEN, new RestError(ErrorCode.REST_MNGMT_CONFLICT, (Exception)((Object)e), new ErrorDetails[0]), RestServicesUtils.lang(this.manager)).build();
        }
        catch (InvalidApplicationException e) {
            response = RestServicesUtils.handleError(Response.Status.NOT_ACCEPTABLE, new RestError(ErrorCode.REST_MNGMT_INVALID_TPL, (Exception)((Object)e), new ErrorDetails[0]), RestServicesUtils.lang(this.manager)).build();
        }
        catch (IOException e) {
            response = RestServicesUtils.handleError(Response.Status.UNAUTHORIZED, new RestError(ErrorCode.REST_SAVE_ERROR, e, new ErrorDetails[0]), RestServicesUtils.lang(this.manager)).build();
        }
        catch (UnauthorizedActionException e) {
            response = RestServicesUtils.handleError(Response.Status.CONFLICT, new RestError(ErrorCode.REST_MNGMT_CONFLICT, (Exception)((Object)e), new ErrorDetails[0]), RestServicesUtils.lang(this.manager)).build();
        }
        return response;
    }

    @Override
    public List<ApplicationTemplate> listApplicationTemplates(String exactName, String exactQualifier, String tag) {
        if (this.logger.isLoggable(Level.FINE)) {
            if (exactName == null && exactQualifier == null) {
                this.logger.fine("Request: list all the application templates.");
            } else {
                StringBuilder sb = new StringBuilder("Request: list/find the application templates");
                if (exactName != null) {
                    sb.append(" with name = ");
                    sb.append(exactName);
                }
                if (exactQualifier != null) {
                    if (exactName != null) {
                        sb.append(" and");
                    }
                    sb.append(" qualifier = ");
                    sb.append(exactQualifier);
                }
                sb.append(".");
                this.logger.fine(sb.toString());
            }
        }
        ArrayList<ApplicationTemplate> result = new ArrayList<ApplicationTemplate>();
        for (ApplicationTemplate tpl : this.manager.applicationTemplateMngr().getApplicationTemplates()) {
            if (exactName != null && !exactName.equals(tpl.getName()) || exactQualifier != null && (!exactQualifier.equals(tpl.getVersion()) || tag != null && !tpl.getTags().contains(tag))) continue;
            result.add(tpl);
        }
        return result;
    }

    @Override
    public List<ApplicationTemplate> listApplicationTemplates() {
        return this.listApplicationTemplates(null, null, null);
    }

    @Override
    public Response deleteApplicationTemplate(String tplName, String tplVersion) {
        this.logger.fine("Request: delete application template " + tplName + " (version = " + tplVersion + ").");
        Response result = Response.ok().build();
        try {
            this.manager.applicationTemplateMngr().deleteApplicationTemplate(tplName, tplVersion);
        }
        catch (InvalidApplicationException e) {
            result = RestServicesUtils.handleError(Response.Status.NOT_FOUND, new RestError(ErrorCode.REST_INEXISTING, (Exception)((Object)e), ErrorDetails.applicationTpl((String)tplName, (String)tplVersion)), RestServicesUtils.lang(this.manager)).build();
        }
        catch (IOException | UnauthorizedActionException e) {
            result = RestServicesUtils.handleError(Response.Status.FORBIDDEN, new RestError(ErrorCode.REST_DELETION_ERROR, (Exception)e, ErrorDetails.applicationTpl((String)tplName, (String)tplVersion)), RestServicesUtils.lang(this.manager)).build();
        }
        return result;
    }

    @Override
    public Response createApplication(Application app) {
        Response result;
        this.logger.fine("Request: create application " + app + ".");
        try {
            String tplName = app.getTemplate() == null ? null : app.getTemplate().getName();
            String tplQualifier = app.getTemplate() == null ? null : app.getTemplate().getVersion();
            String appName = app.getDisplayName() != null ? app.getDisplayName() : app.getName();
            ManagedApplication ma = this.manager.applicationMngr().createApplication(appName, app.getDescription(), tplName, tplQualifier);
            result = Response.ok().entity((Object)ma.getApplication()).build();
        }
        catch (InvalidApplicationException e) {
            result = RestServicesUtils.handleError(Response.Status.NOT_FOUND, new RestError(ErrorCode.REST_MNGMT_INVALID_TPL, (Exception)((Object)e), ErrorDetails.application((Application)app)), RestServicesUtils.lang(this.manager)).build();
        }
        catch (AlreadyExistingException e) {
            result = RestServicesUtils.handleError(Response.Status.FORBIDDEN, new RestError(ErrorCode.REST_MNGMT_CONFLICT, (Exception)((Object)e), ErrorDetails.application((Application)app)), RestServicesUtils.lang(this.manager)).build();
        }
        catch (IOException e) {
            result = RestServicesUtils.handleError(Response.Status.UNAUTHORIZED, new RestError(ErrorCode.REST_SAVE_ERROR, e, ErrorDetails.application((Application)app)), RestServicesUtils.lang(this.manager)).build();
        }
        return result;
    }

    @Override
    public List<Application> listApplications(String exactName) {
        if (exactName != null) {
            this.logger.fine("Request: list/find the application named " + exactName + ".");
        } else {
            this.logger.fine("Request: list all the applications.");
        }
        ArrayList<Application> result = new ArrayList<Application>();
        for (ManagedApplication ma : this.manager.applicationMngr().getManagedApplications()) {
            if (exactName != null && !exactName.equals(ma.getName())) continue;
            result.add(ma.getApplication());
        }
        return result;
    }

    @Override
    public List<Application> listApplications() {
        return this.listApplications(null);
    }

    @Override
    public Response deleteApplication(String applicationName) {
        this.logger.fine("Request: delete application " + applicationName + ".");
        Response result = Response.ok().build();
        try {
            ManagedApplication ma = this.manager.applicationMngr().findManagedApplicationByName(applicationName);
            if (ma == null) {
                result = RestServicesUtils.handleError(Response.Status.NOT_FOUND, new RestError(ErrorCode.REST_INEXISTING, ErrorDetails.application((String)applicationName)), RestServicesUtils.lang(this.manager)).build();
            } else {
                this.manager.applicationMngr().deleteApplication(ma);
            }
        }
        catch (IOException | UnauthorizedActionException e) {
            result = RestServicesUtils.handleError(Response.Status.FORBIDDEN, new RestError(ErrorCode.REST_DELETION_ERROR, (Exception)e, ErrorDetails.application((String)applicationName)), RestServicesUtils.lang(this.manager)).build();
        }
        return result;
    }

    @Override
    public Response shutdownApplication(String applicationName) {
        this.logger.fine("Request: shutdown application " + applicationName + ".");
        Response result = Response.ok().build();
        try {
            ManagedApplication ma = this.manager.applicationMngr().findManagedApplicationByName(applicationName);
            if (ma == null) {
                result = RestServicesUtils.handleError(Response.Status.NOT_FOUND, new RestError(ErrorCode.REST_INEXISTING, ErrorDetails.application((String)applicationName)), RestServicesUtils.lang(this.manager)).build();
            } else {
                this.manager.instancesMngr().undeployAll(ma, null);
            }
        }
        catch (Exception e) {
            result = RestServicesUtils.handleError(Response.Status.FORBIDDEN, new RestError(ErrorCode.REST_MNGMT_APP_SHUTDOWN_ERROR, e, new ErrorDetails[0]), RestServicesUtils.lang(this.manager)).build();
        }
        return result;
    }

    @Override
    public Response setImage(String name, String qualifier, InputStream image, FormDataContentDisposition fileDetail) {
        Response response;
        String id = name + " (qualifier = " + qualifier + ")";
        try {
            this.doSetImage(name, qualifier, image, fileDetail);
            response = Response.noContent().build();
        }
        catch (IllegalArgumentException e) {
            response = RestServicesUtils.handleError(Response.Status.BAD_REQUEST, new RestError(ErrorCode.REST_MNGMT_INVALID_IMAGE, e, new ErrorDetails[0]), RestServicesUtils.lang(this.manager)).build();
        }
        catch (NoSuchElementException e) {
            response = RestServicesUtils.handleError(Response.Status.BAD_REQUEST, new RestError(ErrorCode.REST_INEXISTING, e, ErrorDetails.name((String)id)), RestServicesUtils.lang(this.manager)).build();
        }
        catch (IOException e) {
            response = RestServicesUtils.handleError(Response.Status.INTERNAL_SERVER_ERROR, new RestError(ErrorCode.REST_IO_ERROR, e, new ErrorDetails[0]), RestServicesUtils.lang(this.manager)).build();
        }
        return response;
    }

    private void doSetImage(String name, String qualifier, InputStream image, FormDataContentDisposition fileDetail) throws IOException {
        File targetDir;
        long size = fileDetail.getSize();
        String extension = ManagementResource.getFileExtension(fileDetail.getFileName());
        if (size > 0x100000L) {
            throw new IllegalArgumentException("Image is too large: " + size);
        }
        if (!SUPPORTED_EXTENSIONS.contains(extension)) {
            throw new IllegalArgumentException("Unsupported image file extension: " + extension);
        }
        if (qualifier != null) {
            this.logger.fine("Request: set template image: " + name + '/' + qualifier + ".");
            ApplicationTemplate template = this.manager.applicationTemplateMngr().findTemplate(name, qualifier);
            if (template == null) {
                throw new NoSuchElementException("Cannot find template: " + name + '/' + qualifier);
            }
            targetDir = new File(template.getDirectory(), "descriptor");
        } else {
            this.logger.fine("Request: set application image: " + name + ".");
            Application application = this.manager.applicationMngr().findApplicationByName(name);
            if (application == null) {
                throw new NoSuchElementException("Cannot find application: " + name);
            }
            targetDir = new File(application.getDirectory(), "descriptor");
        }
        for (String ext : SUPPORTED_EXTENSIONS) {
            File f = new File(targetDir, "application." + ext);
            Utils.deleteFilesRecursivelyAndQuietly((File[])new File[]{f});
        }
        Utils.copyStream((InputStream)image, (File)new File(targetDir, "application." + extension));
    }

    private static String getFileExtension(String filename) {
        int p;
        String extension = "";
        int i = filename.lastIndexOf(46);
        if (i > (p = Math.max(filename.lastIndexOf(47), filename.lastIndexOf(92)))) {
            extension = filename.substring(i + 1);
        }
        return extension;
    }

    static {
        HashSet<String> ex = new HashSet<String>();
        ex.add("jpg");
        ex.add("jpeg");
        ex.add("gif");
        ex.add("png");
        ex.add("svg");
        SUPPORTED_EXTENSIONS = Collections.unmodifiableSet(ex);
    }
}

