/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.rest.services.internal.resources.impl;

import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import net.roboconf.core.errors.ErrorCode;
import net.roboconf.core.errors.ErrorDetails;
import net.roboconf.core.model.runtime.Preference;
import net.roboconf.dm.management.Manager;
import net.roboconf.dm.rest.services.internal.errors.RestError;
import net.roboconf.dm.rest.services.internal.resources.IPreferencesResource;
import net.roboconf.dm.rest.services.internal.utils.RestServicesUtils;

@Path(value="/preferences")
public class PreferencesResource
implements IPreferencesResource {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final Manager manager;

    public PreferencesResource(Manager manager) {
        this.manager = manager;
    }

    @Override
    public List<Preference> getPreferences(String key) {
        if (key == null) {
            this.logger.fine("Request: get all the preferences.");
        } else {
            this.logger.fine("Request: get the preferences for key = " + key + ".");
        }
        List result = this.manager.preferencesMngr().getAllPreferences();
        if (key != null) {
            Preference pref = null;
            for (Preference p : result) {
                if (!key.equals(p.getName())) continue;
                pref = p;
                break;
            }
            result.clear();
            if (pref != null) {
                result.add(pref);
            }
        }
        return result;
    }

    @Override
    public Response savePreference(String key, String value) {
        Response response;
        this.logger.fine("Request: save preference " + key + " with value " + value);
        try {
            this.manager.preferencesMngr().save(key, value);
            response = Response.ok().build();
        }
        catch (IOException e) {
            response = RestServicesUtils.handleError(Response.Status.INTERNAL_SERVER_ERROR, new RestError(ErrorCode.REST_SAVE_ERROR, e, ErrorDetails.name((String)key)), RestServicesUtils.lang(this.manager)).build();
        }
        return response;
    }
}

