/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.rest.services.internal.resources.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import net.roboconf.core.errors.ErrorCode;
import net.roboconf.core.errors.ErrorDetails;
import net.roboconf.core.model.runtime.ScheduledJob;
import net.roboconf.dm.management.Manager;
import net.roboconf.dm.rest.commons.json.StringWrapper;
import net.roboconf.dm.rest.services.internal.errors.RestError;
import net.roboconf.dm.rest.services.internal.resources.ISchedulerResource;
import net.roboconf.dm.rest.services.internal.utils.RestServicesUtils;
import net.roboconf.dm.scheduler.IScheduler;

@Path(value="/scheduler")
public class SchedulerResource
implements ISchedulerResource {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final Manager manager;
    IScheduler scheduler;

    public SchedulerResource(Manager manager) {
        this.manager = manager;
    }

    @Override
    public Response saveJob(String jobId, String jobName, String appName, String cmdName, String cron) {
        Response result;
        this.logger.fine("Request: save a new scheduled job as " + jobName + ".");
        try {
            jobId = this.scheduler.saveJob(jobId, jobName, cmdName, cron, appName);
            result = Response.ok((Object)new StringWrapper(jobId)).build();
        }
        catch (IllegalArgumentException e) {
            result = RestServicesUtils.handleError(Response.Status.NOT_FOUND, new RestError(ErrorCode.REST_SAVE_ERROR, e, ErrorDetails.name((String)jobName)), RestServicesUtils.lang(this.manager)).build();
        }
        catch (IOException e) {
            result = RestServicesUtils.handleError(Response.Status.BAD_REQUEST, new RestError(ErrorCode.REST_SAVE_ERROR, e, ErrorDetails.name((String)jobName)), RestServicesUtils.lang(this.manager)).build();
        }
        catch (NullPointerException e) {
            result = RestServicesUtils.handleError(Response.Status.FORBIDDEN, new RestError(ErrorCode.REST_SCHEDULER_IS_UNAVAILABLE, e, ErrorDetails.name((String)jobName)), RestServicesUtils.lang(this.manager)).build();
        }
        return result;
    }

    @Override
    public Response deleteJob(String jobName) {
        this.logger.fine("Request: delete the scheduled job " + jobName + ".");
        Response result = Response.ok().build();
        try {
            this.scheduler.deleteJob(jobName);
        }
        catch (IOException e) {
            result = RestServicesUtils.handleError(Response.Status.INTERNAL_SERVER_ERROR, new RestError(ErrorCode.REST_DELETION_ERROR, e, ErrorDetails.name((String)jobName)), RestServicesUtils.lang(this.manager)).build();
        }
        catch (NullPointerException e) {
            result = RestServicesUtils.handleError(Response.Status.FORBIDDEN, new RestError(ErrorCode.REST_SCHEDULER_IS_UNAVAILABLE, e, ErrorDetails.name((String)jobName)), RestServicesUtils.lang(this.manager)).build();
        }
        return result;
    }

    @Override
    public Response findJobProperties(String jobName) {
        Response result;
        this.logger.fine("Request: get the details of job " + jobName + ".");
        try {
            ScheduledJob job = this.scheduler.findJobProperties(jobName);
            result = job == null ? RestServicesUtils.handleError(Response.Status.NOT_FOUND, new RestError(ErrorCode.REST_INEXISTING, ErrorDetails.name((String)jobName)), RestServicesUtils.lang(this.manager)).build() : Response.ok((Object)job).build();
        }
        catch (NullPointerException e) {
            result = RestServicesUtils.handleError(Response.Status.FORBIDDEN, new RestError(ErrorCode.REST_SCHEDULER_IS_UNAVAILABLE, e, ErrorDetails.name((String)jobName)), RestServicesUtils.lang(this.manager)).build();
        }
        return result;
    }

    @Override
    public List<ScheduledJob> listJobs(String appName, String cmdName) {
        List<Object> result = new ArrayList<ScheduledJob>();
        this.logger.fine("Request: get all the scheduled jobs.");
        try {
            if (appName == null && cmdName == null) {
                result = this.scheduler.listJobs();
            } else if (appName != null) {
                for (ScheduledJob job : this.scheduler.listJobs()) {
                    boolean cmdMatch = cmdName == null || cmdName.equals(job.getCmdName());
                    if (!cmdMatch || !appName.equals(job.getAppName())) continue;
                    result.add(job);
                }
            }
        }
        catch (NullPointerException e) {
            this.logger.warning("Roboconf's scheduler is not available.");
        }
        return result;
    }

    public void setScheduler(IScheduler scheduler) {
        this.scheduler = scheduler;
    }
}

